/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class NGramTokenFilter
extends TokenFilter {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private int minGram;
    private int maxGram;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curGramSize;
    private int curPos;
    private int tokStart;
    private int tokEnd;
    private boolean hasIllegalOffsets;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    public NGramTokenFilter(TokenStream input, int minGram, int maxGram) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    public NGramTokenFilter(TokenStream input) {
        this(input, 1, 2);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.buffer().clone();
                this.curTermLength = this.termAtt.length();
                this.curGramSize = this.minGram;
                this.curPos = 0;
                this.tokStart = this.offsetAtt.startOffset();
                this.tokEnd = this.offsetAtt.endOffset();
                boolean bl = this.hasIllegalOffsets = this.tokStart + this.curTermLength != this.tokEnd;
            }
            while (this.curGramSize <= this.maxGram) {
                if (this.curPos + this.curGramSize <= this.curTermLength) {
                    this.clearAttributes();
                    this.termAtt.copyBuffer(this.curTermBuffer, this.curPos, this.curGramSize);
                    if (this.hasIllegalOffsets) {
                        this.offsetAtt.setOffset(this.tokStart, this.tokEnd);
                    } else {
                        this.offsetAtt.setOffset(this.tokStart + this.curPos, this.tokStart + this.curPos + this.curGramSize);
                    }
                    ++this.curPos;
                    return true;
                }
                ++this.curGramSize;
                this.curPos = 0;
            }
            this.curTermBuffer = null;
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
    }
}

