/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.lucene40.values.Bytes;
import org.apache.lucene.codecs.lucene40.values.DirectSource;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedInts;

class VarStraightBytesImpl {
    static final String CODEC_NAME_IDX = "VarStraightBytesIdx";
    static final String CODEC_NAME_DAT = "VarStraightBytesDat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    VarStraightBytesImpl() {
    }

    public static final class DirectVarStraightSource
    extends DirectSource {
        private final PackedInts.Reader index;

        DirectVarStraightSource(IndexInput data, IndexInput index, DocValues.Type type) throws IOException {
            super(data, type);
            index.readVLong();
            this.index = PackedInts.getDirectReader(index);
        }

        @Override
        protected int position(int docID) throws IOException {
            long offset = this.index.get(docID);
            this.data.seek(this.baseOffset + offset);
            long nextOffset = this.index.get(1 + docID);
            return (int)(nextOffset - offset);
        }
    }

    private static final class VarStraightSource
    extends Bytes.BytesSourceBase {
        private final PackedInts.Reader addresses;

        public VarStraightSource(IndexInput datIn, IndexInput idxIn) throws IOException {
            super(datIn, idxIn, new PagedBytes(15), idxIn.readVLong(), DocValues.Type.BYTES_VAR_STRAIGHT);
            this.addresses = PackedInts.getReader(idxIn);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            long address = this.addresses.get(docID);
            return this.data.fillSlice(bytesRef, address, (int)(this.addresses.get(docID + 1) - address));
        }
    }

    public static class VarStraightReader
    extends Bytes.BytesReaderBase {
        final int maxDoc;

        VarStraightReader(Directory dir, String id, int maxDoc, IOContext context) throws IOException {
            super(dir, id, VarStraightBytesImpl.CODEC_NAME_IDX, VarStraightBytesImpl.CODEC_NAME_DAT, 0, true, context, DocValues.Type.BYTES_VAR_STRAIGHT);
            this.maxDoc = maxDoc;
        }

        @Override
        protected DocValues.Source loadSource() throws IOException {
            return new VarStraightSource(this.cloneData(), this.cloneIndex());
        }

        @Override
        protected DocValues.Source loadDirectSource() throws IOException {
            return new DirectVarStraightSource(this.cloneData(), this.cloneIndex(), this.getType());
        }
    }

    static class Writer
    extends Bytes.BytesWriterBase {
        private long address;
        private int lastDocID = -1;
        private long[] docToAddress;
        private final ByteBlockPool pool;
        private IndexOutput datOut;
        private boolean merge = false;

        public Writer(Directory dir, String id, Counter bytesUsed, IOContext context) {
            super(dir, id, VarStraightBytesImpl.CODEC_NAME_IDX, VarStraightBytesImpl.CODEC_NAME_DAT, 0, bytesUsed, context, DocValues.Type.BYTES_VAR_STRAIGHT);
            this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
            this.docToAddress = new long[1];
            this.pool.nextBuffer();
            bytesUsed.addAndGet(4L);
        }

        private void fill(int docID, long nextAddress) {
            if (docID >= this.docToAddress.length) {
                int oldSize = this.docToAddress.length;
                this.docToAddress = ArrayUtil.grow(this.docToAddress, 1 + docID);
                this.bytesUsed.addAndGet((this.docToAddress.length - oldSize) * 4);
            }
            for (int i = this.lastDocID + 1; i < docID; ++i) {
                this.docToAddress[i] = nextAddress;
            }
        }

        @Override
        public void add(int docID, IndexableField value) throws IOException {
            BytesRef bytes = value.binaryValue();
            assert (bytes != null);
            assert (!this.merge);
            if (bytes.length == 0) {
                return;
            }
            this.fill(docID, this.address);
            this.docToAddress[docID] = this.address;
            this.pool.copy(bytes);
            this.address += (long)bytes.length;
            this.lastDocID = docID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected void merge(DocValues readerIn, int docBase, int docCount, Bits liveDocs) throws IOException {
            block12: {
                block13: {
                    this.merge = true;
                    this.datOut = this.getOrCreateDataOut();
                    success = false;
                    if (liveDocs != null || !(readerIn instanceof VarStraightReader)) ** GOTO lbl46
                    reader = (VarStraightReader)readerIn;
                    maxDocs = reader.maxDoc;
                    if (maxDocs != 0) break block12;
                    if (success) break block13;
                    IOUtils.closeWhileHandlingException(new Closeable[]{this.datOut});
                }
                return;
            }
            try {
                block14: {
                    if (this.lastDocID + 1 < docBase) {
                        this.fill(docBase, this.address);
                        this.lastDocID = docBase - 1;
                    }
                    cloneIdx = reader.cloneIndex();
                    try {
                        numDataBytes = cloneIdx.readVLong();
                        iter = PackedInts.getReaderIterator(cloneIdx, 1024);
                        for (i = 0; i < maxDocs; ++i) {
                            offset = iter.next();
                            ++this.lastDocID;
                            if (this.lastDocID >= this.docToAddress.length) {
                                oldSize = this.docToAddress.length;
                                this.docToAddress = ArrayUtil.grow(this.docToAddress, 1 + this.lastDocID);
                                this.bytesUsed.addAndGet((this.docToAddress.length - oldSize) * 4);
                            }
                            this.docToAddress[this.lastDocID] = this.address + offset;
                        }
                        this.address += numDataBytes;
                    }
                    catch (Throwable var16_14) {
                        IOUtils.close(new Closeable[]{cloneIdx});
                        throw var16_14;
                    }
                    IOUtils.close(new Closeable[]{cloneIdx});
                    cloneData = reader.cloneData();
                    try {
                        this.datOut.copyBytes(cloneData, numDataBytes);
                    }
                    catch (Throwable var17_15) {
                        IOUtils.close(new Closeable[]{cloneData});
                        throw var17_15;
                    }
                    IOUtils.close(new Closeable[]{cloneData});
                    break block14;
lbl46:
                    // 1 sources

                    super.merge(readerIn, docBase, docCount, liveDocs);
                }
                success = true;
                ** if (success) goto lbl-1000
            }
            catch (Throwable var18_16) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(new Closeable[]{this.datOut});
                }
                throw var18_16;
            }
lbl-1000:
            // 1 sources

            {
                IOUtils.closeWhileHandlingException(new Closeable[]{this.datOut});
            }
lbl-1000:
            // 2 sources

            {
            }
        }

        @Override
        protected void mergeDoc(Field scratchField, DocValues.Source source, int docID, int sourceDoc) throws IOException {
            assert (this.merge);
            assert (this.lastDocID < docID);
            source.getBytes(sourceDoc, this.bytesRef);
            if (this.bytesRef.length == 0) {
                return;
            }
            this.fill(docID, this.address);
            this.datOut.writeBytes(this.bytesRef.bytes, this.bytesRef.offset, this.bytesRef.length);
            this.docToAddress[docID] = this.address;
            this.address += (long)this.bytesRef.length;
            this.lastDocID = docID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(int docCount) throws IOException {
            boolean success;
            block17: {
                IndexOutput datOut;
                block16: {
                    success = false;
                    assert (!this.merge && this.datOut == null || this.merge && this.datOut != null);
                    datOut = this.getOrCreateDataOut();
                    try {
                        if (!this.merge) {
                            this.pool.writePool(datOut);
                        }
                        if (!(success = true)) break block16;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(datOut);
                        } else {
                            IOUtils.closeWhileHandlingException(datOut);
                        }
                        this.pool.reset(false, false);
                        throw throwable;
                    }
                    IOUtils.close(datOut);
                    break block17;
                }
                IOUtils.closeWhileHandlingException(datOut);
            }
            this.pool.reset(false, false);
            success = false;
            IndexOutput idxOut = this.getOrCreateIndexOut();
            try {
                if (this.lastDocID == -1) {
                    idxOut.writeVLong(0L);
                    PackedInts.Writer w = PackedInts.getWriter(idxOut, docCount + 1, PackedInts.bitsRequired(0L), 0.2f);
                    for (int i = 0; i < docCount + 1; ++i) {
                        w.add(0L);
                    }
                    w.finish();
                } else {
                    this.fill(docCount, this.address);
                    idxOut.writeVLong(this.address);
                    PackedInts.Writer w = PackedInts.getWriter(idxOut, docCount + 1, PackedInts.bitsRequired(this.address), 0.2f);
                    for (int i = 0; i < docCount; ++i) {
                        w.add(this.docToAddress[i]);
                    }
                    w.add(this.address);
                    w.finish();
                }
                success = true;
                this.bytesUsed.addAndGet(-this.docToAddress.length * 4);
            }
            catch (Throwable throwable) {
                this.bytesUsed.addAndGet(-this.docToAddress.length * 4);
                this.docToAddress = null;
                if (success) {
                    IOUtils.close(idxOut);
                } else {
                    IOUtils.closeWhileHandlingException(idxOut);
                }
                throw throwable;
            }
            this.docToAddress = null;
            if (success) {
                IOUtils.close(idxOut);
            } else {
                IOUtils.closeWhileHandlingException(idxOut);
            }
        }

        public long ramBytesUsed() {
            return this.bytesUsed.get();
        }

        @Override
        public int getValueSize() {
            return -1;
        }
    }
}

