/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.io.Reader;
import java.text.Collator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.collation.CollationAttributeFactory;
import org.apache.lucene.collation.CollationKeyFilter;
import org.apache.lucene.util.Version;

public final class CollationKeyAnalyzer
extends Analyzer {
    private final Collator collator;
    private final CollationAttributeFactory factory;
    private final Version matchVersion;

    public CollationKeyAnalyzer(Version matchVersion, Collator collator) {
        this.matchVersion = matchVersion;
        this.collator = collator;
        this.factory = new CollationAttributeFactory(collator);
    }

    @Deprecated
    public CollationKeyAnalyzer(Collator collator) {
        this(Version.LUCENE_31, collator);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_40)) {
            KeywordTokenizer tokenizer = new KeywordTokenizer(this.factory, reader, 256);
            return new Analyzer.TokenStreamComponents(tokenizer, tokenizer);
        }
        KeywordTokenizer tokenizer = new KeywordTokenizer(reader);
        return new Analyzer.TokenStreamComponents(tokenizer, new CollationKeyFilter(tokenizer, this.collator));
    }
}

