/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class PersistentSnapshotDeletionPolicy
extends SnapshotDeletionPolicy {
    private static final String SNAPSHOTS_ID = "$SNAPSHOTS_DOC$";
    private final IndexWriter writer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readSnapshotsInfo(Directory dir) throws IOException {
        DirectoryReader r = DirectoryReader.open(dir);
        HashMap<String, String> snapshots = new HashMap<String, String>();
        try {
            int numDocs = ((IndexReader)r).numDocs();
            if (numDocs == 1) {
                Document doc = r.document(((IndexReader)r).maxDoc() - 1);
                if (doc.getField(SNAPSHOTS_ID) == null) {
                    throw new IllegalStateException("directory is not a valid snapshots store!");
                }
                doc.removeField(SNAPSHOTS_ID);
                for (IndexableField f : doc) {
                    snapshots.put(f.name(), f.stringValue());
                }
            } else if (numDocs != 0) {
                throw new IllegalStateException("should be at most 1 document in the snapshots directory: " + numDocs);
            }
        }
        finally {
            r.close();
        }
        return snapshots;
    }

    public PersistentSnapshotDeletionPolicy(IndexDeletionPolicy primary, Directory dir, IndexWriterConfig.OpenMode mode, Version matchVersion) throws IOException {
        super(primary, null);
        this.writer = new IndexWriter(dir, new IndexWriterConfig(matchVersion, null).setOpenMode(mode));
        if (mode != IndexWriterConfig.OpenMode.APPEND) {
            this.writer.commit();
        }
        try {
            for (Map.Entry<String, String> e : PersistentSnapshotDeletionPolicy.readSnapshotsInfo(dir).entrySet()) {
                this.registerSnapshotInfo(e.getKey(), e.getValue(), null);
            }
        }
        catch (RuntimeException e) {
            this.writer.close();
            throw e;
        }
        catch (IOException e) {
            this.writer.close();
            throw e;
        }
    }

    @Override
    public synchronized void onInit(List<? extends IndexCommit> commits) throws IOException {
        super.onInit(commits);
        this.persistSnapshotInfos(null, null);
    }

    @Override
    public synchronized IndexCommit snapshot(String id) throws IOException {
        this.checkSnapshotted(id);
        if (SNAPSHOTS_ID.equals(id)) {
            throw new IllegalArgumentException(id + " is reserved and cannot be used as a snapshot id");
        }
        this.persistSnapshotInfos(id, this.lastCommit.getSegmentsFileName());
        return super.snapshot(id);
    }

    @Override
    public synchronized void release(String id) throws IOException {
        super.release(id);
        this.persistSnapshotInfos(null, null);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private void persistSnapshotInfos(String id, String segment) throws IOException {
        this.writer.deleteAll();
        Document d = new Document();
        FieldType ft = new FieldType();
        ft.setStored(true);
        d.add(new Field(SNAPSHOTS_ID, "", ft));
        for (Map.Entry<String, String> e : super.getSnapshots().entrySet()) {
            d.add(new Field(e.getKey(), e.getValue(), ft));
        }
        if (id != null) {
            d.add(new Field(id, segment, ft));
        }
        this.writer.addDocument(d);
        this.writer.commit();
    }
}

