/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import com.ibm.icu.text.Normalizer;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class ICUNormalizationFilter
extends TokenFilter {
    private final Normalizer.Mode mode;
    private char[] buffer = new char[4096];
    private CharTermAttribute termAtt;

    public ICUNormalizationFilter(TokenStream input, Normalizer.Mode mode) {
        super(input);
        this.mode = mode;
        this.termAtt = this.addAttribute(CharTermAttribute.class);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int length;
            char[] src = this.termAtt.buffer();
            if (Normalizer.quickCheck(src, 0, length = this.termAtt.length(), this.mode, 0) == Normalizer.YES) {
                return true;
            }
            while (true) {
                try {
                    int newLength = Normalizer.normalize(src, 0, length, this.buffer, 0, this.buffer.length, this.mode, 0);
                    this.termAtt.resizeBuffer(newLength);
                    return true;
                }
                catch (IndexOutOfBoundsException e) {
                    this.buffer = new char[ICUNormalizationFilter.getNextSize(this.buffer.length << 1)];
                    continue;
                }
                break;
            }
        }
        return false;
    }

    public static int getNextSize(int targetSize) {
        return (targetSize >> 3) + (targetSize < 9 ? 3 : 6) + targetSize;
    }
}

