/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import com.ibm.icu.text.Transliterator;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.musicbrainz.search.LuceneVersion;
import org.musicbrainz.search.analysis.AccentFilter;
import org.musicbrainz.search.analysis.AmpersandToAndMappingHelper;
import org.musicbrainz.search.analysis.CharEquivToCharHelper;
import org.musicbrainz.search.analysis.HebrewCharMappingHelper;
import org.musicbrainz.search.analysis.ICUTransformFilter;
import org.musicbrainz.search.analysis.LowercaseFilter;
import org.musicbrainz.search.analysis.MusicbrainzTokenizer;
import org.musicbrainz.search.analysis.MusicbrainzTokenizerFilter;
import org.musicbrainz.search.analysis.MusicbrainzWordDelimiterFilter;
import org.musicbrainz.search.analysis.PatternReplaceCharFilter;
import org.musicbrainz.search.analysis.WordDelimiterIterator;

public class TitleAnalyzer
extends Analyzer {
    private NormalizeCharMap charConvertMap;
    private Pattern no1Pattern = Pattern.compile("(no\\.) (\\d+)", 2);
    private String no1PatternReplacement = "$1$2";

    private void setCharConvertMap() {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        AmpersandToAndMappingHelper.addToMap(builder);
        CharEquivToCharHelper.addToMap(builder);
        HebrewCharMappingHelper.addToMap(builder);
        this.charConvertMap = builder.build();
    }

    public TitleAnalyzer() {
        this.setCharConvertMap();
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        MusicbrainzTokenizer source = new MusicbrainzTokenizer(LuceneVersion.LUCENE_VERSION, reader);
        TokenFilter filter = new ICUTransformFilter(source, Transliterator.getInstance("[\u30fc[:Script=Katakana:]]Katakana-Hiragana"));
        filter = new ICUTransformFilter(filter, Transliterator.getInstance("Traditional-Simplified"));
        filter = new MusicbrainzTokenizerFilter(filter);
        filter = new AccentFilter(filter);
        filter = new LowercaseFilter(filter);
        filter = new MusicbrainzWordDelimiterFilter(filter, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, 1, 0, 0, 6, 0, 0, 0, 0, 0, null);
        return new Analyzer.TokenStreamComponents(source, filter);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        return new PatternReplaceCharFilter(this.no1Pattern, this.no1PatternReplacement, new MappingCharFilter(this.charConvertMap, reader));
    }
}

