/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.AliasList;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.ArtistCreditWrapper;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;

public class ArtistCreditHelper {
    public static String buildFullArtistCreditName(ArtistCredit artistCredit) {
        StringBuffer sb = new StringBuffer();
        for (NameCredit nameCredit : artistCredit.getNameCredit()) {
            if (nameCredit.getName() != null) {
                sb.append(nameCredit.getName());
            } else {
                sb.append(nameCredit.getArtist().getName());
            }
            if (nameCredit.getJoinphrase() == null) continue;
            sb.append(' ' + nameCredit.getJoinphrase() + ' ');
        }
        return sb.toString();
    }

    public static ArtistCredit unserialize(String artistCreditSerilized) {
        return (ArtistCredit)MMDSerializer.unserialize(artistCreditSerilized, ArtistCredit.class);
    }

    public static Map<Integer, ArtistCreditWrapper> completeArtistCreditFromDbResults(ResultSet rs, String entityKey, String artistCreditId, String artistId, String artistName, String artistSortName, String comment, String joinPhrase, String artistCreditName, String aliasName) throws SQLException {
        HashMap<Integer, ArtistCreditWrapper> artistCredits = new HashMap<Integer, ArtistCreditWrapper>();
        ObjectFactory of = new ObjectFactory();
        while (rs.next()) {
            String nameCredit;
            String engAlias;
            ArtistCredit ac;
            ArtistCreditWrapper acw;
            int entityId = rs.getInt(entityKey);
            if (!artistCredits.containsKey(entityId)) {
                acw = new ArtistCreditWrapper();
                acw.setArtistCreditId(rs.getInt(artistCreditId));
                ac = of.createArtistCredit();
                acw.setArtistCredit(ac);
                artistCredits.put(entityId, acw);
            } else {
                acw = (ArtistCreditWrapper)artistCredits.get(entityId);
                ac = acw.getArtistCredit();
            }
            NameCredit nc = of.createNameCredit();
            Artist artist = of.createArtist();
            artist.setId(rs.getString(artistId));
            artist.setName(rs.getString(artistName));
            artist.setSortName(rs.getString(artistSortName));
            String disamb = rs.getString(comment);
            if (disamb != null && !disamb.isEmpty()) {
                artist.setDisambiguation(disamb);
            }
            if ((engAlias = rs.getString(aliasName)) != null && engAlias.length() > 0) {
                Alias alias = of.createAlias();
                alias.setContent(engAlias);
                AliasList al = of.createAliasList();
                al.getAlias().add(alias);
                artist.setAliasList(al);
            }
            nc.setArtist(artist);
            String jp = rs.getString(joinPhrase);
            if (jp != null && !jp.isEmpty()) {
                nc.setJoinphrase(jp);
            }
            if (!(nameCredit = rs.getString(artistCreditName)).equals(artist.getName())) {
                nc.setName(nameCredit);
            }
            ac.getNameCredit().add(nc);
        }
        return artistCredits;
    }

    public static void buildIndexFieldsFromArtistCredit(MbDocument doc, ArtistCredit ac, IndexField artist, IndexField artistNameCredit, IndexField artistId, IndexField artistName, IndexField artistCredit) {
        if (ac != null) {
            doc.addField(artist, ArtistCreditHelper.buildFullArtistCreditName(ac));
            for (NameCredit nc : ac.getNameCredit()) {
                if (nc.getName() != null) {
                    doc.addField(artistNameCredit, nc.getName());
                } else {
                    doc.addField(artistNameCredit, nc.getArtist().getName());
                }
                doc.addField(artistId, nc.getArtist().getId());
                doc.addField(artistName, nc.getArtist().getName());
                if (nc.getArtist().getAliasList() == null) continue;
                doc.addField(artistName, nc.getArtist().getAliasList().getAlias().get(0).getContent());
            }
            doc.addField(artistCredit, MMDSerializer.serialize(ac));
        }
    }

    public static void buildIndexFieldsOnlyFromArtistCredit(MbDocument doc, ArtistCredit ac, IndexField artist, IndexField artistNameCredit, IndexField artistId, IndexField artistName) {
        if (ac != null) {
            doc.addField(artist, ArtistCreditHelper.buildFullArtistCreditName(ac));
            for (NameCredit nc : ac.getNameCredit()) {
                if (nc.getName() != null) {
                    doc.addField(artistNameCredit, nc.getName());
                } else {
                    doc.addField(artistNameCredit, nc.getArtist().getName());
                }
                doc.addField(artistId, nc.getArtist().getId());
                doc.addField(artistName, nc.getArtist().getName());
                if (nc.getArtist().getAliasList() == null) continue;
                doc.addField(artistName, nc.getArtist().getAliasList().getAlias().get(0).getContent());
            }
        }
    }
}

