/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.CDStubIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;

public class CDStubIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "cdstub";

    public CDStubIndex() {
    }

    public CDStubIndex(Connection dbConnection) {
        super(dbConnection);
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(CDStubIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return CDStubIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(release_raw.id) FROM release_raw");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM release_raw WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("CDSTUBS", "SELECT release_raw.id, release_raw.title, release_raw.artist, barcode, comment, discid, added, count(track_raw.id) as tracks  FROM release_raw   JOIN cdtoc_raw ON release_raw.id = cdtoc_raw.release   JOIN track_raw ON track_raw.release = release_raw.id  WHERE release_raw.id BETWEEN ? AND ?  GROUP BY release_raw.title, release_raw.id, release_raw.artist, barcode, comment, discid, added");
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("CDSTUBS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs) throws SQLException {
        MbDocument doc = new MbDocument();
        doc.addField((IndexField)CDStubIndexField.ID, rs.getString("id"));
        doc.addNonEmptyField(CDStubIndexField.TITLE, rs.getString("title"));
        doc.addNonEmptyField(CDStubIndexField.ARTIST, rs.getString("artist"));
        doc.addNonEmptyField(CDStubIndexField.DISCID, rs.getString("discid"));
        if (rs.getTimestamp("added") != null) {
            doc.addNumericField((IndexField)CDStubIndexField.ADDED, rs.getTimestamp("added").getTime());
        }
        doc.addNonEmptyField(CDStubIndexField.NUM_TRACKS, rs.getString("tracks"));
        doc.addNonEmptyField(CDStubIndexField.BARCODE, rs.getString("barcode"));
        doc.addFieldOrNoValue(CDStubIndexField.COMMENT, rs.getString("comment"));
        return doc.getLuceneDocument();
    }
}

