/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SortField;

public abstract class ValueSource {
    public abstract FunctionValues getValues(Map var1, AtomicReaderContext var2) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
    }

    public static Map newContext(IndexSearcher searcher) {
        IdentityHashMap<String, IndexSearcher> context = new IdentityHashMap<String, IndexSearcher>();
        context.put("searcher", searcher);
        return context;
    }

    public SortField getSortField(boolean reverse) {
        return new ValueSourceSortField(reverse);
    }

    class ValueSourceComparator
    extends FieldComparator<Double> {
        private final double[] values;
        private FunctionValues docVals;
        private double bottom;
        private final Map fcontext;
        private double topValue;

        ValueSourceComparator(Map fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) {
            return Double.compare(this.bottom, this.docVals.doubleVal(doc));
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        @Override
        public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, context);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Double value) {
            this.topValue = value;
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) {
            double docValue = this.docVals.doubleVal(doc);
            return Double.compare(this.topValue, docValue);
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map context;

        public ValueSourceComparatorSource(Map context) {
            this.context = context;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField {
        public ValueSourceSortField(boolean reverse) {
            super(ValueSource.this.description(), SortField.Type.REWRITEABLE, reverse);
        }

        @Override
        public SortField rewrite(IndexSearcher searcher) throws IOException {
            Map context = ValueSource.newContext(searcher);
            ValueSource.this.createWeight(context, searcher);
            return new SortField(this.getField(), new ValueSourceComparatorSource(context), this.getReverse());
        }
    }
}

