/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.helper;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;

public class TagHelper {
    public static String constructTagQuery(String tagTableName, String entityColName) {
        return "SELECT t1." + entityColName + ", t2.name as tag, t1.count as count  FROM " + tagTableName + " t1  INNER JOIN tag t2 ON tag=id  WHERE t1." + entityColName + " between ? AND ?";
    }

    public static Map<Integer, List<Tag>> loadTags(int min, int max, PreparedStatement st, String entityKey) throws SQLException, IOException {
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, List<Tag>> tags = TagHelper.completeTagsFromDbResults(rs, entityKey);
        rs.close();
        return tags;
    }

    public static Map<Integer, List<Tag>> completeTagsFromDbResults(ResultSet rs, String entityKey) throws SQLException {
        HashMap<Integer, List<Tag>> tags = new HashMap<Integer, List<Tag>>();
        ObjectFactory of = new ObjectFactory();
        while (rs.next()) {
            List<Tag> tagList;
            int entityId = rs.getInt(entityKey);
            if (!tags.containsKey(entityId)) {
                tagList = new ArrayList();
                tags.put(entityId, tagList);
            } else {
                tagList = (List)tags.get(entityId);
            }
            Tag tag = of.createTag();
            tag.setName(rs.getString("tag"));
            tag.setCount(BigInteger.valueOf(rs.getInt("count")));
            tagList.add(tag);
        }
        return tags;
    }

    public static TagList addTagsToDocAndConstructTagList(ObjectFactory of, MbDocument doc, Map<Integer, List<Tag>> tags, int entityId, IndexField aliasIndexField) {
        TagList tagList = of.createTagList();
        for (Tag nextTag : tags.get(entityId)) {
            Tag tag = of.createTag();
            doc.addField(aliasIndexField, nextTag.getName());
            tag.setName(nextTag.getName());
            tag.setCount(new BigInteger(nextTag.getCount().toString()));
            tagList.getTag().add(tag);
        }
        return tagList;
    }
}

