/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public abstract class DocTermsIndexDocValues
extends FunctionValues {
    protected final FieldCache.DocTermsIndex termsIndex;
    protected final ValueSource vs;
    protected final MutableValueStr val = new MutableValueStr();
    protected final BytesRef spare = new BytesRef();
    protected final CharsRef spareChars = new CharsRef();

    public DocTermsIndexDocValues(ValueSource vs, AtomicReaderContext context, String field) throws IOException {
        try {
            this.termsIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), field);
        }
        catch (RuntimeException e) {
            throw new DocTermsIndexException(field, e);
        }
        this.vs = vs;
    }

    public FieldCache.DocTermsIndex getDocTermsIndex() {
        return this.termsIndex;
    }

    protected abstract String toTerm(String var1);

    @Override
    public boolean exists(int doc) {
        return this.termsIndex.getOrd(doc) != 0;
    }

    @Override
    public boolean bytesVal(int doc, BytesRef target) {
        int ord = this.termsIndex.getOrd(doc);
        if (ord == 0) {
            target.length = 0;
            return false;
        }
        this.termsIndex.lookup(ord, target);
        return true;
    }

    @Override
    public String strVal(int doc) {
        int ord = this.termsIndex.getOrd(doc);
        if (ord == 0) {
            return null;
        }
        this.termsIndex.lookup(ord, this.spare);
        UnicodeUtil.UTF8toUTF16(this.spare, this.spareChars);
        return this.spareChars.toString();
    }

    @Override
    public boolean boolVal(int doc) {
        return this.exists(doc);
    }

    @Override
    public abstract Object objectVal(int var1);

    @Override
    public ValueSourceScorer getRangeScorer(IndexReader reader, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        lowerVal = lowerVal == null ? null : this.toTerm(lowerVal);
        upperVal = upperVal == null ? null : this.toTerm(upperVal);
        BytesRef spare = new BytesRef();
        int lower = Integer.MIN_VALUE;
        if (lowerVal != null) {
            lower = this.termsIndex.binarySearchLookup(new BytesRef(lowerVal), spare);
            if (lower < 0) {
                lower = -lower - 1;
            } else if (!includeLower) {
                ++lower;
            }
        }
        int upper = Integer.MAX_VALUE;
        if (upperVal != null) {
            upper = this.termsIndex.binarySearchLookup(new BytesRef(upperVal), spare);
            if (upper < 0) {
                upper = -upper - 2;
            } else if (!includeUpper) {
                --upper;
            }
        }
        final int ll = lower;
        final int uu = upper;
        return new ValueSourceScorer(reader, this){

            @Override
            public boolean matchesValue(int doc) {
                int ord = DocTermsIndexDocValues.this.termsIndex.getOrd(doc);
                return ord >= ll && ord <= uu;
            }
        };
    }

    @Override
    public String toString(int doc) {
        return this.vs.description() + '=' + this.strVal(doc);
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueStr mval = new MutableValueStr();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) {
                int ord = DocTermsIndexDocValues.this.termsIndex.getOrd(doc);
                this.mval.exists = ord != 0;
                this.mval.value = DocTermsIndexDocValues.this.termsIndex.lookup(ord, this.mval.value);
            }
        };
    }

    public static final class DocTermsIndexException
    extends RuntimeException {
        public DocTermsIndexException(String fieldName, RuntimeException cause) {
            super("Can't initialize DocTermsIndex to generate (function) FunctionValues for field: " + fieldName, cause);
        }
    }
}

