/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.collation.ICUCollationKeyFilter;
import org.apache.lucene.util.IOUtils;

@Deprecated
public class ICUCollationKeyFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent,
ResourceLoaderAware {
    private Collator collator;
    private final String custom;
    private final String localeID;
    private final String strength;
    private final String decomposition;
    private final String alternate;
    private final String caseLevel;
    private final String caseFirst;
    private final String numeric;
    private final String variableTop;

    public ICUCollationKeyFilterFactory(Map<String, String> args) {
        super(args);
        this.custom = args.remove("custom");
        this.localeID = args.remove("locale");
        this.strength = args.remove("strength");
        this.decomposition = args.remove("decomposition");
        this.alternate = args.remove("alternate");
        this.caseLevel = args.remove("caseLevel");
        this.caseFirst = args.remove("caseFirst");
        this.numeric = args.remove("numeric");
        this.variableTop = args.remove("variableTop");
        if (this.custom == null && this.localeID == null) {
            throw new IllegalArgumentException("Either custom or locale is required.");
        }
        if (this.custom != null && this.localeID != null) {
            throw new IllegalArgumentException("Cannot specify both locale and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.collator = this.localeID != null ? this.createFromLocale(this.localeID) : this.createFromRules(this.custom, loader);
        if (this.strength != null) {
            if (this.strength.equalsIgnoreCase("primary")) {
                this.collator.setStrength(0);
            } else if (this.strength.equalsIgnoreCase("secondary")) {
                this.collator.setStrength(1);
            } else if (this.strength.equalsIgnoreCase("tertiary")) {
                this.collator.setStrength(2);
            } else if (this.strength.equalsIgnoreCase("quaternary")) {
                this.collator.setStrength(3);
            } else if (this.strength.equalsIgnoreCase("identical")) {
                this.collator.setStrength(15);
            } else {
                throw new IllegalArgumentException("Invalid strength: " + this.strength);
            }
        }
        if (this.decomposition != null) {
            if (this.decomposition.equalsIgnoreCase("no")) {
                this.collator.setDecomposition(16);
            } else if (this.decomposition.equalsIgnoreCase("canonical")) {
                this.collator.setDecomposition(17);
            } else {
                throw new IllegalArgumentException("Invalid decomposition: " + this.decomposition);
            }
        }
        RuleBasedCollator rbc = (RuleBasedCollator)this.collator;
        if (this.alternate != null) {
            if (this.alternate.equalsIgnoreCase("shifted")) {
                rbc.setAlternateHandlingShifted(true);
            } else if (this.alternate.equalsIgnoreCase("non-ignorable")) {
                rbc.setAlternateHandlingShifted(false);
            } else {
                throw new IllegalArgumentException("Invalid alternate: " + this.alternate);
            }
        }
        if (this.caseLevel != null) {
            rbc.setCaseLevel(Boolean.parseBoolean(this.caseLevel));
        }
        if (this.caseFirst != null) {
            if (this.caseFirst.equalsIgnoreCase("lower")) {
                rbc.setLowerCaseFirst(true);
            } else if (this.caseFirst.equalsIgnoreCase("upper")) {
                rbc.setUpperCaseFirst(true);
            } else {
                throw new IllegalArgumentException("Invalid caseFirst: " + this.caseFirst);
            }
        }
        if (this.numeric != null) {
            rbc.setNumericCollation(Boolean.parseBoolean(this.numeric));
        }
        if (this.variableTop != null) {
            rbc.setVariableTop(this.variableTop);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ICUCollationKeyFilter(input, this.collator);
    }

    private Collator createFromLocale(String localeID) {
        return Collator.getInstance(new ULocale(localeID));
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        RuleBasedCollator ruleBasedCollator;
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = this.toUTF8String(input);
            ruleBasedCollator = new RuleBasedCollator(rules);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(input);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(input);
        return ruleBasedCollator;
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        return this;
    }

    private String toUTF8String(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        Reader r = IOUtils.getDecodingReader(in, StandardCharsets.UTF_8);
        int len = 0;
        while ((len = r.read(buffer)) > 0) {
            sb.append(buffer, 0, len);
        }
        return sb.toString();
    }
}

