/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.helper;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.musicbrainz.mmd2.DefDirection;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Recording;
import org.musicbrainz.mmd2.Relation;
import org.musicbrainz.mmd2.RelationList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;

public class LinkedRecordingsHelper {
    public static String constructRelationQuery(String relationTableName, String entityTableName, boolean isLinkedEntityFirst) {
        StringBuilder sb = new StringBuilder(" SELECT aw.id as awid, l.id as lid, w.id as wid, w.gid, a.gid as aid, a.name as name,  lt.name as link, lat.name as attribute FROM " + relationTableName + " aw");
        if (isLinkedEntityFirst) {
            sb.append(" INNER JOIN recording a ON a.id    = aw.entity0 INNER JOIN " + entityTableName + " w ON w.id     = aw.entity1");
        } else {
            sb.append(" INNER JOIN recording a ON a.id    = aw.entity1 INNER JOIN " + entityTableName + " w ON w.id     = aw.entity0");
        }
        sb.append(" INNER JOIN link l ON aw.link = l.id  INNER JOIN link_type lt on l.link_type=lt.id LEFT JOIN  link_attribute la on la.link=l.id LEFT JOIN  link_attribute_type lat on la.attribute_type=lat.id WHERE w.id BETWEEN ? AND ?   ORDER BY aw.id");
        return sb.toString();
    }

    public static ArrayListMultimap<Integer, Relation> loadRelations(int min, int max, PreparedStatement st) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        ArrayListMultimap<Integer, Relation> recordings = ArrayListMultimap.create();
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        int lastLinkId = -1;
        Relation lastRelation = null;
        while (rs.next()) {
            int linkId = rs.getInt("awid");
            if (linkId == lastLinkId) {
                Relation.AttributeList.Attribute attribute = of.createRelationAttributeListAttribute();
                attribute.setContent(rs.getString("attribute"));
                Relation.AttributeList attributeList = lastRelation.getAttributeList();
                attributeList.getAttribute().add(attribute);
                continue;
            }
            int entityId = rs.getInt("wid");
            Relation relation = of.createRelation();
            Recording recording = of.createRecording();
            recording.setId(rs.getString("aid"));
            recording.setTitle(rs.getString("name"));
            relation.setRecording(recording);
            relation.setType(rs.getString("link"));
            relation.setDirection(DefDirection.BACKWARD);
            String attributeValue = rs.getString("attribute");
            if (!Strings.isNullOrEmpty(attributeValue)) {
                Relation.AttributeList attributeList = of.createRelationAttributeList();
                relation.setAttributeList(attributeList);
                Relation.AttributeList.Attribute attribute = new ObjectFactory().createRelationAttributeListAttribute();
                attribute.setContent(attributeValue);
                attributeList.getAttribute().add(attribute);
            }
            recordings.put((Object)entityId, (Object)relation);
            lastRelation = relation;
            lastLinkId = linkId;
        }
        rs.close();
        return recordings;
    }

    public static RelationList addToDocAndConstructList(ObjectFactory of, MbDocument doc, List<Relation> rl, IndexField idIndexField, IndexField nameIndexField) {
        RelationList relationList = of.createRelationList();
        relationList.setTargetType("recording");
        for (Relation r : rl) {
            relationList.getRelation().add(r);
            doc.addField(idIndexField, r.getRecording().getId());
            doc.addField(nameIndexField, r.getRecording().getTitle());
        }
        return relationList;
    }
}

