/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.IswcList;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Relation;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.Work;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.AliasHelper;
import org.musicbrainz.search.helper.LinkedArtistsHelper;
import org.musicbrainz.search.helper.LinkedRecordingsHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.WorkIndexField;

public class WorkIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "work";

    public WorkIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public WorkIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(WorkIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return WorkIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM work");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM work WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("work_tag", INDEX_NAME));
        this.addPreparedStatement("ALIASES", AliasHelper.constructAliasQuery(INDEX_NAME));
        this.addPreparedStatement("ARTISTS", LinkedArtistsHelper.constructRelationQuery("l_artist_work", INDEX_NAME, true));
        this.addPreparedStatement("RECORDINGS", LinkedRecordingsHelper.constructRelationQuery("l_recording_work", INDEX_NAME, true));
        this.addPreparedStatement("ISWCS", "SELECT work, iswc FROM iswc  WHERE work BETWEEN ? AND ?");
        this.addPreparedStatement("WORKS", "SELECT w.id as wid, w.gid, w.name as name, wt.name as type, l.iso_code_3 as language, comment  FROM work AS w   LEFT JOIN work_type wt ON w.type = wt.id   LEFT JOIN language l on w.language = l.id  WHERE w.id BETWEEN ? AND ?  ORDER BY w.id");
    }

    private Map<Integer, List<String>> loadISWCs(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> iswcs = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("ISWCS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int workId = rs.getInt(INDEX_NAME);
            if (!iswcs.containsKey(workId)) {
                list = new LinkedList();
                iswcs.put(workId, list);
            } else {
                list = (List)iswcs.get(workId);
            }
            list.add(rs.getString("iswc"));
        }
        rs.close();
        return iswcs;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        ArrayListMultimap<Integer, Relation> artistRelations = LinkedArtistsHelper.loadRelations(min, max, this.getPreparedStatement("ARTISTS"));
        ArrayListMultimap<Integer, Relation> recordingRelations = LinkedRecordingsHelper.loadRelations(min, max, this.getPreparedStatement("RECORDINGS"));
        Map<Integer, Set<Alias>> aliases = AliasHelper.completeFromDbResults(min, max, this.getPreparedStatement("ALIASES"));
        Map<Integer, List<String>> iswcs = this.loadISWCs(min, max);
        PreparedStatement st = this.getPreparedStatement("WORKS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, artistRelations, recordingRelations, aliases, iswcs));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, ArrayListMultimap<Integer, Relation> artistRelations, ArrayListMultimap<Integer, Relation> recordingRelations, Map<Integer, Set<Alias>> aliases, Map<Integer, List<String>> iswcs) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Work work = of.createWork();
        int id = rs.getInt("wid");
        String guid = rs.getString("gid");
        doc.addField((IndexField)WorkIndexField.ID, id);
        doc.addField((IndexField)WorkIndexField.WORK_ID, guid);
        work.setId(guid);
        String name = rs.getString("name");
        doc.addField((IndexField)WorkIndexField.WORK, name);
        doc.addField((IndexField)WorkIndexField.WORK_ACCENT, name);
        work.setTitle(name);
        String language = rs.getString("language");
        doc.addFieldOrNoValue(WorkIndexField.LYRICS_LANG, language);
        if (!Strings.isNullOrEmpty(language)) {
            work.setLanguage(language);
        }
        String type = rs.getString("type");
        doc.addFieldOrNoValue(WorkIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            work.setType(type);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(WorkIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            work.setDisambiguation(comment);
        }
        if (artistRelations.containsKey(id)) {
            work.getRelationList().add(LinkedArtistsHelper.addToDocAndConstructList(of, doc, artistRelations.get((Object)id), WorkIndexField.ARTIST_ID, WorkIndexField.ARTIST));
        }
        if (recordingRelations.containsKey(id)) {
            work.getRelationList().add(LinkedRecordingsHelper.addToDocAndConstructList(of, doc, recordingRelations.get((Object)id), WorkIndexField.RECORDING_ID, WorkIndexField.RECORDING));
        }
        if (aliases.containsKey(id)) {
            work.setAliasList(AliasHelper.addAliasesToDocAndConstructAliasList(of, doc, aliases, id, WorkIndexField.ALIAS));
        }
        if (iswcs.containsKey(id)) {
            IswcList iswcList = of.createIswcList();
            for (String iswcCode : iswcs.get(id)) {
                doc.addField((IndexField)WorkIndexField.ISWC, iswcCode);
                iswcList.getIswc().add(iswcCode);
            }
            work.setIswcList(iswcList);
        } else {
            doc.addFieldOrNoValue(WorkIndexField.ISWC, null);
        }
        if (tags.containsKey(id)) {
            work.setTagList(TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, id, WorkIndexField.TAG));
        }
        String store = MMDSerializer.serialize(work);
        doc.addField((IndexField)WorkIndexField.WORK_STORE, store);
        return doc.getLuceneDocument();
    }
}

