/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.DiscList;
import org.musicbrainz.mmd2.Format;
import org.musicbrainz.mmd2.Label;
import org.musicbrainz.mmd2.LabelInfo;
import org.musicbrainz.mmd2.LabelInfoList;
import org.musicbrainz.mmd2.Medium;
import org.musicbrainz.mmd2.MediumList;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.PrimaryType;
import org.musicbrainz.mmd2.Release;
import org.musicbrainz.mmd2.ReleaseEvent;
import org.musicbrainz.mmd2.ReleaseEventList;
import org.musicbrainz.mmd2.ReleaseGroup;
import org.musicbrainz.mmd2.SecondaryType;
import org.musicbrainz.mmd2.SecondaryTypeList;
import org.musicbrainz.mmd2.Status;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.mmd2.TextRepresentation;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.ArtistCreditHelper;
import org.musicbrainz.search.helper.ArtistCreditWrapper;
import org.musicbrainz.search.helper.ReleaseEventHelper;
import org.musicbrainz.search.helper.ReleaseGroupHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.ReleaseEventComparator;
import org.musicbrainz.search.index.ReleaseIndexField;
import org.musicbrainz.search.index.ReleaseQuality;
import org.musicbrainz.search.index.Utils;

public class ReleaseIndex
extends DatabaseIndex {
    public static final String BARCODE_NONE = "none";
    private StopWatch labelClock = new StopWatch();
    private StopWatch mediumClock = new StopWatch();
    private StopWatch puidClock = new StopWatch();
    private StopWatch artistClock = new StopWatch();
    private StopWatch releaseClock = new StopWatch();
    private StopWatch buildClock = new StopWatch();
    private StopWatch storeClock = new StopWatch();
    public static final String INDEX_NAME = "release";

    public ReleaseIndex(Connection dbConnection) {
        super(dbConnection);
        this.labelClock.start();
        this.mediumClock.start();
        this.puidClock.start();
        this.artistClock.start();
        this.releaseClock.start();
        this.buildClock.start();
        this.storeClock.start();
        this.labelClock.suspend();
        this.mediumClock.suspend();
        this.puidClock.suspend();
        this.artistClock.suspend();
        this.releaseClock.suspend();
        this.buildClock.suspend();
        this.storeClock.suspend();
    }

    public ReleaseIndex() {
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(ReleaseIndexField.class);
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public IndexField getIdentifierField() {
        return ReleaseIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM release");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM release WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("LABELINFOS", "SELECT rl.release as releaseId, l.gid as labelId, l.name as labelName, catalog_number  FROM release_label rl   LEFT JOIN label l ON rl.label=l.id  WHERE rl.release BETWEEN ? AND ? ORDER BY catalog_number, labelName");
        this.addPreparedStatement("MEDIUMS", "SELECT m.release as releaseId, mf.name as format, m.track_count as numTracksOnMedium, count(mc.id) as discidsOnMedium  FROM medium m   LEFT JOIN medium_format mf ON m.format=mf.id   LEFT JOIN medium_cdtoc mc ON mc.medium=m.id  WHERE m.release BETWEEN ? AND ?  GROUP BY m.release, m.position, m.id, mf.name, m.track_count ORDER BY m.release, m.position, m.id ");
        this.addPreparedStatement("ARTISTCREDITS", "SELECT r.id as releaseId,   a.artist_credit,   a.pos,   a.joinphrase,   a.artistId,    a.comment,   a.artistName,   a.artistCreditName,   a.artistSortName  FROM release AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit  WHERE r.id BETWEEN ? AND ?   ORDER BY r.id, a.pos");
        this.addPreparedStatement("ARTISTCREDITALIASES", "SELECT r.id as releaseId, a.artist_credit,  a.pos,  aa.name, aa.sort_name, aa.primary_for_locale, aa.locale, aa.begin_date_year, aa.begin_date_month, aa.begin_date_day, aa.end_date_year, aa.end_date_month, aa.end_date_day, att.name as type FROM release AS r   INNER JOIN tmp_artistcredit a ON r.artist_credit=a.artist_credit   INNER JOIN artist_alias aa ON a.id=aa.artist  LEFT  JOIN artist_alias_type att on (aa.type=att.id) WHERE r.id BETWEEN ? AND ?   AND a.artistId!='89ad4ac3-39f7-470e-963a-56509c546377' AND a.artistId!='125ec42a-7229-4250-afc5-e057484327fe' ORDER BY r.id, a.pos, aa.name");
        this.addPreparedStatement("SECONDARYTYPES", "SELECT rg.name as type, r.id as rid FROM tmp_release r  INNER JOIN release_group_secondary_type_join  rgj  ON r.rg_id=rgj.release_group  INNER JOIN release_group_secondary_type rg   ON rgj.secondary_type = rg.id  WHERE r.id BETWEEN ? AND ?");
        this.addPreparedStatement("RELEASES", " SELECT id, gid, name,   barcode,   type, rg_gid, amazon_asin,   language, language_2t, script, status, comment, quality, packaging  FROM tmp_release rl  WHERE id BETWEEN ? AND ? ");
        this.addPreparedStatement("RELEASE_EVENTS", " SELECT release, country,    date_year, date_month, date_day, name, gid FROM tmp_release_event r1  WHERE release BETWEEN ? AND ? ");
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("release_tag", INDEX_NAME));
    }

    @Override
    public void destroy() throws SQLException {
        try {
            super.destroy();
            System.out.println(this.getName() + ":Label Queries " + Utils.formatClock(this.labelClock));
            System.out.println(this.getName() + ":Mediums Queries " + Utils.formatClock(this.mediumClock));
            System.out.println(this.getName() + ":Artists Queries " + Utils.formatClock(this.artistClock));
            System.out.println(this.getName() + ":Puids Queries " + Utils.formatClock(this.puidClock));
            System.out.println(this.getName() + ":Releases Queries " + Utils.formatClock(this.releaseClock));
            System.out.println(this.getName() + ":Build Index " + Utils.formatClock(this.buildClock));
            System.out.println(this.getName() + ":Build Store " + Utils.formatClock(this.storeClock));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Map<Integer, List<String>> loadSecondaryTypes(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> secondaryTypes = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("SECONDARYTYPES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int releaseId = rs.getInt("rid");
            if (!secondaryTypes.containsKey(releaseId)) {
                list = new LinkedList();
                secondaryTypes.put(releaseId, list);
            } else {
                list = (List)secondaryTypes.get(releaseId);
            }
            list.add(rs.getString("type"));
        }
        rs.close();
        return secondaryTypes;
    }

    private Map<Integer, List<ReleaseEvent>> loadReleaseEvents(int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("RELEASE_EVENTS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, List<ReleaseEvent>> releaseEvents = ReleaseEventHelper.completeReleaseEventsFromDbResults(rs, INDEX_NAME);
        rs.close();
        return releaseEvents;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, List<ReleaseEvent>> releaseEvents = this.loadReleaseEvents(min, max);
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        this.labelClock.resume();
        HashMap<Integer, List<List<String>>> labelInfo = new HashMap<Integer, List<List<String>>>();
        PreparedStatement st = this.getPreparedStatement("LABELINFOS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List list;
            int releaseId = rs.getInt("releaseId");
            if (!labelInfo.containsKey(releaseId)) {
                list = new LinkedList();
                labelInfo.put(releaseId, list);
            } else {
                list = (List)labelInfo.get(releaseId);
            }
            ArrayList<String> entry = new ArrayList<String>(3);
            entry.add(rs.getString("labelId"));
            entry.add(rs.getString("labelName"));
            entry.add(rs.getString("catalog_number"));
            list.add(entry);
        }
        rs.close();
        this.labelClock.suspend();
        this.mediumClock.resume();
        HashMap<Integer, List<List<String>>> mediums = new HashMap<Integer, List<List<String>>>();
        st = this.getPreparedStatement("MEDIUMS");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            List list;
            int releaseId = rs.getInt("releaseId");
            if (!mediums.containsKey(releaseId)) {
                list = new LinkedList();
                mediums.put(releaseId, list);
            } else {
                list = (List)mediums.get(releaseId);
            }
            ArrayList<String> entry = new ArrayList<String>(3);
            entry.add(rs.getString("format"));
            entry.add(String.valueOf(rs.getInt("numTracksOnMedium")));
            entry.add(String.valueOf(rs.getInt("discIdsOnMedium")));
            list.add(entry);
        }
        rs.close();
        this.mediumClock.suspend();
        this.artistClock.resume();
        Map<Integer, ArtistCreditWrapper> artistCredits = this.updateArtistCreditWithAliases(this.loadArtistCredits(min, max), min, max);
        this.artistClock.suspend();
        Map<Integer, List<String>> secondaryTypes = this.loadSecondaryTypes(min, max);
        st = this.getPreparedStatement("RELEASES");
        st.setInt(1, min);
        st.setInt(2, max);
        this.releaseClock.resume();
        rs = st.executeQuery();
        this.releaseClock.suspend();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, secondaryTypes, tags, releaseEvents, labelInfo, mediums, artistCredits));
        }
        rs.close();
    }

    private Map<Integer, ArtistCreditWrapper> loadArtistCredits(int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("ARTISTCREDITS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, ArtistCreditWrapper> artistCredits = ArtistCreditHelper.completeArtistCreditFromDbResults(rs, "releaseId", "artist_Credit", "artistId", "artistName", "artistSortName", "comment", "joinphrase", "artistCreditName");
        rs.close();
        return artistCredits;
    }

    private Map<Integer, ArtistCreditWrapper> updateArtistCreditWithAliases(Map<Integer, ArtistCreditWrapper> artistCredits, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("ARTISTCREDITALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        return ArtistCreditHelper.updateArtistCreditWithAliases(artistCredits, "releaseId", rs);
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<String>> secondaryTypes, Map<Integer, List<Tag>> tags, Map<Integer, List<ReleaseEvent>> releaseEvents, Map<Integer, List<List<String>>> labelInfo, Map<Integer, List<List<String>>> mediums, Map<Integer, ArtistCreditWrapper> artistCredits) throws SQLException {
        String barcode;
        Object st;
        this.buildClock.resume();
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Release release = of.createRelease();
        int id = rs.getInt("id");
        doc.addField((IndexField)ReleaseIndexField.ID, id);
        doc.addField((IndexField)ReleaseIndexField.RELEASE_ID, rs.getString("gid"));
        release.setId(rs.getString("gid"));
        String name = rs.getString("name");
        doc.addField((IndexField)ReleaseIndexField.RELEASE, name);
        doc.addField((IndexField)ReleaseIndexField.RELEASE_ACCENT, name);
        release.setTitle(name);
        String primaryType = rs.getString("type");
        doc.addFieldOrUnknown(ReleaseIndexField.PRIMARY_TYPE, primaryType);
        ReleaseGroup rg = of.createReleaseGroup();
        release.setReleaseGroup(rg);
        if (!Strings.isNullOrEmpty(primaryType)) {
            PrimaryType pt = new PrimaryType();
            pt.setContent(primaryType);
            release.getReleaseGroup().setPrimaryType(pt);
        }
        if (secondaryTypes.containsKey(id)) {
            SecondaryTypeList stl = of.createSecondaryTypeList();
            for (String secondaryType : secondaryTypes.get(id)) {
                doc.addField((IndexField)ReleaseIndexField.SECONDARY_TYPE, secondaryType);
                st = new SecondaryType();
                ((SecondaryType)st).setContent(secondaryType);
                stl.getSecondaryType().add((SecondaryType)st);
            }
            release.getReleaseGroup().setSecondaryTypeList(stl);
        }
        String type = ReleaseGroupHelper.calculateOldTypeFromPrimaryType(primaryType, secondaryTypes.get(id));
        doc.addFieldOrUnknown(ReleaseIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            release.getReleaseGroup().setType(type);
        }
        String releaseGroupId = rs.getString("rg_gid");
        doc.addNonEmptyField(ReleaseIndexField.RELEASEGROUP_ID, releaseGroupId);
        release.getReleaseGroup().setId(releaseGroupId);
        String status = rs.getString("status");
        doc.addFieldOrUnknown(ReleaseIndexField.STATUS, status);
        if (!Strings.isNullOrEmpty(status)) {
            st = new Status();
            ((Status)st).setContent(status);
            release.setStatus((Status)st);
        }
        if ((barcode = rs.getString("barcode")) == null) {
            doc.addField((IndexField)ReleaseIndexField.BARCODE, "-");
        } else if (barcode.equals("")) {
            doc.addField((IndexField)ReleaseIndexField.BARCODE, BARCODE_NONE);
            release.setBarcode(barcode);
        } else {
            doc.addField((IndexField)ReleaseIndexField.BARCODE, barcode);
            release.setBarcode(barcode);
        }
        String asin = rs.getString("amazon_asin");
        doc.addFieldOrNoValue(ReleaseIndexField.AMAZON_ID, asin);
        if (!Strings.isNullOrEmpty(asin)) {
            release.setAsin(asin);
        }
        boolean isScriptOrLanguage = false;
        TextRepresentation tr = of.createTextRepresentation();
        String script = rs.getString("script");
        doc.addFieldOrUnknown(ReleaseIndexField.SCRIPT, script);
        if (!Strings.isNullOrEmpty(script)) {
            tr.setScript(script);
            isScriptOrLanguage = true;
        }
        String lang3 = rs.getString("language");
        String lang2 = rs.getString("language_2t");
        if (lang3 != null) {
            doc.addFieldOrUnknown(ReleaseIndexField.LANGUAGE, lang3);
            tr.setLanguage(lang3.toLowerCase(Locale.US));
            isScriptOrLanguage = true;
        } else if (lang2 != null) {
            doc.addFieldOrUnknown(ReleaseIndexField.LANGUAGE, lang2);
            tr.setLanguage(lang2.toLowerCase(Locale.US));
            isScriptOrLanguage = true;
        } else {
            doc.addFieldOrUnknown(ReleaseIndexField.LANGUAGE, null);
        }
        if (isScriptOrLanguage) {
            release.setTextRepresentation(tr);
        }
        String packaging = rs.getString("packaging");
        doc.addFieldOrUnknown(ReleaseIndexField.PACKAGING, packaging);
        if (!Strings.isNullOrEmpty(packaging)) {
            release.setPackaging(packaging);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(ReleaseIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            release.setDisambiguation(comment);
        }
        doc.addField((IndexField)ReleaseIndexField.QUALITY, ReleaseQuality.mapReleaseQuality(rs.getInt("quality")).toString());
        if (labelInfo.containsKey(id)) {
            LabelInfoList labelInfoList = of.createLabelInfoList();
            for (List<String> entry : labelInfo.get(id)) {
                LabelInfo li = of.createLabelInfo();
                Label label = of.createLabel();
                li.setLabel(label);
                labelInfoList.getLabelInfo().add(li);
                doc.addFieldOrNoValue(ReleaseIndexField.LABEL_ID, entry.get(0));
                if (entry.get(0) != null && !entry.get(0).isEmpty()) {
                    label.setId(entry.get(0));
                }
                doc.addFieldOrNoValue(ReleaseIndexField.LABEL, entry.get(1));
                if (entry.get(1) != null && !entry.get(1).isEmpty()) {
                    label.setName(entry.get(1));
                }
                doc.addFieldOrUnknown(ReleaseIndexField.CATALOG_NO, entry.get(2));
                if (entry.get(2) == null || entry.get(2).isEmpty()) continue;
                li.setCatalogNumber(entry.get(2));
            }
            release.setLabelInfoList(labelInfoList);
        } else {
            doc.addFieldOrNoValue(ReleaseIndexField.LABEL, null);
            doc.addFieldOrNoValue(ReleaseIndexField.CATALOG_NO, null);
        }
        int trackCount = 0;
        int discCount = 0;
        int mediumCount = 0;
        if (mediums.containsKey(id)) {
            MediumList mediumList = of.createMediumList();
            for (List<String> entry : mediums.get(id)) {
                Medium medium = of.createMedium();
                String mediumFormat = entry.get(0);
                doc.addFieldOrNoValue(ReleaseIndexField.FORMAT, mediumFormat);
                if (mediumFormat != null && !mediumFormat.isEmpty()) {
                    Format format = new Format();
                    format.setContent(mediumFormat);
                    medium.setFormat(format);
                }
                int numTracksOnMedium = Integer.parseInt(entry.get(1));
                doc.addNumericField((IndexField)ReleaseIndexField.NUM_TRACKS_MEDIUM, numTracksOnMedium);
                Medium.TrackList trackList = of.createMediumTrackList();
                trackList.setCount(BigInteger.valueOf(numTracksOnMedium));
                trackCount += numTracksOnMedium;
                medium.setTrackList(trackList);
                int numDiscsOnMedium = Integer.parseInt(entry.get(2));
                doc.addNumericField((IndexField)ReleaseIndexField.NUM_DISCIDS_MEDIUM, numDiscsOnMedium);
                discCount += numDiscsOnMedium;
                ++mediumCount;
                DiscList discList = of.createDiscList();
                discList.setCount(BigInteger.valueOf(numDiscsOnMedium));
                medium.setDiscList(discList);
                mediumList.getMedium().add(medium);
            }
            mediumList.setCount(BigInteger.valueOf(mediumList.getMedium().size()));
            release.setMediumList(mediumList);
            doc.addNumericField((IndexField)ReleaseIndexField.NUM_MEDIUMS, mediumCount);
            doc.addNumericField((IndexField)ReleaseIndexField.NUM_TRACKS, trackCount);
            mediumList.setTrackCount(BigInteger.valueOf(trackCount));
            doc.addNumericField((IndexField)ReleaseIndexField.NUM_DISCIDS, discCount);
        } else {
            doc.addNumericField((IndexField)ReleaseIndexField.NUM_MEDIUMS, 0);
        }
        ArtistCreditWrapper ac = artistCredits.get(id);
        if (ac != null) {
            ArtistCreditHelper.buildIndexFieldsOnlyFromArtistCredit(doc, ac.getArtistCredit(), ReleaseIndexField.ARTIST, ReleaseIndexField.ARTIST_NAMECREDIT, ReleaseIndexField.ARTIST_ID, ReleaseIndexField.ARTIST_NAME);
            release.setArtistCredit(ac.getArtistCredit());
        } else {
            System.out.println("\nNo artist credit found for release:" + rs.getString("gid"));
        }
        if (tags.containsKey(id)) {
            TagList tagList = of.createTagList();
            for (Tag nextTag : tags.get(id)) {
                Tag tag = of.createTag();
                doc.addField((IndexField)ReleaseIndexField.TAG, nextTag.getName());
                tag.setName(nextTag.getName());
                tag.setCount(new BigInteger(nextTag.getCount().toString()));
                tagList.getTag().add(tag);
            }
            release.setTagList(tagList);
        }
        if (releaseEvents.containsKey(id)) {
            ReleaseEventList rel = of.createReleaseEventList();
            for (ReleaseEvent releaseEvent : releaseEvents.get(id)) {
                if (releaseEvent.getArea() != null) {
                    String nextCountry = releaseEvent.getArea().getIso31661CodeList().getIso31661Code().get(0);
                    doc.addNonEmptyField(ReleaseIndexField.COUNTRY, nextCountry);
                }
                String nextDate = releaseEvent.getDate();
                doc.addNonEmptyField(ReleaseIndexField.DATE, nextDate);
                rel.getReleaseEvent().add(releaseEvent);
            }
            Collections.sort(rel.getReleaseEvent(), new ReleaseEventComparator());
            release.setReleaseEventList(rel);
            ReleaseEvent firstReleaseEvent = rel.getReleaseEvent().get(0);
            if (firstReleaseEvent.getArea() != null) {
                release.setCountry(firstReleaseEvent.getArea().getIso31661CodeList().getIso31661Code().get(0));
            }
            if (!Strings.isNullOrEmpty(firstReleaseEvent.getDate())) {
                release.setDate(firstReleaseEvent.getDate());
            }
        } else {
            doc.addFieldOrUnknown(ReleaseIndexField.COUNTRY, null);
            doc.addFieldOrUnknown(ReleaseIndexField.DATE, null);
        }
        this.buildClock.suspend();
        this.storeClock.resume();
        String store = MMDSerializer.serialize(release);
        doc.addField((IndexField)ReleaseIndexField.RELEASE_STORE, store);
        this.storeClock.suspend();
        return doc.getLuceneDocument();
    }
}

