/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.DismaxSearcher;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.ResultsWriter;
import org.musicbrainz.search.servlet.SearchServer;

public abstract class AbstractDismaxSearchServer
implements SearchServer {
    protected DismaxSearcher dismaxSearcher;
    protected AbstractSearchServer realSearchServer;

    protected AbstractDismaxSearchServer(AbstractSearchServer mainSearchServer) {
        this.realSearchServer = mainSearchServer;
        this.dismaxSearcher = this.initDismaxSearcher();
    }

    protected abstract DismaxSearcher initDismaxSearcher();

    protected Query parseQuery(String query) throws ParseException {
        return this.dismaxSearcher.parseQuery(query, this.realSearchServer.getAnalyzer());
    }

    public Results search(String userQuery, int offset, int limit) throws IOException, ParseException {
        Query query = this.parseQuery(userQuery);
        return this.realSearchServer.search(query, offset, limit);
    }

    public Results search(Query query, int offset, int limit) throws IOException, ParseException {
        throw new UnsupportedOperationException();
    }

    public String explain(String userQuery, int offset, int limit) throws IOException, ParseException {
        Query query = this.parseQuery(userQuery);
        return this.realSearchServer.explain(query, offset, limit);
    }

    public String explain(Query query, int offset, int limit) throws IOException, ParseException {
        return this.realSearchServer.explain(query, offset, limit);
    }

    public SearcherManager getSearcherManager() {
        return this.realSearchServer.getSearcherManager();
    }

    public Analyzer getAnalyzer() {
        return this.realSearchServer.getAnalyzer();
    }

    public String getCount() {
        return this.realSearchServer.getCount();
    }

    public ResultsWriter getWriter(String version) {
        return this.realSearchServer.getWriter(version);
    }

    public void close() throws IOException {
        this.realSearchServer.close();
    }

    public void reloadIndex() throws CorruptIndexException, IOException {
        this.realSearchServer.reloadIndex();
    }
}

