/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.musicbrainz.search.index.LabelIndexField;
import org.musicbrainz.search.servlet.mmd1.LabelType;

public class LabelQueryParser
extends MultiFieldQueryParser {
    public LabelQueryParser(String[] strings, Analyzer analyzer) {
        super(strings, analyzer);
    }

    protected Query newTermQuery(Term term) {
        if (term.field().equals(LabelIndexField.TYPE.getName())) {
            try {
                int typeId = Integer.parseInt(term.text());
                if (typeId >= LabelType.getMinSearchId() && typeId <= LabelType.getMaxSearchId()) {
                    TermQuery tq = new TermQuery(new Term(term.field(), LabelType.getBySearchId((int)typeId).getName()));
                    return tq;
                }
                return super.newTermQuery(term);
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        return super.newTermQuery(term);
    }
}

