/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Release;
import org.musicbrainz.mmd2.ReleaseList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.ReleaseIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class ReleaseWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        ReleaseList releaseList = of.createReleaseList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(releaseList.getRelease(), results);
        releaseList.setCount(BigInteger.valueOf(results.getTotalHits()));
        releaseList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setReleaseList(releaseList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Release release = (Release)MMDSerializer.unserialize((String)doc.get((IndexField)ReleaseIndexField.RELEASE_STORE), Release.class);
        release.setScore(String.valueOf(result.getNormalizedScore()));
        list.add(release);
    }
}

