/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.musicbrainz.search.servlet.DismaxAlias;
import org.musicbrainz.search.servlet.DismaxQueryParser;

public class DismaxSearcher {
    private DismaxAlias dismaxAlias;

    public DismaxSearcher(DismaxAlias dismaxAlias) {
        this.dismaxAlias = dismaxAlias;
    }

    public Query parseQuery(String query, Analyzer analyzer) throws ParseException {
        query = QueryParser.escape((String)query);
        DismaxQueryParser queryParser = this.getParser(analyzer);
        queryParser.addAlias(DismaxQueryParser.IMPOSSIBLE_FIELD_NAME, this.dismaxAlias);
        Query q = queryParser.parse(query);
        return q;
    }

    protected DismaxQueryParser getParser(Analyzer analyzer) {
        return new DismaxQueryParser(analyzer);
    }
}

