/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.model.validator.CustomValidatorDefinition;
import org.apache.camel.model.validator.EndpointValidatorDefinition;
import org.apache.camel.model.validator.PredicateValidatorDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.validator.CustomValidatorReifier;
import org.apache.camel.reifier.validator.EndpointValidatorReifier;
import org.apache.camel.reifier.validator.PredicateValidatorReifier;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.spi.Validator;

public abstract class ValidatorReifier<T>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<CamelContext, ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>>> VALIDATORS = new HashMap(0);
    protected final T definition;

    public ValidatorReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<CamelContext, ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>> creator) {
        if (VALIDATORS.isEmpty()) {
            ReifierStrategy.addReifierClearer(ValidatorReifier::clearReifiers);
        }
        VALIDATORS.put(processorClass, creator);
    }

    public static ValidatorReifier<? extends ValidatorDefinition> reifier(CamelContext camelContext, ValidatorDefinition definition) {
        BiFunction<CamelContext, ValidatorDefinition, ValidatorReifier<? extends ValidatorDefinition>> reifier;
        ValidatorReifier<ValidatorDefinition> answer = null;
        if (!VALIDATORS.isEmpty() && (reifier = VALIDATORS.get(definition.getClass())) != null) {
            answer = reifier.apply(camelContext, definition);
        }
        if (answer == null) {
            answer = ValidatorReifier.coreReifier(camelContext, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + String.valueOf(definition));
        }
        return answer;
    }

    private static ValidatorReifier<? extends ValidatorDefinition> coreReifier(CamelContext camelContext, ValidatorDefinition definition) {
        if (definition instanceof CustomValidatorDefinition) {
            return new CustomValidatorReifier(camelContext, definition);
        }
        if (definition instanceof EndpointValidatorDefinition) {
            return new EndpointValidatorReifier(camelContext, definition);
        }
        if (definition instanceof PredicateValidatorDefinition) {
            return new PredicateValidatorReifier(camelContext, definition);
        }
        return null;
    }

    public static void clearReifiers() {
        VALIDATORS.clear();
    }

    public Validator createValidator() {
        return this.doCreateValidator();
    }

    protected abstract Validator doCreateValidator();
}

