/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jws.HandlerChain;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.catalog.impl.OASISCatalogManager;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.ResolvedHandlersDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionJava;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.ServiceRuntimeDescription;
import org.apache.axis2.jaxws.description.builder.AddressingAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MTOMAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.PortComposite;
import org.apache.axis2.jaxws.description.builder.RespectBindingAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.description.impl.DescriptionFactoryImpl;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointDescriptionImpl;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.axis2.jaxws.util.WeakKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.Catalog;

public class ServiceDescriptionImpl
implements ServiceDescription,
ServiceDescriptionWSDL,
ServiceDescriptionJava {
    private ClientConfigurationFactory clientConfigFactory;
    private ConfigurationContext configContext;
    private int useCount = 0;
    private String wsdlURL;
    private QName serviceQName;
    private WSDLWrapper wsdlWrapper;
    private WSDLWrapper generatedWsdlWrapper;
    private HandlerChain handlerChainAnnotation;
    private HandlerChainsType handlerChainsType;
    private Map<QName, EndpointDescription> definedEndpointDescriptions = new HashMap<QName, EndpointDescription>();
    private Map<WeakKey, Map<QName, EndpointDescriptionImpl>> dynamicEndpointDescriptions = new HashMap<WeakKey, Map<QName, EndpointDescriptionImpl>>();
    private ReferenceQueue dynamicPortRefQueue = new ReferenceQueue();
    private SoftReference<Map<PortInfo, ResolvedHandlersDescription>> resolvedHandlersDescription = new SoftReference(new ConcurrentHashMap());
    private static final Log log = LogFactory.getLog(ServiceDescriptionImpl.class);
    private HashMap<String, DescriptionBuilderComposite> dbcMap = null;
    private DescriptionBuilderComposite composite = null;
    private boolean isServerSide = false;
    private JAXWSCatalogManager catalogManager = null;
    Map<String, ServiceRuntimeDescription> runtimeDescMap = new ConcurrentHashMap<String, ServiceRuntimeDescription>();
    private static final String JAXWS_DYNAMIC_ENDPOINTS = "jaxws.dynamic.endpoints";

    ServiceDescriptionImpl(URL wsdlURL, QName serviceQName, Class serviceClass) {
        this(wsdlURL, serviceQName, serviceClass, null, null);
    }

    ServiceDescriptionImpl(URL wsdlURL, QName serviceQName, Class serviceClass, DescriptionBuilderComposite sparseComposite, Object sparseCompositeKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServiceDescriptionImpl(URL,QName,Class,DescriptionBuilderComposite,Object)");
            log.debug((Object)"entry");
            log.debug((Object)("  wsdlURL = " + wsdlURL));
            log.debug((Object)("  serviceQName = " + serviceQName));
            log.debug((Object)("  serviceClass = " + serviceClass));
            log.debug((Object)("  sparseComposite = " + DescriptionUtils.dumpString(sparseComposite)));
        }
        if (sparseComposite != null) {
            this.catalogManager = sparseComposite.getCatalogManager();
        }
        if (this.catalogManager == null) {
            this.catalogManager = new OASISCatalogManager();
        }
        if (serviceQName == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr0"));
        }
        if (serviceClass == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr1", "null"));
        }
        if (!Service.class.isAssignableFrom(serviceClass)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr1", serviceClass.getName()));
        }
        this.composite = new DescriptionBuilderComposite();
        this.composite.setIsServiceProvider(false);
        this.composite.setCorrespondingClass(serviceClass);
        this.composite.setClassLoader(ServiceDescriptionImpl.getClassLoader(serviceClass));
        this.composite.setSparseComposite(sparseCompositeKey, sparseComposite);
        URL sparseCompositeWsdlURL = this.getSparseCompositeWsdlURL(sparseComposite);
        if (sparseCompositeWsdlURL != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wsdl location overriden by sparse composite; overriden value: " + this.wsdlURL));
            }
            this.wsdlURL = sparseCompositeWsdlURL.toString();
        } else {
            String string = this.wsdlURL = wsdlURL == null ? null : this.getWSDLURL(wsdlURL.toString()).toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wsdl Location value used: " + this.wsdlURL));
        }
        this.serviceQName = serviceQName;
        this.setupWsdlDefinition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("exit " + this.toString()));
        }
    }

    URL getSparseCompositeWsdlURL(DescriptionBuilderComposite sparseComposite) {
        WebServiceClientAnnot wsc;
        URL url = null;
        if (sparseComposite != null && (wsc = sparseComposite.getWebServiceClientAnnot()) != null && wsc.wsdlLocation() != null) {
            String wsdlLocation = wsc.wsdlLocation();
            URL wsdlUrl = this.getWSDLURL(wsdlLocation);
            if (wsdlUrl == null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr4", wsdlLocation));
            }
            url = wsdlUrl;
        }
        return url;
    }

    private static URL createWsdlURL(String wsdlLocation) {
        URL theUrl;
        block2: {
            theUrl = null;
            try {
                theUrl = new URL(wsdlLocation);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Unable to obtain URL for WSDL file: " + wsdlLocation + " by using File reference"));
            }
        }
        return theUrl;
    }

    ServiceDescriptionImpl(HashMap<String, DescriptionBuilderComposite> dbcMap, DescriptionBuilderComposite composite) {
        this(dbcMap, composite, null);
    }

    ServiceDescriptionImpl(HashMap<String, DescriptionBuilderComposite> dbcMap, DescriptionBuilderComposite composite, ConfigurationContext configContext) {
        this(dbcMap, composite, configContext, null);
    }

    ServiceDescriptionImpl(HashMap<String, DescriptionBuilderComposite> dbcMap, DescriptionBuilderComposite composite, ConfigurationContext configContext, QName serviceQName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServiceDescriptionImpl(HashMap<String,DescriptionBuilderComposite>,ConfigurationContext)");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"entry");
            log.debug((Object)("  composite = " + DescriptionUtils.dumpString(composite)));
            log.debug((Object)("  configContext = " + configContext));
            log.debug((Object)("  serviceQName = " + serviceQName));
        }
        this.composite = composite;
        this.configContext = configContext;
        String serviceImplName = this.composite.getClassName();
        this.dbcMap = dbcMap;
        this.isServerSide = true;
        this.serviceQName = serviceQName;
        this.catalogManager = this.composite.getCatalogManager();
        if (this.catalogManager == null) {
            this.catalogManager = this.createCatalogManager(composite.getClassLoader());
        }
        List<PortComposite> portComposites = null;
        portComposites = this.serviceQName != null ? composite.getPortComposites(this.serviceQName) : composite.getPortComposites();
        this.setupWsdlDefinition();
        this.validateDBCLIntegrity();
        if (portComposites != null && !portComposites.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing EndpointDescription instance from PortComposites for implementation class: " + composite.getClassName()));
            }
            int i = 0;
            for (PortComposite portComposite : portComposites) {
                Map<String, Object> props = this.getAllProps(portComposite, dbcMap);
                EndpointDescriptionImpl endpointDescription = new EndpointDescriptionImpl(this, serviceImplName, props, i);
                this.addEndpointDescription(endpointDescription);
                ++i;
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No PortComposites found for implementation class: " + composite.getClassName()));
            }
            Map<String, Object> props = this.getAllProps(composite, dbcMap);
            EndpointDescriptionImpl endpointDescription = new EndpointDescriptionImpl(this, serviceImplName, props, null);
            this.addEndpointDescription(endpointDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exit " + this.toString()));
        }
    }

    EndpointDescription updateEndpointDescription(Class sei, QName portQName, DescriptionFactory.UpdateType updateType, DescriptionBuilderComposite composite, Object serviceDelegateKey, String bindingId, String endpointAddress) {
        QName preferredPortQN;
        EndpointDescriptionImpl endpointDescription = this.getEndpointDescriptionImpl(portQName);
        boolean isPortDeclared = this.isPortDeclared(portQName);
        if (endpointDescription == null && serviceDelegateKey != null) {
            endpointDescription = this.getDynamicEndpointDescriptionImpl(portQName, serviceDelegateKey);
        }
        if (DescriptionUtils.isEmpty(portQName) && !DescriptionUtils.isEmpty(preferredPortQN = this.getPreferredPort(serviceDelegateKey))) {
            portQName = preferredPortQN;
        }
        switch (updateType) {
            case ADD_PORT: {
                if (composite != null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr5", portQName.toString()));
                }
                if (DescriptionUtils.isEmpty(portQName)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr2"));
                }
                if (this.getWSDLWrapper() != null && isPortDeclared) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortDup", portQName.toString()));
                }
                if (endpointDescription != null) break;
                if (serviceDelegateKey == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescriptionImplAddPortErr"));
                }
                endpointDescription = this.getDynamicEndpointDescriptionImpl(sei, portQName, bindingId, endpointAddress);
                this.addDynamicEndpointDescriptionImpl(endpointDescription, serviceDelegateKey);
                break;
            }
            case GET_PORT: {
                if (endpointDescription == null && portQName == null && sei != null) {
                    endpointDescription = this.getEndpointDescriptionImpl(sei);
                }
                if (!isPortDeclared || endpointDescription != null && endpointDescription.isDynamicPort()) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("updateEPDescrErr1", portQName != null ? portQName.toString() : "not specified"));
                }
                if (sei == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("updateEPDescrErr2", portQName != null ? portQName.toString() : "not specified"));
                }
                if (endpointDescription == null) {
                    endpointDescription = new EndpointDescriptionImpl(sei, portQName, this, composite, serviceDelegateKey);
                    this.addEndpointDescription(endpointDescription);
                    this.resetServiceRuntimeDescription();
                    break;
                }
                if (this.getEndpointSEI(portQName) == null && !endpointDescription.isDynamicPort()) {
                    endpointDescription.updateWithSEI(sei, composite, serviceDelegateKey);
                    break;
                }
                if (this.getEndpointSEI(portQName) != sei) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("updateEPDescrErr3", portQName.toString(), sei.getName(), this.getEndpointSEI(portQName).getName()));
                }
                endpointDescription.getDescriptionBuilderComposite().setSparseComposite(serviceDelegateKey, composite);
                break;
            }
            case CREATE_DISPATCH: {
                if (composite != null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr6"));
                }
                if (DescriptionUtils.isEmpty(portQName)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail0"));
                }
                if (endpointDescription != null) break;
                if (sei != null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail3", portQName.toString()));
                }
                if (this.getWSDLWrapper() != null && isPortDeclared) {
                    endpointDescription = new EndpointDescriptionImpl(sei, portQName, this);
                    this.addEndpointDescription(endpointDescription);
                    break;
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail1", portQName.toString()));
            }
        }
        return endpointDescription;
    }

    private EndpointDescriptionImpl getDynamicEndpointDescriptionImpl(Class sei, QName portQName, String bindingId, String endpointAddress) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calling createEndpointDescriptionImpl : (" + portQName + "," + bindingId + "," + endpointAddress + ")"));
        }
        EndpointDescriptionImpl endpointDescription = null;
        SharedDynamicEndpointEntry sharedDynamicEndpointEntry = null;
        boolean areDynamicPortsShared = this.isShareDynamicPortsAcrossServicesEnabled();
        if (areDynamicPortsShared) {
            sharedDynamicEndpointEntry = this.findSharedDynamicEndpoint(portQName, bindingId, endpointAddress);
            endpointDescription = sharedDynamicEndpointEntry.endpointDescription;
        }
        boolean endpointCreated = false;
        if (endpointDescription == null) {
            endpointDescription = new EndpointDescriptionImpl(sei, portQName, true, this);
            endpointCreated = true;
        }
        if (areDynamicPortsShared && endpointCreated) {
            sharedDynamicEndpointEntry.endpointDescription = endpointDescription;
            this.cacheSharedDynamicPointEndpoint(sharedDynamicEndpointEntry);
        }
        return endpointDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheSharedDynamicPointEndpoint(SharedDynamicEndpointEntry sharedDynamicEndpointEntry) {
        HashMap cachedDescriptions = sharedDynamicEndpointEntry.cachedDescriptions;
        String key = sharedDynamicEndpointEntry.key;
        EndpointDescriptionImpl endpointDescription = sharedDynamicEndpointEntry.endpointDescription;
        HashMap hashMap = cachedDescriptions;
        synchronized (hashMap) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling cachedDescriptions.put : (" + key.toString() + ") : size - " + cachedDescriptions.size()));
            }
            cachedDescriptions.put(key.toString(), new WeakReference<EndpointDescriptionImpl>(endpointDescription));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedDynamicEndpointEntry findSharedDynamicEndpoint(QName portQName, String bindingId, String endpointAddress) {
        Parameter parameter;
        HashMap cachedDescriptions;
        SharedDynamicEndpointEntry returnDynamicEntry = new SharedDynamicEndpointEntry();
        EndpointDescriptionImpl sharedDynamicEndpoint = null;
        AxisConfiguration configuration = this.configContext.getAxisConfiguration();
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking for jaxws.dynamic.endpoints in AxisConfiguration : " + configuration));
        }
        if ((cachedDescriptions = (HashMap)((parameter = configuration.getParameter(JAXWS_DYNAMIC_ENDPOINTS)) == null ? null : parameter.getValue())) == null) {
            cachedDescriptions = new HashMap();
            try {
                configuration.addParameter(JAXWS_DYNAMIC_ENDPOINTS, cachedDescriptions);
            }
            catch (AxisFault axisFault) {
                throw new RuntimeException(axisFault);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added new instance of cachedDescriptions : " + cachedDescriptions));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("found old jaxws.dynamic.endpoints cache in AxisConfiguration (" + cachedDescriptions + ") with size : (" + cachedDescriptions.size() + ")"));
        }
        StringBuffer key = new StringBuffer();
        key.append(portQName == null ? "NULL" : portQName.toString());
        key.append(':');
        key.append(bindingId == null ? "NULL" : bindingId);
        key.append(':');
        key.append(endpointAddress == null ? "NULL" : endpointAddress);
        HashMap hashMap = cachedDescriptions;
        synchronized (hashMap) {
            WeakReference ref = (WeakReference)cachedDescriptions.get(key.toString());
            if (ref != null) {
                sharedDynamicEndpoint = (EndpointDescriptionImpl)ref.get();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found old entry for endpointDescription in jaxws.dynamic.endpoints cache : (" + cachedDescriptions.size() + ")"));
                }
            }
        }
        returnDynamicEntry.cachedDescriptions = cachedDescriptions;
        returnDynamicEntry.key = key.toString();
        returnDynamicEntry.endpointDescription = sharedDynamicEndpoint;
        return returnDynamicEntry;
    }

    private boolean isShareDynamicPortsAcrossServicesEnabled() {
        boolean resolutionEnabled = false;
        String flagValue = null;
        AxisConfiguration axisConfig = this.getAxisConfigContext().getAxisConfiguration();
        Parameter parameter = axisConfig.getParameter("jaxws.share.dynamic.ports.enable");
        if (parameter != null) {
            flagValue = (String)parameter.getValue();
        }
        if (flagValue != null) {
            if ("false".equalsIgnoreCase(flagValue)) {
                resolutionEnabled = false;
            } else if ("true".equalsIgnoreCase(flagValue)) {
                resolutionEnabled = true;
            }
        }
        return resolutionEnabled;
    }

    private Map<String, Object> getAllProps(DescriptionBuilderComposite dbc, Map<String, DescriptionBuilderComposite> dbcMap) {
        DescriptionBuilderComposite seiDBC;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (dbc.getProperties() != null && !dbc.getProperties().isEmpty()) {
            props.putAll(dbc.getProperties());
        }
        if (dbcMap != null && dbc.getWebServiceAnnot() != null && !DescriptionUtils.isEmpty(dbc.getWebServiceAnnot().endpointInterface()) && (seiDBC = dbcMap.get(dbc.getWebServiceAnnot().endpointInterface())) != null && seiDBC.getProperties() != null && !seiDBC.getProperties().isEmpty()) {
            props.putAll(seiDBC.getProperties());
        }
        return props;
    }

    private Class getEndpointSEI(QName portQName) {
        EndpointInterfaceDescription endpointInterfaceDesc;
        Class endpointSEI = null;
        EndpointDescription endpointDesc = this.getEndpointDescription(portQName);
        if (endpointDesc != null && (endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription()) != null) {
            endpointSEI = endpointInterfaceDesc.getSEIClass();
        }
        return endpointSEI;
    }

    private boolean isPortDeclared(QName portQName) {
        Definition wsdlDefn;
        javax.wsdl.Service wsdlService;
        Port wsdlPort;
        boolean portIsDeclared = false;
        portIsDeclared = !DescriptionUtils.isEmpty(portQName) ? (this.getWSDLWrapper() != null ? (wsdlPort = (wsdlService = (wsdlDefn = this.getWSDLWrapper().getDefinition()).getService(this.serviceQName)).getPort(portQName.getLocalPart())) != null : true) : true;
        return portIsDeclared;
    }

    @Override
    public EndpointDescription[] getEndpointDescriptions() {
        return this.definedEndpointDescriptions.values().toArray(new EndpointDescriptionImpl[0]);
    }

    public Collection<EndpointDescriptionImpl> getDynamicEndpointDescriptions_AsCollection(Object serviceDelegateKey) {
        Collection<EndpointDescriptionImpl> dynamicEndpoints = null;
        if (serviceDelegateKey != null && this.dynamicEndpointDescriptions.get(WeakKey.comparisonKey(serviceDelegateKey)) != null) {
            dynamicEndpoints = this.dynamicEndpointDescriptions.get(WeakKey.comparisonKey(serviceDelegateKey)).values();
        }
        return dynamicEndpoints;
    }

    @Override
    public Collection<EndpointDescription> getEndpointDescriptions_AsCollection() {
        return this.definedEndpointDescriptions.values();
    }

    @Override
    public EndpointDescription getEndpointDescription(QName portQName) {
        return this.getEndpointDescription(portQName, null);
    }

    @Override
    public EndpointDescription getEndpointDescription(QName portQName, Object serviceDelegateKey) {
        EndpointDescription returnDesc = null;
        if (!DescriptionUtils.isEmpty(portQName) && (returnDesc = this.definedEndpointDescriptions.get(portQName)) == null && serviceDelegateKey != null) {
            returnDesc = this.getDynamicEndpointDescriptionImpl(portQName, serviceDelegateKey);
        }
        return returnDesc;
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(QName portQName) {
        return (EndpointDescriptionImpl)this.getEndpointDescription(portQName, null);
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(QName portQName, Object serviceDelegateKey) {
        return (EndpointDescriptionImpl)this.getEndpointDescription(portQName);
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(Class seiClass) {
        for (EndpointDescription endpointDescription : this.definedEndpointDescriptions.values()) {
            Class endpointSEIClass;
            EndpointInterfaceDescription endpointInterfaceDesc = endpointDescription.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc == null || (endpointSEIClass = endpointInterfaceDesc.getSEIClass()) == null || !endpointSEIClass.equals(seiClass)) continue;
            return (EndpointDescriptionImpl)endpointDescription;
        }
        return null;
    }

    public DescriptionBuilderComposite getDescriptionBuilderComposite() {
        return this.getDescriptionBuilderComposite(null, null);
    }

    public DescriptionBuilderComposite getDescriptionBuilderComposite(QName serviceQName, Integer portCompositeIndex) {
        DescriptionBuilderComposite dbc = null;
        if (serviceQName != null && this.composite.getServiceQNames() != null && !this.composite.getServiceQNames().isEmpty() && portCompositeIndex != null) {
            List<PortComposite> pcList = this.composite.getPortComposites(serviceQName);
            dbc = pcList != null ? (DescriptionBuilderComposite)pcList.get(portCompositeIndex) : this.composite;
        } else if (portCompositeIndex == null || this.composite.getPortComposites() == null || portCompositeIndex < 0 || portCompositeIndex >= this.composite.getPortComposites().size()) {
            dbc = this.composite;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning PortComposite at index: " + portCompositeIndex + " from ServiceDescriptionImpl: " + this.hashCode()));
            }
            dbc = this.composite.getPortComposites().get(portCompositeIndex);
        }
        return dbc;
    }

    @Override
    public EndpointDescription[] getEndpointDescription(Class seiClass) {
        EndpointDescription[] returnEndpointDesc = null;
        ArrayList<EndpointDescriptionImpl> matchingEndpoints = new ArrayList<EndpointDescriptionImpl>();
        for (EndpointDescription endpointDescription : this.definedEndpointDescriptions.values()) {
            Class endpointSEIClass;
            EndpointInterfaceDescription endpointInterfaceDesc = endpointDescription.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc == null || (endpointSEIClass = endpointInterfaceDesc.getSEIClass()) == null || !endpointSEIClass.equals(seiClass)) continue;
            matchingEndpoints.add((EndpointDescriptionImpl)endpointDescription);
        }
        if (matchingEndpoints.size() > 0) {
            returnEndpointDesc = matchingEndpoints.toArray(new EndpointDescriptionImpl[0]);
        }
        return returnEndpointDesc;
    }

    private void addEndpointDescription(EndpointDescriptionImpl endpoint) {
        this.definedEndpointDescriptions.put(endpoint.getPortQName(), endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupWsdlDefinition() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"setupWsdlDefinition()");
        }
        if (this.composite.isServiceProvider()) {
            if (this.serviceQName != null && this.composite.getWsdlDefinition(this.serviceQName) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Found WSDL definition by service QName");
                }
                Definition def = this.composite.getWsdlDefinition(this.serviceQName);
                URL url = this.composite.getWsdlURL(this.serviceQName);
                this.wsdlURL = url != null ? url.toString() : null;
                try {
                    if (log.isDebugEnabled()) {
                        if (this.configContext != null) {
                            log.debug((Object)"new WSDL4JWrapper-ConfigContext not null1");
                        } else {
                            log.debug((Object)"new WSDL4JWrapper-ConfigContext null1");
                        }
                    }
                    this.wsdlWrapper = new WSDL4JWrapper(url, def, this.configContext, this.catalogManager);
                    return;
                }
                catch (WSDLException e) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
                }
            } else if (this.composite.getWebServiceAnnot() != null && DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().endpointInterface()) || this.composite.getWebServiceProviderAnnot() != null) {
                if (this.composite.getWsdlDefinition() != null) {
                    URL url = this.composite.getWsdlURL();
                    this.wsdlURL = url == null ? null : url.toString();
                    try {
                        if (log.isDebugEnabled()) {
                            if (this.configContext != null) {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext not null1");
                            } else {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext null1");
                            }
                        }
                        this.wsdlWrapper = new WSDL4JWrapper(url, this.composite.getWsdlDefinition(), this.configContext, this.catalogManager);
                        return;
                    }
                    catch (WSDLException e) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
                    }
                } else {
                    String wsdlLocation = null;
                    String string = wsdlLocation = this.composite.getWebServiceAnnot() != null ? this.composite.getWebServiceAnnot().wsdlLocation() : this.composite.getWebServiceProviderAnnot().wsdlLocation();
                    if (wsdlLocation == null || "".equals(wsdlLocation)) return;
                    this.setWSDLDefinitionOnDBC(wsdlLocation);
                }
                return;
            } else {
                if (this.composite.getWebServiceAnnot() == null) return;
                DescriptionBuilderComposite seic = this.getDBCMap().get(this.composite.getWebServiceAnnot().endpointInterface());
                try {
                    if (seic == null && log.isDebugEnabled()) {
                        log.debug((Object)("The SEI class " + this.composite.getWebServiceAnnot().endpointInterface() + " was not found."));
                    }
                    if (seic != null && seic.getWsdlDefinition() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl definition from the SEI composite.");
                        }
                        URL url = seic.getWsdlURL();
                        this.wsdlURL = url.toString();
                        if (log.isDebugEnabled()) {
                            if (this.configContext != null) {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext not null2");
                            } else {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext null2");
                            }
                        }
                        this.wsdlWrapper = new WSDL4JWrapper(seic.getWsdlURL(), seic.getWsdlDefinition(), this.configContext, this.catalogManager);
                        return;
                    }
                    if (this.composite.getWsdlDefinition() != null) {
                        URL url;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl definition from the impl class composite.");
                        }
                        if (log.isDebugEnabled()) {
                            if (this.configContext != null) {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext not null3");
                            } else {
                                log.debug((Object)"new WSDL4JWrapper-ConfigContext null3");
                            }
                        }
                        this.wsdlURL = (url = this.composite.getWsdlURL()) == null ? null : url.toString();
                        this.wsdlWrapper = new WSDL4JWrapper(this.composite.getWsdlURL(), this.composite.getWsdlDefinition(), this.configContext, this.catalogManager);
                        return;
                    }
                    String wsdlLocation = null;
                    if (seic != null && seic.getWebServiceAnnot() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl location from the SEI composite.");
                        }
                        wsdlLocation = seic.getWebServiceAnnot().wsdlLocation();
                    }
                    if (wsdlLocation == null || "".equals(wsdlLocation)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Get the wsdl location from the impl class composite.");
                        }
                        wsdlLocation = this.composite.getWebServiceAnnot().wsdlLocation();
                    }
                    if (wsdlLocation == null || "".equals(wsdlLocation)) return;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("wsdl location =" + wsdlLocation));
                    }
                    this.wsdlURL = wsdlLocation;
                    this.setWSDLDefinitionOnDBC(wsdlLocation);
                    return;
                }
                catch (WSDLException e) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
                }
            }
        }
        if (this.wsdlURL == null) return;
        try {
            if (log.isDebugEnabled()) {
                if (this.configContext != null) {
                    log.debug((Object)"new WSDL4JWrapper-ConfigContext not null4");
                } else {
                    log.debug((Object)"new WSDL4JWrapper-ConfigContext null4");
                }
            }
            this.wsdlWrapper = new WSDL4JWrapper(new URL(this.wsdlURL), this.configContext, this.catalogManager);
            return;
        }
        catch (FileNotFoundException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlNotFoundErr", e.getMessage()), e);
        }
        catch (UnknownHostException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("unknownHost", e.getMessage()), e);
        }
        catch (ConnectException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("connectionRefused", e.getMessage()), e);
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("urlStream", e.getMessage()), e);
        }
        catch (WSDLException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
        }
    }

    private void setWSDLDefinitionOnDBC(String wsdlLocation) {
        block8: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to load WSDL file from location specified in annotation: " + wsdlLocation));
            }
            if (this.composite.getClassLoader() == null && log.isDebugEnabled()) {
                log.debug((Object)("A classloader could not be found for class: " + this.composite.getClassName() + ". The WSDL file: " + wsdlLocation + " will not be processed, and the ServiceDescription will be built from annotations"));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read WSDL: " + wsdlLocation + " for web service endpoint: " + this.composite.getClassName()));
                }
                if (log.isDebugEnabled()) {
                    if (this.configContext != null) {
                        log.debug((Object)"new WSDL4JWrapper-ConfigContext not null5");
                    } else {
                        log.debug((Object)"new WSDL4JWrapper-ConfigContext null5");
                    }
                }
                URL url = this.getWSDLURL(wsdlLocation);
                ConfigurationContext cc = this.composite.getConfigurationContext();
                this.wsdlWrapper = cc != null ? new WSDL4JWrapper(url, cc, this.catalogManager) : new WSDL4JWrapper(url, this.catalogManager, true, 2);
                this.composite.setWsdlDefinition(this.wsdlWrapper.getDefinition());
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("The WSDL file: " + wsdlLocation + " for class: " + this.composite.getClassName() + "could not be processed. The ServiceDescription will be built from annotations"));
            }
        }
    }

    private URL getWSDLURL(String wsdlLocation) {
        ClassLoader classLoader;
        wsdlLocation = this.resolveWSDLLocationByCatalog(wsdlLocation);
        ClassLoader loader = this.composite.getClassLoader();
        URL url = null;
        if (loader != null) {
            url = this.getResource(wsdlLocation, loader);
        }
        if (url == null && (classLoader = ServiceDescriptionImpl.getContextClassLoader(null)) != loader) {
            url = this.getResource(wsdlLocation, classLoader);
        }
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL for wsdl file: " + wsdlLocation + " could not be determined by classloader... looking for file reference"));
            }
            url = ServiceDescriptionImpl.createWsdlURL(wsdlLocation);
        }
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL for wsdl file: " + wsdlLocation + " could not be found as local file reference... prepending file: protocol"));
            }
            if (wsdlLocation.indexOf("/") == 0) {
                wsdlLocation = wsdlLocation.substring(1, wsdlLocation.length());
            }
            url = ServiceDescriptionImpl.createWsdlURL("file:/" + wsdlLocation);
        }
        if (url == null && log.isDebugEnabled()) {
            log.debug((Object)("Unable to obtain URL for WSDL file: " + wsdlLocation + " by using prepended file: protocol"));
        }
        return url;
    }

    private URL getResource(final String wsdlLocation, final ClassLoader loader) {
        return (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return loader.getResource(wsdlLocation);
            }
        });
    }

    @Override
    public WSDLWrapper getWSDLWrapper() {
        return this.wsdlWrapper;
    }

    @Override
    public String getWSDLLocation() {
        return this.wsdlURL;
    }

    @Override
    public WSDLWrapper getGeneratedWsdlWrapper() {
        return this.generatedWsdlWrapper;
    }

    void setAxisConfigContext(ConfigurationContext config) {
        this.configContext = config;
    }

    @Override
    public ConfigurationContext getAxisConfigContext() {
        if (this.configContext == null) {
            this.configContext = this.getClientConfigurationFactory().getClientConfigurationContext();
        }
        return this.configContext;
    }

    ClientConfigurationFactory getClientConfigurationFactory() {
        if (this.clientConfigFactory == null) {
            this.clientConfigFactory = DescriptionFactory.createClientConfigurationFactory();
        }
        return this.clientConfigFactory;
    }

    @Override
    public ServiceClient getServiceClient(QName portQName, Object serviceDelegateKey) {
        ServiceClient returnServiceClient = null;
        if (!DescriptionUtils.isEmpty(portQName)) {
            EndpointDescription endpointDesc = this.getEndpointDescription(portQName, serviceDelegateKey);
            if (endpointDesc != null) {
                returnServiceClient = endpointDesc.getServiceClient();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find portQName: " + portQName + " under ServiceDescription: " + this.toString()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("PortQName agrument is invalid; it can not be null or an empty string: " + portQName));
        }
        return returnServiceClient;
    }

    @Override
    public QName getServiceQName() {
        return this.serviceQName;
    }

    void setServiceQName(QName theName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set serviceQName to " + this.serviceQName));
        }
        this.serviceQName = theName;
    }

    @Override
    public JAXWSCatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    @Override
    public boolean isMTOMEnabled(Object key) {
        return this.getDescriptionBuilderComposite().isMTOMEnabled(key);
    }

    @Override
    public boolean isMTOMEnabled(Object key, Class seiClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("isMTOMEnabled, key= " + key + ", seiClass= " + seiClass));
        }
        boolean mtomEnabled = false;
        boolean checkOldEnablementMethod = true;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(key, seiClass);
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof MTOMAnnot)) continue;
                MTOMAnnot mtomAnnot = (MTOMAnnot)((Object)checkAnnotation);
                mtomEnabled = mtomAnnot.enabled();
                checkOldEnablementMethod = false;
            }
        }
        if (checkOldEnablementMethod) {
            Map seiToMTOM;
            DescriptionBuilderComposite sparseComposite = this.getDescriptionBuilderComposite().getSparseComposite(key);
            mtomEnabled = sparseComposite != null && seiClass != null ? ((seiToMTOM = (Map)sparseComposite.getProperties().get("org.apache.axis2.jaxws.description.builder.SEI_MTOM_ENABLEMENT_MAP")) != null && seiToMTOM.get(seiClass.getName()) != null ? ((Boolean)seiToMTOM.get(seiClass.getName())).booleanValue() : this.isMTOMEnabled(key)) : this.isMTOMEnabled(key);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isMTOMEnabled, key= " + key + ", seiClass= " + seiClass + ", isMTOMEnabled= " + mtomEnabled));
        }
        return mtomEnabled;
    }

    @Override
    public Map<String, Object> getBindingProperties(Object serviceDelegateKey, String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBindingProperties, serviceDelegateKey= " + serviceDelegateKey + ", key= " + key));
        }
        Map bindingProps = null;
        DescriptionBuilderComposite sparseComposite = this.getDescriptionBuilderComposite().getSparseComposite(serviceDelegateKey);
        if (sparseComposite != null) {
            Map allBindingProps = (Map)sparseComposite.getProperties().get("org.apache.axis2.jaxws.description.builder.BINDING_PROPS_MAP");
            Map map = bindingProps = allBindingProps != null ? (Map)allBindingProps.get(key) : null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBindingProperties, serviceDelegateKey= " + serviceDelegateKey + ", key= " + key + ", propsSize= " + (bindingProps != null ? bindingProps.size() : 0)));
        }
        return bindingProps;
    }

    @Override
    public QName getPreferredPort(Object key) {
        return this.getDescriptionBuilderComposite().getPreferredPort(key);
    }

    @Override
    public boolean isServerSide() {
        return this.isServerSide;
    }

    public HashMap<String, DescriptionBuilderComposite> getDBCMap() {
        return this.dbcMap;
    }

    void setGeneratedWsdlWrapper(WSDL4JWrapper wrapper) {
        this.generatedWsdlWrapper = wrapper;
    }

    void setWsdlWrapper(WSDL4JWrapper wrapper) {
        this.wsdlWrapper = wrapper;
    }

    private void validateDBCLIntegrity() {
        try {
            this.validateIntegrity();
        }
        catch (Exception ex) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("dbclIntegrityErr", ex.toString(), DescriptionUtils.dumpString(this.composite)), ex);
        }
    }

    void validateIntegrity() {
        Iterator<String> iter = this.composite.getInterfacesList().iterator();
        boolean providerInterfaceValid = false;
        while (iter.hasNext()) {
            String interfaceString = iter.next();
            if (!interfaceString.equals("javax.xml.ws.Provider<javax.xml.transform.Source>") && !interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>") && !interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>") && !interfaceString.equals("javax.xml.ws.Provider<java.lang.String>") && !interfaceString.equals("javax.xml.ws.Provider<org.apache.axiom.om.OMElement>")) continue;
            providerInterfaceValid = true;
            if (this.composite.getWebServiceProviderAnnot() != null) continue;
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr1", this.composite.getClassName()));
        }
        if (this.composite.getWebServiceAnnot() != null && this.composite.getWebServiceProviderAnnot() != null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr2", this.composite.getClassName()));
        }
        if (this.composite.getWebServiceProviderAnnot() != null) {
            if (!providerInterfaceValid) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr3", this.composite.getClassName()));
            }
            if (!this.validateDefaultConstructor()) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr4", this.composite.getClassName()));
            }
            if (!this.validateInvokeMethod()) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr5", this.composite.getClassName()));
            }
            this.validateProviderInterfaces();
        } else if (this.composite.getWebServiceAnnot() != null) {
            if (this.composite.getServiceModeAnnot() != null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr6", this.composite.getClassName()));
            }
            if (!this.composite.isInterface()) {
                if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().wsdlLocation()) && this.composite.getWsdlDefinition(this.getServiceQName()) == null && this.composite.getWsdlDefinition() == null && this.composite.getWsdlURL() == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr7", this.composite.getClassName(), this.composite.getWebServiceAnnot().wsdlLocation()));
                }
                if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().endpointInterface())) {
                    DescriptionBuilderComposite seic = this.dbcMap.get(this.composite.getWebServiceAnnot().endpointInterface());
                    if (seic == null) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr8", this.composite.getClassName(), this.composite.getWebServiceAnnot().endpointInterface()));
                    }
                    if (this.composite.getSoapBindingAnnot() != null || this.composite.getWebFaultAnnot() != null || this.composite.getWebServiceClientAnnot() != null) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr9", this.composite.getClassName()));
                    }
                    if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().name())) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr10", this.composite.getClassName(), this.composite.getWebServiceAnnot().name()));
                    }
                    this.validateSEI(seic);
                    this.validateImplementation(seic);
                    if (this.webMethodAnnotationsExist()) {
                        throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr11", this.composite.getClassName()));
                    }
                } else {
                    this.checkImplicitSEIAgainstWSDL();
                }
            } else {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr12", this.composite.getClassName()));
            }
            if (this.composite.getSoapBindingAnnot() != null && this.composite.getSoapBindingAnnot().use() == SOAPBinding.Use.ENCODED) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateIntegrityErr13", this.composite.getClassName()));
            }
            this.checkMethodsAgainstWSDL();
        }
    }

    private boolean validateInvokeMethod() {
        boolean validInvokeMethod = false;
        List<MethodDescriptionComposite> invokeMethodList = this.composite.getMethodDescriptionComposite("invoke");
        if (invokeMethodList != null && !invokeMethodList.isEmpty()) {
            validInvokeMethod = true;
        }
        return validInvokeMethod;
    }

    private void validateProviderInterfaces() {
        if (this.composite.getServiceModeAnnot() == null || this.composite.getServiceModeAnnot().value() == Service.Mode.PAYLOAD) {
            for (String interfaceString : this.composite.getInterfacesList()) {
                if (!interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>") && !interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>")) continue;
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validatePIsErr1", this.composite.getClassName()));
            }
        } else {
            String bindingType = null;
            if (this.composite.getBindingTypeAnnot() != null) {
                bindingType = this.composite.getBindingTypeAnnot().value();
            }
            for (String interfaceString : this.composite.getInterfacesList()) {
                if (interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>")) {
                    if (DescriptionUtils.isEmpty(bindingType) || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || bindingType.equals("http://www.w3.org/2010/soapjms/") || bindingType.equals("http://www.w3.org/2010/soapjms/?mtom=true") || bindingType.equals("http://www.w3.org/2010/soapjms/") || bindingType.equals("http://www.w3.org/2010/soapjms/?mtom=true") || bindingType.equals("SOAP_HTTP_BINDING")) continue;
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validatePIsErr2", this.composite.getClassName()));
                }
                if (!interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>") || !DescriptionUtils.isEmpty(bindingType) && bindingType.equals("http://www.w3.org/2004/08/wsdl/http")) continue;
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validatePIsErr3", this.composite.getClassName()));
            }
        }
    }

    private boolean validateDefaultConstructor() {
        boolean validDefaultCtor = false;
        List<MethodDescriptionComposite> constructorList = this.composite.getMethodDescriptionComposite("<init>");
        if (constructorList != null && !constructorList.isEmpty()) {
            for (MethodDescriptionComposite checkCtor : constructorList) {
                List<ParameterDescriptionComposite> paramList = checkCtor.getParameterDescriptionCompositeList();
                if (paramList != null && !paramList.isEmpty()) continue;
                validDefaultCtor = true;
                break;
            }
        }
        return validDefaultCtor;
    }

    private void validateImplementation(DescriptionBuilderComposite seic) {
        List<MethodDescriptionComposite> implMethods = this.composite.getMethodDescriptionsList();
        this.addSuperClassMethods(implMethods, this.composite);
        List<MethodDescriptionComposite> seiMethods = seic.getMethodDescriptionsList();
        this.addSuperClassMethods(seiMethods, seic);
        for (MethodDescriptionComposite seiMDC : seiMethods) {
            Iterator<MethodDescriptionComposite> implMDCIterator = implMethods.iterator();
            boolean methodImplFound = false;
            while (implMDCIterator.hasNext()) {
                MethodDescriptionComposite implMDC = implMDCIterator.next();
                if (!seiMDC.getMethodName().equals(implMDC.getMethodName())) continue;
                try {
                    this.validateMethodParameters(seiMDC, implMDC, seic.getClassName());
                    methodImplFound = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!methodImplFound) continue;
                this.validateMethodExceptions(seiMDC, implMDC, seic.getClassName());
                this.validateMethodReturnValue(seiMDC, implMDC, seic.getClassName());
                break;
            }
            if (methodImplFound) continue;
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateImplErr", this.composite.getClassName(), seiMDC.getMethodName(), seic.getClassName()));
        }
    }

    private void validateMethodParameters(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        List<ParameterDescriptionComposite> seiPDCList = seiMDC.getParameterDescriptionCompositeList();
        List<ParameterDescriptionComposite> implPDCList = implMDC.getParameterDescriptionCompositeList();
        if (seiPDCList != null && !seiPDCList.isEmpty() || implPDCList != null && !implPDCList.isEmpty()) {
            if ((seiPDCList == null || seiPDCList.isEmpty()) && implPDCList != null && !implPDCList.isEmpty()) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodParamErr1", implPDCList.toString(), this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
            if (seiPDCList != null && !seiPDCList.isEmpty() && (implPDCList == null || implPDCList.isEmpty())) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodParamErr2", seiPDCList.toString(), this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
            if (seiPDCList.size() != implPDCList.size()) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodParamErr3", new Integer(seiPDCList.size()).toString(), new Integer(implPDCList.size()).toString(), this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
            boolean parametersMatch = true;
            String failingMessage = null;
            for (int paramNumber = 0; paramNumber < seiPDCList.size(); ++paramNumber) {
                String implParamType;
                String seiParamType = seiPDCList.get(paramNumber).getParameterType();
                if (seiParamType.equals(implParamType = implPDCList.get(paramNumber).getParameterType())) continue;
                parametersMatch = false;
                String[] inserts = new String[]{String.valueOf(paramNumber), seiParamType, implParamType, this.composite.getClassName(), seiMDC.getMethodName(), className};
                failingMessage = Messages.getMessage("serviceDescriptionImplValidationErr", inserts);
                break;
            }
            if (!parametersMatch) {
                throw ExceptionFactory.makeWebServiceException(failingMessage);
            }
        }
    }

    private void validateMethodReturnValue(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        String seiReturnValue = seiMDC.getReturnType();
        String implReturnValue = implMDC.getReturnType();
        if (seiReturnValue != null || implReturnValue != null) {
            if (seiReturnValue == null && implReturnValue != null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodRVErr1", implReturnValue, this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
            if (seiReturnValue != null && implReturnValue == null) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodRVErr2", seiReturnValue, this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
            if (!seiReturnValue.equals(implReturnValue)) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodRVErr3", seiReturnValue, implReturnValue, this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
        }
    }

    private void validateMethodExceptions(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        String[] seiExceptions = seiMDC.getExceptions();
        String[] implExceptions = implMDC.getExceptions();
        if (seiExceptions == null) {
            if (implExceptions == null) {
                return;
            }
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodExceptionErr1", this.composite.getClassName(), seiMDC.getMethodName(), className));
        }
        if (implExceptions == null) {
            return;
        }
        if (seiExceptions.length < implExceptions.length) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodExceptionErr2", new Integer(implExceptions.length).toString(), new Integer(seiExceptions.length).toString(), this.composite.getClassName(), seiMDC.getMethodName(), className));
        }
        if (implExceptions.length > 0) {
            for (String implException : implExceptions) {
                boolean foundIt = false;
                if (seiExceptions.length > 0) {
                    for (String seiException : seiExceptions) {
                        if (!seiException.equals(implException)) continue;
                        foundIt = true;
                        break;
                    }
                }
                if (foundIt) continue;
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateMethodExceptionErr3", implException, this.composite.getClassName(), seiMDC.getMethodName(), className));
            }
        }
    }

    private void addSuperClassMethods(List<MethodDescriptionComposite> methodList, DescriptionBuilderComposite dbc) {
        DescriptionBuilderComposite superDBC = this.dbcMap.get(dbc.getSuperClassName());
        if (superDBC != null) {
            for (MethodDescriptionComposite mdc : superDBC.getMethodDescriptionsList()) {
                methodList.add(mdc);
            }
            this.addSuperClassMethods(methodList, superDBC);
        }
    }

    private void checkMethodsAgainstWSDL() {
        if (this.webMethodAnnotationsExist()) {
            if (DescriptionUtils.falseExclusionsExist(this.composite)) {
                this.verifyFalseExclusionsWithWSDL();
            } else {
                this.verifyPublicMethodsWithWSDL();
            }
        } else {
            this.verifyPublicMethodsWithWSDL();
        }
    }

    private void checkImplicitSEIAgainstWSDL() {
        if (this.webMethodAnnotationsExist()) {
            if (DescriptionUtils.falseExclusionsExist(this.composite)) {
                this.verifyFalseExclusionsWithWSDL();
            } else {
                this.verifyPublicMethodsWithWSDL();
            }
        } else {
            this.verifyPublicMethodsWithWSDL();
        }
    }

    private void checkSEIAgainstWSDL() {
    }

    private void validateSEI(DescriptionBuilderComposite seic) {
        if (seic.getWebServiceAnnot() == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateSEIErr1", this.composite.getClassName(), seic.getClassName()));
        }
        if (!seic.getWebServiceAnnot().endpointInterface().equals("")) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateSEIErr2", this.composite.getClassName(), seic.getClassName(), seic.getWebServiceAnnot().endpointInterface()));
        }
        if (seic.getSoapBindingAnnot() != null && seic.getSoapBindingAnnot().use() == SOAPBinding.Use.ENCODED) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("validateSEIErr3", seic.getClassName()));
        }
        this.checkSEIAgainstWSDL();
        this.validateMethods(seic.getMethodDescriptionsList());
    }

    private boolean webMethodAnnotationsExist() {
        MethodDescriptionComposite mdc2 = null;
        for (MethodDescriptionComposite mdc2 : this.composite.getMethodDescriptionsList()) {
            if (mdc2.getWebMethodAnnot() == null) continue;
            return true;
        }
        return false;
    }

    private void verifyFalseExclusionsWithWSDL() {
    }

    private void verifyPublicMethodsWithWSDL() {
    }

    private void validateMethods(List<MethodDescriptionComposite> mdcList) {
        if (mdcList != null && !mdcList.isEmpty()) {
            for (MethodDescriptionComposite mdc : mdcList) {
                String returnType = mdc.getReturnType();
                if (returnType != null && (returnType.equals("java.util.concurrent.Future") || returnType.equals("javax.xml.ws.Response"))) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serverSideAsync", mdc.getDeclaringClass(), mdc.getMethodName()));
                }
                if (mdc.getSoapBindingAnnot() == null) continue;
                if (mdc.getSoapBindingAnnot().use() == SOAPBinding.Use.ENCODED) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("soapBindingUseEncoded", mdc.getDeclaringClass(), mdc.getMethodName()));
                }
                if (mdc.getSoapBindingAnnot().style() != SOAPBinding.Style.RPC) continue;
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("soapBindingStyle", mdc.getDeclaringClass(), mdc.getMethodName()));
            }
        }
    }

    private void validateWSDLOperations() {
    }

    @Override
    public boolean isWSDLSpecified() {
        boolean wsdlSpecified = false;
        if (this.getWSDLWrapper() != null) {
            wsdlSpecified = this.getWSDLWrapper().getDefinition() != null;
        }
        return wsdlSpecified;
    }

    @Override
    public HandlerChainsType getHandlerChain() {
        return this.getHandlerChain(null);
    }

    @Override
    public HandlerChainsType getHandlerChain(Object sparseCompositeKey) {
        DescriptionBuilderComposite sparseComposite = null;
        if (sparseCompositeKey != null && (sparseComposite = this.composite.getSparseComposite(sparseCompositeKey)) != null && sparseComposite.getHandlerChainsType() != null) {
            return sparseComposite.getHandlerChainsType();
        }
        if (this.handlerChainsType == null) {
            this.getAnnoHandlerChainAnnotation(sparseCompositeKey);
            if (this.handlerChainAnnotation != null) {
                String handlerChainDeclaringClass;
                ClassLoader classLoader;
                String className;
                InputStream is;
                String handlerFileName = this.handlerChainAnnotation.file();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EndpointDescriptionImpl.getHandlerChain: fileName: " + handlerFileName + " className: " + this.composite.getClassName()));
                }
                if ((is = DescriptionUtils.openHandlerConfigStream(handlerFileName, className = this.composite.getClassName(), classLoader = this.composite.getClassLoader())) == null && sparseComposite != null && (handlerChainDeclaringClass = (String)sparseComposite.getProperties().get("HANDLER_CHAIN_DECLARING_CLASS")) != null) {
                    className = handlerChainDeclaringClass;
                    is = DescriptionUtils.openHandlerConfigStream(handlerFileName, className, classLoader);
                }
                if (is == null) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainNS", handlerFileName, className));
                }
                this.handlerChainsType = DescriptionUtils.loadHandlerChains(is, ServiceDescriptionImpl.getClassLoader(this.getClass()));
            }
        }
        return this.handlerChainsType;
    }

    public HandlerChain getAnnoHandlerChainAnnotation(Object sparseCompositeKey) {
        DescriptionBuilderComposite sparseComposite;
        Class serviceClass;
        if (this.handlerChainAnnotation == null && (serviceClass = this.composite.getCorrespondingClass()) != null) {
            this.handlerChainAnnotation = (HandlerChain)ServiceDescriptionImpl.getAnnotation(serviceClass, HandlerChain.class);
        }
        if (this.handlerChainAnnotation == null && sparseCompositeKey != null && (sparseComposite = this.composite.getSparseComposite(sparseCompositeKey)) != null && sparseComposite.getHandlerChainAnnot() != null) {
            this.handlerChainAnnotation = sparseComposite.getHandlerChainAnnot();
        }
        return this.handlerChainAnnotation;
    }

    @Override
    public Definition getWSDLDefinition() {
        Definition defn = null;
        if (this.getWSDLWrapper() != null) {
            defn = this.getWSDLWrapper().getDefinition();
        }
        return defn;
    }

    public Definition getWSDLGeneratedDefinition() {
        Definition defn = null;
        if (this.getGeneratedWsdlWrapper() != null) {
            defn = this.getGeneratedWsdlWrapper().getDefinition();
        }
        return defn;
    }

    @Override
    public javax.wsdl.Service getWSDLService() {
        javax.wsdl.Service returnWSDLService = null;
        Definition defn = this.getWSDLDefinition();
        if (defn != null) {
            returnWSDLService = defn.getService(this.getServiceQName());
        }
        return returnWSDLService;
    }

    @Override
    public Map getWSDLPorts() {
        javax.wsdl.Service wsdlService = this.getWSDLService();
        if (wsdlService != null) {
            return wsdlService.getPorts();
        }
        return null;
    }

    @Override
    public List<QName> getPorts(Object serviceDelegateKey) {
        Collection<EndpointDescriptionImpl> dynamicEndpointDescs;
        ArrayList<QName> portList = new ArrayList<QName>();
        Map wsdlPortsMap = this.getWSDLPorts();
        if (wsdlPortsMap != null) {
            Iterator wsdlPortsIterator = wsdlPortsMap.values().iterator();
            String serviceTNS = this.getServiceQName().getNamespaceURI();
            Port wsdlPort = null;
            while (wsdlPortsIterator.hasNext()) {
                wsdlPort = (Port)wsdlPortsIterator.next();
                String string = wsdlPort.getName();
                portList.add(new QName(serviceTNS, string));
            }
        }
        Collection<EndpointDescription> endpointDescs = this.getEndpointDescriptions_AsCollection();
        for (EndpointDescription endpointDesc : endpointDescs) {
            QName qName = endpointDesc.getPortQName();
            if (portList.contains(qName)) continue;
            portList.add(qName);
        }
        if (serviceDelegateKey != null && (dynamicEndpointDescs = this.getDynamicEndpointDescriptions_AsCollection(serviceDelegateKey)) != null) {
            for (EndpointDescription endpointDescription : dynamicEndpointDescs) {
                QName endpointPortQName = endpointDescription.getPortQName();
                if (portList.contains(endpointPortQName)) continue;
                portList.add(endpointPortQName);
            }
        }
        return portList;
    }

    @Override
    public List<Port> getWSDLPortsUsingPortType(QName portTypeQN) {
        Map wsdlPortMap;
        ArrayList<Port> portList = new ArrayList<Port>();
        if (!DescriptionUtils.isEmpty(portTypeQN) && (wsdlPortMap = this.getWSDLPorts()) != null && !wsdlPortMap.isEmpty()) {
            for (Object mapElement : wsdlPortMap.values()) {
                Port wsdlPort = (Port)mapElement;
                PortType wsdlPortType = wsdlPort.getBinding().getPortType();
                QName wsdlPortTypeQN = wsdlPortType.getQName();
                if (!portTypeQN.equals(wsdlPortTypeQN)) continue;
                portList.add(wsdlPort);
            }
        }
        return portList;
    }

    @Override
    public List<Port> getWSDLPortsUsingSOAPAddress(List<Port> wsdlPorts) {
        ArrayList<Port> portsUsingAddress = new ArrayList<Port>();
        if (wsdlPorts != null && !wsdlPorts.isEmpty()) {
            for (Port checkPort : wsdlPorts) {
                List extensibilityElementList = checkPort.getExtensibilityElements();
                for (Object checkElement : extensibilityElementList) {
                    if (!EndpointDescriptionImpl.isSOAPAddressElement((ExtensibilityElement)checkElement)) continue;
                    portsUsingAddress.add(checkPort);
                }
            }
        }
        return portsUsingAddress;
    }

    @Override
    public ServiceRuntimeDescription getServiceRuntimeDesc(String name) {
        return this.runtimeDescMap.get(name);
    }

    @Override
    public void setServiceRuntimeDesc(ServiceRuntimeDescription srd) {
        this.runtimeDescMap.put(srd.getKey(), srd);
    }

    private void resetServiceRuntimeDescription() {
        this.runtimeDescMap.clear();
    }

    protected String getServiceClassName() {
        return this.composite.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointDescriptionImpl getDynamicEndpointDescriptionImpl(QName portQName, Object key) {
        Map<QName, EndpointDescriptionImpl> innerMap = null;
        Map<WeakKey, Map<QName, EndpointDescriptionImpl>> map = this.dynamicEndpointDescriptions;
        synchronized (map) {
            innerMap = this.dynamicEndpointDescriptions.get(WeakKey.comparisonKey(key));
            if (innerMap != null) {
                return innerMap.get(portQName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDynamicEndpointDescriptionImpl(EndpointDescriptionImpl endpointDescriptionImpl, Object key) {
        Map<QName, EndpointDescriptionImpl> innerMap = null;
        Map<WeakKey, Map<QName, EndpointDescriptionImpl>> map = this.dynamicEndpointDescriptions;
        synchronized (map) {
            innerMap = this.dynamicEndpointDescriptions.get(WeakKey.comparisonKey(key));
            if (innerMap == null) {
                innerMap = new HashMap<QName, EndpointDescriptionImpl>();
                this.dynamicEndpointDescriptions.put(new WeakKey(key, this.dynamicPortRefQueue), innerMap);
            }
            innerMap.put(endpointDescriptionImpl.getPortQName(), endpointDescriptionImpl);
        }
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        boolean dumpWSDLContents = false;
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("ServiceQName: " + this.getServiceQName());
            string.append("\n");
            string.append("isWSDLSpecified: " + this.isWSDLSpecified());
            string.append("; ");
            string.append("WSDL Location: " + this.getWSDLLocation());
            string.append("\n");
            if (dumpWSDLContents) {
                string.append("WSDL Definition: " + this.getWSDLDefinition());
                string.append("\n");
                string.append("Generated WSDL Definition: " + this.getWSDLGeneratedDefinition());
            } else {
                string.append("WSDL Definition available: " + (this.getWSDLDefinition() != null));
                string.append("; ");
                string.append("Generated WSDL Definition available: " + (this.getWSDLGeneratedDefinition() != null));
            }
            string.append("\n");
            string.append("isServerSide: " + this.isServerSide);
            string.append("\n");
            string.append("handlerChainAnnotation: " + this.handlerChainAnnotation);
            string.append("\n");
            string.append("handlerChainsType: " + this.handlerChainsType);
            string.append("\n");
            List<QName> ports = this.getPorts(null);
            string.append("Number of defined ports: " + ports.size());
            string.append("\n");
            string.append("Port QNames: ");
            for (QName port : ports) {
                string.append(port + "; ");
            }
            string.append("start composite");
            try {
                string.append(DescriptionUtils.dumpString(this.composite));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            string.append("\n");
            string.append("end composite");
            string.append("\n");
            string.append("\n");
            Collection<EndpointDescription> endpointDescs = this.getEndpointDescriptions_AsCollection();
            if (endpointDescs == null) {
                string.append("EndpointDescription array is null");
            } else {
                string.append("Number of EndpointDescrptions: " + endpointDescs.size());
                string.append("\n");
                for (EndpointDescription endpointDesc : endpointDescs) {
                    string.append(endpointDesc.toString());
                    string.append("\n");
                }
            }
            string.append("RuntimeDescriptions:" + this.runtimeDescMap.size());
            string.append("\n");
            for (ServiceRuntimeDescription runtimeDesc : this.runtimeDescMap.values()) {
                string.append(runtimeDesc.toString());
                string.append("\n");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for ServiceDescription");
            return string.toString();
        }
        return string.toString();
    }

    private static Annotation getAnnotation(final Class cls, final Class annotation) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return cls.getAnnotation(annotation);
            }
        });
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return cls.getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    @Override
    public void setResolvedHandlersDescription(PortInfo portInfo, ResolvedHandlersDescription resolvedHandlersInfo) {
        Map<PortInfo, ResolvedHandlersDescription> cache = this.resolvedHandlersDescription.get();
        if (cache == null) {
            cache = new ConcurrentHashMap<PortInfo, ResolvedHandlersDescription>();
            this.resolvedHandlersDescription = new SoftReference<Map<PortInfo, ResolvedHandlersDescription>>(cache);
        }
        cache.put(portInfo, resolvedHandlersInfo);
    }

    @Override
    public ResolvedHandlersDescription getResolvedHandlersDescription(PortInfo portInfo) {
        Map<PortInfo, ResolvedHandlersDescription> cache = this.resolvedHandlersDescription.get();
        return cache == null ? null : cache.get(portInfo);
    }

    private String resolveWSDLLocationByCatalog(String wsdlLocation) {
        block6: {
            Catalog catalog;
            if (this.catalogManager != null && (catalog = this.catalogManager.getCatalog()) != null) {
                String resolvedLocation = null;
                try {
                    resolvedLocation = catalog.resolveSystem(wsdlLocation);
                    if (resolvedLocation == null) {
                        resolvedLocation = catalog.resolveURI(wsdlLocation);
                    }
                    if (resolvedLocation != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("XMLCatalog transformed original wsdl location \"" + wsdlLocation + "\" to \"" + resolvedLocation + "\""));
                        }
                        return resolvedLocation;
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("Catalog resolution attempt caused exception: " + e));
                }
            }
        }
        return wsdlLocation;
    }

    boolean isInUse() {
        return this.useCount > 0;
    }

    void registerUse() {
        ++this.useCount;
    }

    void deregisterUse() {
        if (this.useCount > 0) {
            --this.useCount;
        }
    }

    @Override
    public void releaseResources(Object delegate) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ServiceDescription release resources called with delegate " + delegate));
            }
            if (DescriptionFactoryImpl.removeFromCache(this)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceDesc not in use so it was removed from cache.  Releasing all resources for this ServiceDesc");
                }
                this.releaseAllResourcesForServiceDescription();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ServiceDesc still in use so not removed from cache.  Releasing resources for delegate");
                }
                this.releaseResourcesForDelegate(delegate);
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Release resorces in ServiceDesc caught throwable ", t);
            }
            throw ExceptionFactory.makeWebServiceException(t);
        }
    }

    private void releaseAllResourcesForServiceDescription() {
        Collection<EndpointDescription> definedEndpoints = this.definedEndpointDescriptions.values();
        if (definedEndpoints.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Releasing defined endpoints, size: " + definedEndpoints.size()));
            }
            for (EndpointDescription endpointDesc : definedEndpoints) {
                ((EndpointDescriptionImpl)endpointDesc).releaseResources(this.getAxisConfigContext());
            }
        }
        this.definedEndpointDescriptions.clear();
        Collection<Map<QName, EndpointDescriptionImpl>> dynamicEndpointsMap = this.dynamicEndpointDescriptions.values();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Releasing dynamic endpoints, size: " + dynamicEndpointsMap.size()));
        }
        for (Map<QName, EndpointDescriptionImpl> mapEntry : dynamicEndpointsMap) {
            Collection<EndpointDescriptionImpl> dynamicEndpoints = mapEntry.values();
            if (dynamicEndpoints == null || dynamicEndpoints.size() <= 0) continue;
            for (EndpointDescription endpointDescription : dynamicEndpoints) {
                this.releaseEndpoint(endpointDescription);
            }
        }
        this.dynamicEndpointDescriptions.clear();
    }

    private void releaseEndpoint(EndpointDescription endpointDesc) {
        ((EndpointDescriptionImpl)endpointDesc).releaseResources(this.getAxisConfigContext());
        this.removeFromDynamicEndpointCache(endpointDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResourcesForDelegate(Object delegate) {
        Map<WeakKey, Map<QName, EndpointDescriptionImpl>> map = this.dynamicEndpointDescriptions;
        synchronized (map) {
            Map<QName, EndpointDescriptionImpl> delegateEntry = this.dynamicEndpointDescriptions.remove(WeakKey.comparisonKey(delegate));
            if (delegateEntry != null && delegateEntry.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removed delegate from dynamic ports: " + delegate));
                }
                this.releaseUnreferencedDynamicPorts(delegateEntry);
            }
            Reference gcKey = null;
            while ((gcKey = this.dynamicPortRefQueue.poll()) != null) {
                Map<QName, EndpointDescriptionImpl> removeEntry;
                WeakKey removeKey = (WeakKey)gcKey;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing GC'd key from dynamic ports: " + removeKey));
                }
                if ((removeEntry = this.dynamicEndpointDescriptions.remove(removeKey)) == null || removeEntry.size() <= 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Releasing dynamic ports referenced by GC'd key : " + removeEntry));
                }
                this.releaseUnreferencedDynamicPorts(removeEntry);
            }
        }
    }

    private void releaseUnreferencedDynamicPorts(Map<QName, EndpointDescriptionImpl> delegateEntry) {
        Set<Map.Entry<QName, EndpointDescriptionImpl>> delegatePortEntries = delegateEntry.entrySet();
        for (Map.Entry<QName, EndpointDescriptionImpl> delegatePortEntry : delegatePortEntries) {
            boolean deletePort = true;
            Collection<Map<QName, EndpointDescriptionImpl>> activeDelegatePortEntries = this.dynamicEndpointDescriptions.values();
            Iterator<Map<QName, EndpointDescriptionImpl>> activeDelegatePortEntriesIterator = activeDelegatePortEntries.iterator();
            while (deletePort && activeDelegatePortEntriesIterator.hasNext()) {
                Map<QName, EndpointDescriptionImpl> activeDelegatePorts = activeDelegatePortEntriesIterator.next();
                Set<Map.Entry<QName, EndpointDescriptionImpl>> checkActivePorts = activeDelegatePorts.entrySet();
                Iterator<Map.Entry<QName, EndpointDescriptionImpl>> checkActivePortsIterator = checkActivePorts.iterator();
                while (deletePort && checkActivePortsIterator.hasNext()) {
                    Map.Entry<QName, EndpointDescriptionImpl> checkActivePort = checkActivePortsIterator.next();
                    if (!checkActivePort.getKey().equals(delegatePortEntry.getKey()) || !checkActivePort.getValue().equals(delegatePortEntry.getValue())) continue;
                    deletePort = false;
                }
            }
            if (!deletePort) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Releasing resources for dynamic port " + delegatePortEntry.getKey()));
            }
            this.releaseEndpoint(delegatePortEntry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDynamicEndpointCache(EndpointDescription endpointDesc) {
        AxisConfiguration configuration = this.configContext.getAxisConfiguration();
        Parameter parameter = configuration.getParameter(JAXWS_DYNAMIC_ENDPOINTS);
        HashMap cachedDescriptions = (HashMap)(parameter == null ? null : parameter.getValue());
        if (cachedDescriptions != null) {
            HashMap hashMap = cachedDescriptions;
            synchronized (hashMap) {
                Set cachedDescSet = cachedDescriptions.entrySet();
                Iterator cachedDescIterator = cachedDescSet.iterator();
                while (cachedDescIterator.hasNext()) {
                    EndpointDescriptionImpl checkDynamicEndpointDesc;
                    Map.Entry mapEntry = cachedDescIterator.next();
                    WeakReference weakRef = (WeakReference)mapEntry.getValue();
                    if (weakRef == null || endpointDesc != (checkDynamicEndpointDesc = (EndpointDescriptionImpl)weakRef.get())) continue;
                    cachedDescIterator.remove();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Removing endpoint desc from dynamic cache on configuration");
                }
            }
        }
    }

    private JAXWSCatalogManager createCatalogManager(ClassLoader cl) {
        OASISCatalogManager returnCatalogManager = null;
        try {
            URL catalogURL = cl.getResource("WEB-INF/jax-ws-catalog.xml");
            if (catalogURL == null) {
                catalogURL = cl.getResource("META-INF/jax-ws-catalog.xml");
                if (catalogURL != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found JAX-WS catalog in EJB file");
                    }
                    returnCatalogManager = new OASISCatalogManager(cl);
                    returnCatalogManager.getCatalog().parseCatalog(catalogURL);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Found JAX-WS catalog in WAR file");
                }
                returnCatalogManager = new OASISCatalogManager(cl);
                returnCatalogManager.getCatalog().parseCatalog(catalogURL);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ServiceDescriptionImpl caught exception from parseCatalog ", (Throwable)e);
            }
            returnCatalogManager = null;
        }
        return returnCatalogManager;
    }

    @Override
    public int getMTOMThreshold(Object serviceDelegate, Class seiClass) {
        int threshold = 0;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(serviceDelegate, seiClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feature list for delegate: " + serviceDelegate + ", and SEI: " + seiClass + ", is: " + seiFeatureList));
        }
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof MTOMAnnot)) continue;
                MTOMAnnot mtomAnnot = (MTOMAnnot)((Object)checkAnnotation);
                threshold = mtomAnnot.threshold();
            }
        }
        return threshold;
    }

    private List<Annotation> getSEIFeatureList(Object serviceDelegate, Class seiClass) {
        Map featureMap;
        List featureList = null;
        DescriptionBuilderComposite sparseComposite = this.getDescriptionBuilderComposite().getSparseComposite(serviceDelegate);
        if (sparseComposite != null && seiClass != null && (featureMap = (Map)sparseComposite.getProperties().get("org.apache.axis2.jaxws.description.builder.SEI_FEATURES_MAP")) != null) {
            featureList = (List)featureMap.get(seiClass.getName());
        }
        return featureList;
    }

    @Override
    public boolean isRespectBindingEnabled(Object serviceDelegateKey, Class seiClass) {
        boolean enabled = false;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(serviceDelegateKey, seiClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feature list for delegate: " + serviceDelegateKey + ", and SEI: " + seiClass + ", is: " + seiFeatureList));
        }
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof RespectBindingAnnot)) continue;
                RespectBindingAnnot respectBindingAnnot = (RespectBindingAnnot)((Object)checkAnnotation);
                enabled = respectBindingAnnot.enabled();
            }
        }
        return enabled;
    }

    @Override
    public boolean isAddressingConfigured(Object serviceDelegateKey, Class seiClass) {
        boolean configured = false;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(serviceDelegateKey, seiClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feature list for delegate: " + serviceDelegateKey + ", and SEI: " + seiClass + ", is: " + seiFeatureList));
        }
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof AddressingAnnot)) continue;
                AddressingAnnot addressingAnnot = (AddressingAnnot)((Object)checkAnnotation);
                configured = true;
            }
        }
        return configured;
    }

    @Override
    public boolean isAddressingEnabled(Object serviceDelegateKey, Class seiClass) {
        boolean enabled = false;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(serviceDelegateKey, seiClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feature list for delegate: " + serviceDelegateKey + ", and SEI: " + seiClass + ", is: " + seiFeatureList));
        }
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof AddressingAnnot)) continue;
                AddressingAnnot addressingAnnot = (AddressingAnnot)((Object)checkAnnotation);
                enabled = addressingAnnot.enabled();
            }
        }
        return enabled;
    }

    @Override
    public boolean isAddressingRequired(Object serviceDelegateKey, Class seiClass) {
        boolean enabled = false;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(serviceDelegateKey, seiClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feature list for delegate: " + serviceDelegateKey + ", and SEI: " + seiClass + ", is: " + seiFeatureList));
        }
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof AddressingAnnot)) continue;
                AddressingAnnot addressingAnnot = (AddressingAnnot)((Object)checkAnnotation);
                enabled = addressingAnnot.required();
            }
        }
        return enabled;
    }

    @Override
    public AddressingFeature.Responses getAddressingResponses(Object serviceDelegateKey, Class seiClass) {
        AddressingFeature.Responses responses = null;
        List<Annotation> seiFeatureList = this.getSEIFeatureList(serviceDelegateKey, seiClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feature list for delegate: " + serviceDelegateKey + ", and SEI: " + seiClass + ", is: " + seiFeatureList));
        }
        if (seiFeatureList != null) {
            for (int i = 0; i < seiFeatureList.size(); ++i) {
                Annotation checkAnnotation = seiFeatureList.get(i);
                if (!(checkAnnotation instanceof AddressingAnnot)) continue;
                AddressingAnnot addressingAnnot = (AddressingAnnot)((Object)checkAnnotation);
                responses = addressingAnnot.responses();
            }
        }
        return responses;
    }

    class SharedDynamicEndpointEntry {
        String key;
        EndpointDescriptionImpl endpointDescription;
        HashMap cachedDescriptions;

        SharedDynamicEndpointEntry() {
        }
    }
}

