/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ThreadFactory;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSThreadFactory
implements ThreadFactory {
    private static final Log log = LogFactory.getLog(JAXWSThreadFactory.class);
    private static int groupNumber = 0;
    private int threadNumber = 0;
    private ThreadGroup threadGroup = null;

    @Override
    public Thread newThread(final Runnable r) {
        if (this.threadGroup == null) {
            try {
                this.threadGroup = (ThreadGroup)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        return new ThreadGroup("JAX-WS Default Executor Group " + groupNumber++);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception thrown from AccessController: " + e));
                }
                throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
            }
        }
        ++this.threadNumber;
        Thread returnThread = null;
        try {
            returnThread = (Thread)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    Thread newThread = new Thread(JAXWSThreadFactory.this.threadGroup, r);
                    newThread.setDaemon(true);
                    return newThread;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return returnThread;
    }
}

