/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.InputStream;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.builder.MIMEAwareBuilder;
import org.apache.axis2.context.MessageContext;

public class MTOMBuilder
implements MIMEAwareBuilder {
    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        throw new AxisFault("A message with content type application/xop+xml can only appear in a MIME multipart message");
    }

    @Override
    public OMElement processMIMEMessage(Attachments attachments, String contentType, MessageContext messageContext) throws AxisFault {
        try {
            messageContext.setAttachmentMap(attachments);
            SOAPModelBuilder builder = OMXMLBuilderFactory.createSOAPModelBuilder((MultipartBody)attachments.getMultipartBody());
            messageContext.setProperty(Constants.BUILDER, builder);
            OMDocument document = builder.getDocument();
            String charsetEncoding = document.getCharsetEncoding();
            if (charsetEncoding == null) {
                charsetEncoding = "UTF-8";
            }
            messageContext.setProperty("CHARACTER_SET_ENCODING", charsetEncoding);
            SOAPEnvelope envelope = (SOAPEnvelope)document.getOMDocumentElement();
            messageContext.setDoingMTOM(true);
            return envelope;
        }
        catch (OMException e) {
            throw AxisFault.makeFault(e);
        }
    }
}

