/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream;

import java.util.HashSet;
import java.util.Set;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;

public final class NamespaceContextPreservationFilterHandler
extends XmlHandlerWrapper {
    private final CoreElement contextElement;
    private Set<String> prefixesAlreadyBound;
    private boolean done = false;

    public NamespaceContextPreservationFilterHandler(XmlHandler parent, CoreElement contextElement) {
        super(parent);
        this.contextElement = contextElement;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        super.startElement(namespaceURI, localName, prefix);
        if (!this.done) {
            this.prefixesAlreadyBound = new HashSet<String>();
        }
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        super.processNamespaceDeclaration(prefix, namespaceURI);
        if (!this.done) {
            this.prefixesAlreadyBound.add(prefix);
        }
    }

    @Override
    public void attributesCompleted() throws StreamException {
        if (!this.done) {
            try {
                CoreElement current = this.contextElement;
                while (true) {
                    for (CoreAttribute attr = current.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                        CoreNamespaceDeclaration decl;
                        String prefix;
                        if (!(attr instanceof CoreNamespaceDeclaration) || !this.prefixesAlreadyBound.add(prefix = (decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix())) continue;
                        super.processNamespaceDeclaration(prefix, decl.coreGetCharacterData().toString());
                    }
                    CoreParentNode parent = current.coreGetParent();
                    if (!(parent instanceof CoreElement)) break;
                    current = (CoreElement)parent;
                }
                this.prefixesAlreadyBound = null;
                this.done = true;
            }
            catch (CoreModelException ex) {
                throw new StreamException(ex);
            }
        }
        super.attributesCompleted();
    }
}

