/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class ClassLoaderUtil {
    private static Map<String, ClassLoader> classLoaders = new ConcurrentHashMap<String, ClassLoader>();

    public static void init(AxisConfiguration configuration) {
        classLoaders.put("system", configuration.getSystemClassLoader());
        classLoaders.put("axis2", ClassLoaderUtil.class.getClassLoader());
        Iterator iter = configuration.getServiceGroups();
        while (iter.hasNext()) {
            AxisServiceGroup group = (AxisServiceGroup)iter.next();
            ClassLoader serviceGroupClassLoader = group.getServiceGroupClassLoader();
            if (serviceGroupClassLoader == null) continue;
            classLoaders.put(ClassLoaderUtil.getServiceGroupMapKey(group), serviceGroupClassLoader);
        }
        for (Object obj : configuration.getModules().values()) {
            AxisModule module = (AxisModule)obj;
            ClassLoader moduleClassLoader = module.getModuleClassLoader();
            if (moduleClassLoader == null) continue;
            classLoaders.put(ClassLoaderUtil.getModuleMapKey(module), moduleClassLoader);
        }
    }

    public static void addServiceGroupClassLoader(AxisServiceGroup serviceGroup) {
        ClassLoader serviceGroupClassLoader = serviceGroup.getServiceGroupClassLoader();
        if (serviceGroupClassLoader != null) {
            classLoaders.put(ClassLoaderUtil.getServiceGroupMapKey(serviceGroup), serviceGroupClassLoader);
        }
    }

    public static void removeServiceGroupClassLoader(AxisServiceGroup serviceGroup) {
        classLoaders.remove(ClassLoaderUtil.getServiceGroupMapKey(serviceGroup));
    }

    private static String getServiceGroupMapKey(AxisServiceGroup serviceGroup) {
        return serviceGroup.getServiceGroupName() + "$#sg";
    }

    public static void addModuleClassLoader(AxisModule module) {
        ClassLoader moduleClassLoader = module.getModuleClassLoader();
        if (moduleClassLoader != null) {
            classLoaders.put(ClassLoaderUtil.getModuleMapKey(module), moduleClassLoader);
        }
    }

    public static void removeModuleClassLoader(AxisModule axisModule) {
        classLoaders.remove(ClassLoaderUtil.getModuleMapKey(axisModule));
    }

    private static String getModuleMapKey(AxisModule module) {
        return module.getName() + "-" + String.valueOf(module.getVersion()) + "$#mod";
    }

    public static ClassLoader[] getClassLoaders() {
        return classLoaders.values().toArray(new ClassLoader[classLoaders.size()]);
    }
}

