/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.BoundedIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BoundedIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c", "d", "e", "f", "g"};
    private List<E> testList;

    @Override
    public Iterator<E> makeEmptyIterator() {
        return new BoundedIterator(Collections.emptyList().iterator(), 0L, 10L);
    }

    @Override
    public Iterator<E> makeObject() {
        return new BoundedIterator(new ArrayList<E>(this.testList).iterator(), 1L, (long)(this.testList.size() - 1));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testList = Arrays.asList((Object[])this.testArray);
    }

    @Test
    public void testBounded() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 2L, 4L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testBounded$0((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    @Test
    public void testEmptyBounded() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 3L, 0L);
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testEmptyBounded$1((Iterator)iter));
    }

    @Test
    public void testMaxGreaterThanSize() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 1L, 10L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testMaxGreaterThanSize$2((Iterator)iter));
    }

    @Test
    public void testNegativeMax() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new BoundedIterator(this.testList.iterator(), 3L, -1L));
        Assertions.assertEquals((Object)"Max parameter must not be negative.", (Object)thrown.getMessage());
    }

    @Test
    public void testNegativeOffset() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new BoundedIterator(this.testList.iterator(), -1L, 4L));
        Assertions.assertEquals((Object)"Offset parameter must not be negative.", (Object)thrown.getMessage());
    }

    @Test
    public void testOffsetGreaterThanSize() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 10L, 4L);
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testOffsetGreaterThanSize$5((Iterator)iter));
    }

    @Test
    public void testRemoveCalledTwice() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        iter.remove();
        Assertions.assertThrows(IllegalStateException.class, () -> BoundedIteratorTest.lambda$testRemoveCalledTwice$6((Iterator)iter));
    }

    @Test
    public void testRemoveFirst() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        iter.remove();
        Assertions.assertFalse((boolean)testListCopy.contains("b"));
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testRemoveFirst$7((Iterator)iter));
    }

    @Test
    public void testRemoveLast() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        NoSuchElementException thrown = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testRemoveLast$8((Iterator)iter));
        Assertions.assertNull((Object)thrown.getMessage());
        iter.remove();
        Assertions.assertFalse((boolean)testListCopy.contains("f"));
        Assertions.assertFalse((boolean)iter.hasNext());
        NoSuchElementException thrown1 = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testRemoveLast$9((Iterator)iter));
        Assertions.assertNull((Object)thrown1.getMessage());
    }

    @Test
    public void testRemoveMiddle() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        iter.remove();
        Assertions.assertFalse((boolean)testListCopy.contains("d"));
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testRemoveMiddle$10((Iterator)iter));
    }

    @Test
    public void testRemoveUnsupported() {
        AbstractIteratorDecorator mockIterator = new AbstractIteratorDecorator<E>(this.testList.iterator()){

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        BoundedIterator iter = new BoundedIterator((Iterator)mockIterator, 1L, 5L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        UnsupportedOperationException thrown = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> BoundedIteratorTest.lambda$testRemoveUnsupported$11((Iterator)iter));
        Assertions.assertNull((Object)thrown.getMessage());
    }

    @Test
    public void testRemoveWithoutCallingNext() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> BoundedIteratorTest.lambda$testRemoveWithoutCallingNext$12((Iterator)iter));
        Assertions.assertEquals((Object)"remove() cannot be called before calling next()", (Object)thrown.getMessage());
    }

    @Test
    public void testSameAsDecorated() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 0L, (long)this.testList.size());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"a", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> BoundedIteratorTest.lambda$testSameAsDecorated$13((Iterator)iter));
    }

    private static /* synthetic */ void lambda$testSameAsDecorated$13(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveWithoutCallingNext$12(Iterator iter) throws Throwable {
        iter.remove();
    }

    private static /* synthetic */ void lambda$testRemoveUnsupported$11(Iterator iter) throws Throwable {
        iter.remove();
    }

    private static /* synthetic */ void lambda$testRemoveMiddle$10(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveLast$9(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveLast$8(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveFirst$7(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveCalledTwice$6(Iterator iter) throws Throwable {
        iter.remove();
    }

    private static /* synthetic */ void lambda$testOffsetGreaterThanSize$5(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testMaxGreaterThanSize$2(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testEmptyBounded$1(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testBounded$0(Iterator iter) throws Throwable {
        iter.next();
    }
}

