/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.Iterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NodeListIteratorTest
extends AbstractIteratorTest<Node> {
    private Node[] nodes;
    private boolean createIteratorWithStandardConstr = true;

    @Override
    public Iterator<Node> makeEmptyIterator() {
        NodeList emptyNodeList = new NodeList(){

            @Override
            public int getLength() {
                return 0;
            }

            @Override
            public Node item(int index) {
                throw new IndexOutOfBoundsException();
            }
        };
        if (this.createIteratorWithStandardConstr) {
            return new NodeListIterator(emptyNodeList);
        }
        Node parentNode = (Node)EasyMock.createMock(Node.class);
        EasyMock.expect((Object)parentNode.getChildNodes()).andStubReturn((Object)emptyNodeList);
        EasyMock.replay((Object[])new Object[]{parentNode});
        return new NodeListIterator(parentNode);
    }

    @Override
    public Iterator<Node> makeObject() {
        NodeList nodeList = new NodeList(){

            @Override
            public int getLength() {
                return NodeListIteratorTest.this.nodes.length;
            }

            @Override
            public Node item(int index) {
                return NodeListIteratorTest.this.nodes[index];
            }
        };
        return new NodeListIterator(nodeList);
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.createIteratorWithStandardConstr = true;
        Node node1 = (Node)EasyMock.createMock(Element.class);
        Node node2 = (Node)EasyMock.createMock(Element.class);
        Node node3 = (Node)EasyMock.createMock(Text.class);
        Node node4 = (Node)EasyMock.createMock(Element.class);
        this.nodes = new Node[]{node1, node2, node3, node4};
        EasyMock.replay((Object[])new Object[]{node1});
        EasyMock.replay((Object[])new Object[]{node2});
        EasyMock.replay((Object[])new Object[]{node3});
        EasyMock.replay((Object[])new Object[]{node4});
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testEmptyIteratorWithNodeConstructor() {
        this.createIteratorWithStandardConstr = false;
        this.testEmptyIterator();
    }

    @Test
    public void testFullIteratorWithNodeConstructor() {
        this.createIteratorWithStandardConstr = false;
        this.testFullIterator();
    }

    @Test
    public void testNullConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new NodeListIterator((Node)null));
    }
}

