/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.web;

import com.mockobjects.servlet.MockHttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.TestAbstractConfiguration;
import org.apache.commons.configuration.web.ServletRequestConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestServletRequestConfiguration
extends TestAbstractConfiguration {
    protected AbstractConfiguration getConfiguration() {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setListDelimiter('\u0000');
        configuration.setProperty("key1", (Object)"value1");
        configuration.setProperty("key2", (Object)"value2");
        configuration.addProperty("list", (Object)"value1");
        configuration.addProperty("list", (Object)"value2");
        configuration.addProperty("listesc", (Object)"value1\\,value2");
        return this.createConfiguration((Configuration)configuration);
    }

    protected AbstractConfiguration getEmptyConfiguration() {
        MockHttpServletRequest request = new MockHttpServletRequest(){

            public String getParameter(String key) {
                return null;
            }

            public Map<?, ?> getParameterMap() {
                return new HashMap();
            }
        };
        return new ServletRequestConfiguration((ServletRequest)request);
    }

    private ServletRequestConfiguration createConfiguration(final Configuration base) {
        MockHttpServletRequest request = new MockHttpServletRequest(){

            public String[] getParameterValues(String key) {
                return base.getStringArray(key);
            }

            public Map<?, ?> getParameterMap() {
                return new ConfigurationMap(base);
            }
        };
        return new ServletRequestConfiguration((ServletRequest)request);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddPropertyDirect() {
        super.testAddPropertyDirect();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClearProperty() {
        super.testClearProperty();
    }

    @Test
    public void testListWithEscapedElements() {
        String[] values = new String[]{"test1", "test2\\,test3", "test4\\,test5"};
        String listKey = "test.list";
        BaseConfiguration config = new BaseConfiguration();
        config.setListDelimiter('\u0000');
        config.addProperty(listKey, (Object)values);
        Assert.assertEquals((String)"Wrong number of list elements", (long)values.length, (long)config.getList(listKey).size());
        ServletRequestConfiguration c = this.createConfiguration((Configuration)config);
        List v = c.getList(listKey);
        Assert.assertEquals((String)"Wrong number of elements in list", (long)values.length, (long)v.size());
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((String)("Wrong value at index " + i), (Object)values[i].replaceAll("\\\\", ""), v.get(i));
        }
    }
}

