/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.exec.OS;
import org.junit.jupiter.api.Assertions;

public final class TestUtil {
    public static int[] getTestScriptCodesForOS() {
        if (OS.isFamilyWindows()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyUnix()) {
            return new int[]{0, 1};
        }
        if (OS.isFamilyOpenVms()) {
            return new int[]{1, 2};
        }
        Assertions.fail((String)"Test not supported for this OS");
        return null;
    }

    public static File resolveScriptFileForOS(String script) {
        return TestUtil.resolveScriptPathForOS(script).toFile();
    }

    public static Path resolveScriptPathForOS(String script) {
        if (OS.isFamilyWindows()) {
            return Paths.get(script + ".bat", new String[0]);
        }
        if (OS.isFamilyUnix()) {
            return Paths.get(script + ".sh", new String[0]);
        }
        if (OS.isFamilyOpenVms()) {
            return Paths.get(script + ".dcl", new String[0]);
        }
        Assertions.fail((String)"Test not supported for this OS");
        return null;
    }

    private TestUtil() {
    }
}

