/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.shape;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutRule;
import org.apache.commons.geometry.euclidean.AbstractNSphere;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.LinecastPoint3D;
import org.apache.commons.geometry.euclidean.threed.line.Linecastable3D;
import org.apache.commons.geometry.euclidean.threed.mesh.SimpleTriangleMesh;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.numbers.core.Precision;

public final class Sphere
extends AbstractNSphere<Vector3D>
implements Linecastable3D {
    private static final String INVALID_SUBDIVISION_MESSAGE = "Number of sphere approximation subdivisions must be greater than or equal to zero; was {0}";
    private static final double FOUR_PI = Math.PI * 4;
    private static final double FOUR_THIRDS_PI = 4.1887902047863905;

    private Sphere(Vector3D center, double radius, Precision.DoubleEquivalence precision) {
        super(center, radius, precision);
    }

    public double getSize() {
        double r = this.getRadius();
        return 4.1887902047863905 * r * r * r;
    }

    public double getBoundarySize() {
        double r = this.getRadius();
        return Math.PI * 4 * r * r;
    }

    public Vector3D project(Vector3D pt) {
        return this.project(pt, Vector3D.Unit.PLUS_X);
    }

    public RegionBSPTree3D toTree(int subdivisions) {
        if (subdivisions < 0) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_SUBDIVISION_MESSAGE, subdivisions));
        }
        return new SphereTreeApproximationBuilder(this, subdivisions).build();
    }

    public TriangleMesh toTriangleMesh(int subdivisions) {
        if (subdivisions < 0) {
            throw new IllegalArgumentException(MessageFormat.format(INVALID_SUBDIVISION_MESSAGE, subdivisions));
        }
        return new SphereMeshApproximationBuilder(this, subdivisions).build();
    }

    public List<Vector3D> intersections(Line3D line) {
        return this.intersections(line, Line3D::abscissa, Line3D::distance);
    }

    public Vector3D firstIntersection(Line3D line) {
        return this.firstIntersection(line, Line3D::abscissa, Line3D::distance);
    }

    @Override
    public List<LinecastPoint3D> linecast(LineConvexSubset3D subset) {
        return this.getLinecastStream(subset).collect(Collectors.toList());
    }

    @Override
    public LinecastPoint3D linecastFirst(LineConvexSubset3D subset) {
        return this.getLinecastStream(subset).findFirst().orElse(null);
    }

    private Stream<LinecastPoint3D> getLinecastStream(LineConvexSubset3D subset) {
        return this.intersections(subset.getLine()).stream().filter(subset::contains).map(pt -> new LinecastPoint3D((Vector3D)pt, ((Vector3D)this.getCenter()).directionTo((Vector3D)pt), subset.getLine()));
    }

    public static Sphere from(Vector3D center, double radius, Precision.DoubleEquivalence precision) {
        return new Sphere(center, radius, precision);
    }

    private static final class SphereMeshApproximationBuilder {
        private final Sphere sphere;
        private final int subdivisions;
        private final SimpleTriangleMesh.Builder builder;

        SphereMeshApproximationBuilder(Sphere sphere, int subdivisions) {
            this.sphere = sphere;
            this.subdivisions = subdivisions;
            this.builder = SimpleTriangleMesh.builder(sphere.getPrecision());
        }

        public SimpleTriangleMesh build() {
            Vector3D center = (Vector3D)this.sphere.getCenter();
            double radius = this.sphere.getRadius();
            double cx = center.getX();
            double cy = center.getY();
            double cz = center.getZ();
            Vector3D maxX = Vector3D.of(cx + radius, cy, cz);
            Vector3D minX = Vector3D.of(cx - radius, cy, cz);
            Vector3D maxY = Vector3D.of(cx, cy + radius, cz);
            Vector3D minY = Vector3D.of(cx, cy - radius, cz);
            Vector3D maxZ = Vector3D.of(cx, cy, cz + radius);
            Vector3D minZ = Vector3D.of(cx, cy, cz - radius);
            this.addSubdivided(minX, minZ, minY, 0);
            this.addSubdivided(minX, minY, maxZ, 0);
            this.addSubdivided(minX, maxY, minZ, 0);
            this.addSubdivided(minX, maxZ, maxY, 0);
            this.addSubdivided(maxX, minY, minZ, 0);
            this.addSubdivided(maxX, maxZ, minY, 0);
            this.addSubdivided(maxX, minZ, maxY, 0);
            this.addSubdivided(maxX, maxY, maxZ, 0);
            return this.builder.build();
        }

        private void addSubdivided(Vector3D p1, Vector3D p2, Vector3D p3, int level) {
            if (level >= this.subdivisions) {
                this.builder.addFaceUsingVertices(p1, p2, p3);
            } else {
                int nextLevel = level + 1;
                Vector3D m1 = this.sphere.project(p1.lerp(p2, 0.5));
                Vector3D m2 = this.sphere.project(p2.lerp(p3, 0.5));
                Vector3D m3 = this.sphere.project(p3.lerp(p1, 0.5));
                this.addSubdivided(p1, m1, m3, nextLevel);
                this.addSubdivided(m1, p2, m2, nextLevel);
                this.addSubdivided(m3, m2, p3, nextLevel);
                this.addSubdivided(m1, m2, m3, nextLevel);
            }
        }
    }

    private static final class SphereTreeApproximationBuilder {
        private static final int PARTITION_THRESHOLD = 2;
        private final Sphere sphere;
        private final int subdivisions;

        SphereTreeApproximationBuilder(Sphere sphere, int subdivisions) {
            this.sphere = sphere;
            this.subdivisions = subdivisions;
        }

        RegionBSPTree3D build() {
            RegionBSPTree3D tree = RegionBSPTree3D.empty();
            Vector3D center = (Vector3D)this.sphere.getCenter();
            double radius = this.sphere.getRadius();
            Precision.DoubleEquivalence precision = this.sphere.getPrecision();
            Plane plusXPlane = Planes.fromPointAndNormal(center, Vector3D.Unit.PLUS_X, precision);
            Plane plusYPlane = Planes.fromPointAndNormal(center, Vector3D.Unit.PLUS_Y, precision);
            Plane plusZPlane = Planes.fromPointAndNormal(center, Vector3D.Unit.PLUS_Z, precision);
            tree.insert(plusXPlane.span(), RegionCutRule.INHERIT);
            tree.insert(plusYPlane.span(), RegionCutRule.INHERIT);
            tree.insert(plusZPlane.span(), RegionCutRule.INHERIT);
            double cx = center.getX();
            double cy = center.getY();
            double cz = center.getZ();
            Vector3D maxX = Vector3D.of(cx + radius, cy, cz);
            Vector3D minX = Vector3D.of(cx - radius, cy, cz);
            Vector3D maxY = Vector3D.of(cx, cy + radius, cz);
            Vector3D minY = Vector3D.of(cx, cy - radius, cz);
            Vector3D maxZ = Vector3D.of(cx, cy, cz + radius);
            Vector3D minZ = Vector3D.of(cx, cy, cz - radius);
            RegionBSPTree3D.RegionNode3D root = (RegionBSPTree3D.RegionNode3D)tree.getRoot();
            try {
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getMinus()).getMinus()).getMinus(), minX, minZ, minY, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getMinus()).getMinus()).getPlus(), minX, minY, maxZ, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getMinus()).getPlus()).getMinus(), minX, maxY, minZ, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getMinus()).getPlus()).getPlus(), minX, maxZ, maxY, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getPlus()).getMinus()).getMinus(), maxX, minY, minZ, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getPlus()).getMinus()).getPlus(), maxX, maxZ, minY, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getPlus()).getPlus()).getMinus(), maxX, minZ, maxY, 0);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)((RegionBSPTree3D.RegionNode3D)root.getPlus()).getPlus()).getPlus(), maxX, maxY, maxZ, 0);
            }
            catch (IllegalArgumentException | IllegalStateException exc) {
                throw new IllegalStateException("Failed to construct sphere approximation with subdivision count " + this.subdivisions + ": " + exc.getMessage(), exc);
            }
            return tree;
        }

        private void partitionAndInsert(RegionBSPTree3D.RegionNode3D node, Vector3D p1, Vector3D p2, Vector3D p3, int level) {
            if (this.subdivisions - level > 2) {
                int nextLevel = level + 1;
                Vector3D center = (Vector3D)this.sphere.getCenter();
                Vector3D m1 = this.sphere.project(p1.lerp(p2, 0.5));
                Vector3D m2 = this.sphere.project(p2.lerp(p3, 0.5));
                Vector3D m3 = this.sphere.project(p3.lerp(p1, 0.5));
                RegionBSPTree3D.RegionNode3D curNode = node;
                this.checkedCut(curNode, this.createPlane(m3, m2, center), RegionCutRule.INHERIT);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)curNode.getPlus(), m3, m2, p3, nextLevel);
                curNode = (RegionBSPTree3D.RegionNode3D)curNode.getMinus();
                this.checkedCut(curNode, this.createPlane(m2, m1, center), RegionCutRule.INHERIT);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)curNode.getPlus(), m1, p2, m2, nextLevel);
                curNode = (RegionBSPTree3D.RegionNode3D)curNode.getMinus();
                this.checkedCut(curNode, this.createPlane(m1, m3, center), RegionCutRule.INHERIT);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)curNode.getPlus(), p1, m1, m3, nextLevel);
                this.partitionAndInsert((RegionBSPTree3D.RegionNode3D)curNode.getMinus(), m1, m2, m3, nextLevel);
            } else {
                this.insertSubdividedTriangles(node, p1, p2, p3, level);
            }
        }

        private RegionBSPTree3D.RegionNode3D insertSubdividedTriangles(RegionBSPTree3D.RegionNode3D node, Vector3D p1, Vector3D p2, Vector3D p3, int level) {
            if (level >= this.subdivisions) {
                this.checkedCut(node, this.createPlane(p1, p2, p3), RegionCutRule.MINUS_INSIDE);
                return (RegionBSPTree3D.RegionNode3D)node.getMinus();
            }
            int nextLevel = level + 1;
            Vector3D m1 = this.sphere.project(p1.lerp(p2, 0.5));
            Vector3D m2 = this.sphere.project(p2.lerp(p3, 0.5));
            Vector3D m3 = this.sphere.project(p3.lerp(p1, 0.5));
            RegionBSPTree3D.RegionNode3D curNode = node;
            curNode = this.insertSubdividedTriangles(curNode, p1, m1, m3, nextLevel);
            curNode = this.insertSubdividedTriangles(curNode, m1, p2, m2, nextLevel);
            curNode = this.insertSubdividedTriangles(curNode, m3, m2, p3, nextLevel);
            curNode = this.insertSubdividedTriangles(curNode, m1, m2, m3, nextLevel);
            return curNode;
        }

        private Plane createPlane(Vector3D p1, Vector3D p2, Vector3D p3) {
            return Planes.fromPoints(p1, p2, p3, this.sphere.getPrecision());
        }

        private void checkedCut(RegionBSPTree3D.RegionNode3D node, Plane cutter, RegionCutRule cutRule) {
            if (!node.insertCut((Hyperplane)cutter, cutRule)) {
                throw new IllegalStateException("Failed to cut BSP tree node with plane: " + (Object)((Object)cutter));
            }
        }
    }
}

