/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.rgbe.InfoHeader;

final class RgbeInfo
implements Closeable {
    private static final byte[] HEADER = new byte[]{35, 63, 82, 65, 68, 73, 65, 78, 67, 69};
    private static final Pattern RESOLUTION_STRING = Pattern.compile("-Y (\\d+) \\+X (\\d+)");
    private static final byte[] TWO_TWO = new byte[]{2, 2};
    private final InputStream in;
    private GenericImageMetadata metadata;
    private int width = -1;
    private int height = -1;

    private static void decompress(InputStream in, byte[] out) throws IOException, ImagingException {
        int position = 0;
        int total = out.length;
        while (position < total) {
            int n = in.read();
            if (n < 0) {
                throw new ImagingException("Error decompressing RGBE file");
            }
            if (n > 128) {
                int value = in.read();
                for (int i = 0; i < (n & 0x7F); ++i) {
                    out[position++] = (byte)value;
                }
                continue;
            }
            for (int i = 0; i < n; ++i) {
                out[position++] = (byte)in.read();
            }
        }
    }

    RgbeInfo(ByteSource byteSource) throws IOException {
        this.in = byteSource.getInputStream();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    int getHeight() throws IOException, ImagingException {
        if (-1 == this.height) {
            this.readDimensions();
        }
        return this.height;
    }

    ImageMetadata getMetadata() throws IOException, ImagingException {
        if (null == this.metadata) {
            this.readMetadata();
        }
        return this.metadata;
    }

    float[][] getPixelData() throws IOException, ImagingException {
        int ht = this.getHeight();
        int wd = this.getWidth();
        if (wd >= 32768) {
            throw new ImagingException("Scan lines must be less than 32768 bytes long");
        }
        byte[] scanLineBytes = ByteConversions.toBytes((short)wd, ByteOrder.BIG_ENDIAN);
        byte[] rgbe = Allocator.byteArray(wd * 4);
        float[][] out = new float[3][Allocator.check(wd * ht)];
        for (int i = 0; i < ht; ++i) {
            BinaryFunctions.readAndVerifyBytes(this.in, TWO_TWO, "Scan line " + i + " expected to start with 0x2 0x2");
            BinaryFunctions.readAndVerifyBytes(this.in, scanLineBytes, "Scan line " + i + " length expected");
            RgbeInfo.decompress(this.in, rgbe);
            for (int channel = 0; channel < 3; ++channel) {
                int channelOffset = channel * wd;
                int eOffset = 3 * wd;
                for (int p = 0; p < wd; ++p) {
                    int mantissa = rgbe[p + eOffset] & 0xFF;
                    int pos = p + i * wd;
                    if (0 == mantissa) {
                        out[channel][pos] = 0.0f;
                        continue;
                    }
                    float mult = (float)Math.pow(2.0, mantissa - 136);
                    out[channel][pos] = ((float)(rgbe[p + channelOffset] & 0xFF) + 0.5f) * mult;
                }
            }
        }
        return out;
    }

    int getWidth() throws IOException, ImagingException {
        if (-1 == this.width) {
            this.readDimensions();
        }
        return this.width;
    }

    private void readDimensions() throws IOException, ImagingException {
        this.getMetadata();
        InfoHeader header = new InfoHeader(this.in);
        String resolution = header.line();
        Matcher matcher = RESOLUTION_STRING.matcher(resolution);
        if (!matcher.matches()) {
            throw new ImagingException("Invalid HDR resolution string. Only \"-Y N +X M\" is supported. Found \"" + resolution + "\"");
        }
        this.height = Integer.parseInt(matcher.group(1));
        this.width = Integer.parseInt(matcher.group(2));
    }

    private void readMetadata() throws IOException, ImagingException {
        BinaryFunctions.readAndVerifyBytes(this.in, HEADER, "Not a valid HDR: Incorrect Header");
        InfoHeader reader = new InfoHeader(this.in);
        if (!reader.line().isEmpty()) {
            throw new ImagingException("Not a valid HDR: Incorrect Header");
        }
        this.metadata = new GenericImageMetadata();
        String info = reader.line();
        while (!info.isEmpty()) {
            int equals = info.indexOf(61);
            if (equals > 0) {
                String variable = info.substring(0, equals);
                String value = info.substring(equals + 1);
                if ("FORMAT".equals(value) && !"32-bit_rle_rgbe".equals(value)) {
                    throw new ImagingException("Only 32-bit_rle_rgbe images are supported, trying to read " + value);
                }
                this.metadata.add(variable, value);
            } else {
                this.metadata.add("<command>", info);
            }
            info = reader.line();
        }
    }
}

