/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.ExtendedKeyManager;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.KeyManager;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.TestMixedModelBean;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CoreFunctionTest
extends AbstractJXPathTest {
    private JXPathContext context;

    @Override
    @BeforeEach
    public void setUp() {
        if (this.context == null) {
            this.context = JXPathContext.newContext((Object)new TestMixedModelBean());
            Variables vars = this.context.getVariables();
            vars.declareVariable("nan", (Object)Double.NaN);
            vars.declareVariable("bool_true", (Object)Boolean.TRUE);
            vars.declareVariable("bool_false", (Object)Boolean.FALSE);
        }
    }

    @Test
    public void testCoreFunctions() {
        this.assertXPathValue(this.context, "string(2)", "2");
        this.assertXPathValue(this.context, "string($nan)", "NaN");
        this.assertXPathValue(this.context, "string(-$nan)", "NaN");
        this.assertXPathValue(this.context, "string(-2 div 0)", "-Infinity");
        this.assertXPathValue(this.context, "string(2 div 0)", "Infinity");
        this.assertXPathValue(this.context, "concat('a', 'b', 'c')", "abc");
        this.assertXPathValue(this.context, "starts-with('abc', 'ab')", Boolean.TRUE);
        this.assertXPathValue(this.context, "starts-with('xabc', 'ab')", Boolean.FALSE);
        this.assertXPathValue(this.context, "ends-with('abc', 'bc')", Boolean.TRUE);
        this.assertXPathValue(this.context, "ends-with('xabc', 'ab')", Boolean.FALSE);
        this.assertXPathValue(this.context, "contains('xabc', 'ab')", Boolean.TRUE);
        this.assertXPathValue(this.context, "contains('xabc', 'ba')", Boolean.FALSE);
        this.assertXPathValue(this.context, "substring-before('1999/04/01', '/')", "1999");
        this.assertXPathValue(this.context, "substring-after('1999/04/01', '/')", "04/01");
        this.assertXPathValue(this.context, "substring('12345', 2, 3)", "234");
        this.assertXPathValue(this.context, "substring('12345', 2)", "2345");
        this.assertXPathValue(this.context, "substring('12345', 1.5, 2.6)", "234");
        this.assertXPathValue(this.context, "substring('12345', 0, 3)", "12");
        this.assertXPathValue(this.context, "substring('12345', 0 div 0, 3)", "");
        this.assertXPathValue(this.context, "substring('12345', 1, 0 div 0)", "");
        this.assertXPathValue(this.context, "substring('12345', -42, 1 div 0)", "12345");
        this.assertXPathValue(this.context, "substring('12345', -1 div 0, 1 div 0)", "");
        this.assertXPathValue(this.context, "substring('12345', 6, 6)", "");
        this.assertXPathValue(this.context, "substring('12345', 7, 8)", "");
        this.assertXPathValue(this.context, "substring('12345', 7)", "");
        this.assertXPathValue(this.context, "string-length('12345')", 5.0);
        this.assertXPathValue(this.context, "normalize-space(' abc  def  ')", "abc def");
        this.assertXPathValue(this.context, "normalize-space('abc def')", "abc def");
        this.assertXPathValue(this.context, "normalize-space('   ')", "");
        this.assertXPathValue(this.context, "translate('--aaa--', 'abc-', 'ABC')", "AAA");
        this.assertXPathValue(this.context, "boolean(1)", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(0)", Boolean.FALSE);
        this.assertXPathValue(this.context, "boolean('x')", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean('')", Boolean.FALSE);
        this.assertXPathValue(this.context, "boolean(/list)", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(/list[position() < 1])", Boolean.FALSE);
        this.assertXPathValue(this.context, "true()", Boolean.TRUE);
        this.assertXPathValue(this.context, "false()", Boolean.FALSE);
        this.assertXPathValue(this.context, "not(false())", Boolean.TRUE);
        this.assertXPathValue(this.context, "not(true())", Boolean.FALSE);
        this.assertXPathValue(this.context, "null()", null);
        this.assertXPathValue(this.context, "number('1')", 1.0);
        this.assertXPathValue(this.context, "number($bool_true)", 1.0);
        this.assertXPathValue(this.context, "number($bool_false)", 0.0);
        this.assertXPathValue(this.context, "floor(1.5)", 1.0);
        this.assertXPathValue(this.context, "floor(-1.5)", -2.0);
        this.assertXPathValue(this.context, "ceiling(1.5)", 2.0);
        this.assertXPathValue(this.context, "ceiling(-1.5)", -1.0);
        this.assertXPathValue(this.context, "round(1.5)", 2.0);
        this.assertXPathValue(this.context, "round(-1.5)", -1.0);
        this.assertXPathValue(this.context, "floor('NaN')", Double.NaN);
        this.assertXPathValue(this.context, "floor(-2 div 0)", Double.NEGATIVE_INFINITY);
        this.assertXPathValue(this.context, "floor(2 div 0)", Double.POSITIVE_INFINITY);
        this.assertXPathValue(this.context, "ceiling('NaN')", Double.NaN);
        this.assertXPathValue(this.context, "ceiling(-2 div 0)", Double.NEGATIVE_INFINITY);
        this.assertXPathValue(this.context, "ceiling(2 div 0)", Double.POSITIVE_INFINITY);
        this.assertXPathValue(this.context, "round('NaN')", Double.NaN);
        this.assertXPathValue(this.context, "round(-2 div 0)", Double.NEGATIVE_INFINITY);
        this.assertXPathValue(this.context, "round(2 div 0)", Double.POSITIVE_INFINITY);
    }

    @Test
    public void testExtendedKeyFunction() {
        this.context.setKeyManager((KeyManager)new ExtendedKeyManager(){

            public NodeSet getNodeSetByKey(JXPathContext context, String keyName, Object keyValue) {
                return new NodeSet(){

                    public List getNodes() {
                        return Arrays.asList("53", "64");
                    }

                    public List getPointers() {
                        return Arrays.asList(NodePointer.newNodePointer(null, (Object)"53", null), NodePointer.newNodePointer(null, (Object)"64", null));
                    }

                    public List getValues() {
                        return Arrays.asList("53", "64");
                    }
                };
            }

            public Pointer getPointerByKey(JXPathContext context, String key, String value) {
                return NodePointer.newNodePointer(null, (Object)"incorrect", null);
            }
        });
        this.assertXPathValue(this.context, "key('a', 'b')", "53");
        this.assertXPathValue(this.context, "key('a', 'b')[1]", "53");
        this.assertXPathValue(this.context, "key('a', 'b')[2]", "64");
        this.assertXPathValueIterator(this.context, "key('a', 'b')", CoreFunctionTest.list("53", "64"));
        this.assertXPathValueIterator(this.context, "'x' | 'y'", CoreFunctionTest.list("x", "y"));
        this.assertXPathValueIterator(this.context, "key('a', 'x' | 'y')", CoreFunctionTest.list("53", "64", "53", "64"));
        this.assertXPathValueIterator(this.context, "key('a', /list[position() < 4])", CoreFunctionTest.list("53", "64", "53", "64", "53", "64"));
        this.context.getVariables().declareVariable("ints", (Object)new int[]{0, 0});
        this.assertXPathValueIterator(this.context, "key('a', $ints)", CoreFunctionTest.list("53", "64", "53", "64"));
    }

    @Test
    public void testFormatNumberFunction() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDigit('D');
        this.context.setDecimalFormatSymbols("test", symbols);
        this.assertXPathValue(this.context, "format-number(123456789, '#.000000000')", "123456789.000000000");
        this.assertXPathValue(this.context, "format-number(123456789, '#.0')", "123456789.0");
        this.assertXPathValue(this.context, "format-number(0.123456789, '##%')", "12%");
        this.assertXPathValue(this.context, "format-number(123456789, '################')", "123456789");
        this.assertXPathValue(this.context, "format-number(123456789, 'D.0', 'test')", "123456789.0");
        this.assertXPathValue(this.context, "format-number(123456789, '$DDD,DDD,DDD.DD', 'test')", "$123,456,789");
    }

    @Test
    public void testIDFunction() {
        this.context.setIdentityManager((context, id) -> {
            NodePointer ptr = (NodePointer)context.getPointer("/document");
            ptr = ptr.getValuePointer();
            return ptr.getPointerByID(context, id);
        });
        this.assertXPathValueAndPointer(this.context, "id(101)//street", "Tangerine Drive", "id('101')/address[1]/street[1]");
        this.assertXPathPointerLenient(this.context, "id(105)/address/street", "id(105)/address/street");
    }

    @Test
    public void testKeyFunction() {
        this.context.setKeyManager((context, key, value) -> NodePointer.newNodePointer(null, (Object)"42", null));
        this.assertXPathValue(this.context, "key('a', 'b')", "42");
    }
}

