/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.BitSet;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
class HashSetvBitSetTest
extends AbstractLangTest {
    private static final int numberOfElementsToCompute = 10;

    HashSetvBitSetTest() {
    }

    private static int[] extractIndices(BitSet coll) {
        int[] result = new int[coll.cardinality()];
        int i = 0;
        int j = 0;
        while ((j = coll.nextSetBit(j)) != -1) {
            result[i++] = j++;
        }
        return result;
    }

    private static int[] extractIndices(HashSet<Integer> coll) {
        int[] result = new int[coll.size()];
        int i = 0;
        for (Integer index : coll) {
            result[i++] = index;
        }
        return result;
    }

    @Benchmark
    public int[] testBitSet() {
        BitSet toRemove = new BitSet();
        int found = 0;
        for (int i = 0; i < 10; ++i) {
            toRemove.set(found++);
        }
        return HashSetvBitSetTest.extractIndices(toRemove);
    }

    @Benchmark
    public int[] testHashSet() {
        HashSet<Integer> toRemove = new HashSet<Integer>();
        int found = 0;
        for (int i = 0; i < 10; ++i) {
            toRemove.add(found++);
        }
        return HashSetvBitSetTest.extractIndices(toRemove);
    }

    @Benchmark
    public int[] timeBitSetRemoveAll() {
        BitSet toRemove = new BitSet();
        int[] array = new int[100];
        toRemove.set(10, 20);
        return (int[])ArrayUtils.removeAt((Object)array, (BitSet)toRemove);
    }

    @Benchmark
    public int[] timeExtractRemoveAll() {
        BitSet toRemove = new BitSet();
        int[] array = new int[100];
        toRemove.set(10, 20);
        int[] extractIndices = HashSetvBitSetTest.extractIndices(toRemove);
        return (int[])ArrayUtils.removeAll((Object)array, (int[])extractIndices);
    }
}

