/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MutableIntTest
extends AbstractLangTest {
    MutableIntTest() {
    }

    @Test
    void testAddAndGetValueObject() {
        MutableInt mutableInteger = new MutableInt(0);
        int result = mutableInteger.addAndGet((Number)1);
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)1, (int)mutableInteger.intValue());
    }

    @Test
    void testAddAndGetValuePrimitive() {
        MutableInt mutableInteger = new MutableInt(0);
        int result = mutableInteger.addAndGet(1);
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)1, (int)mutableInteger.intValue());
    }

    @Test
    void testAddValueObject() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.add((Number)1);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testAddValuePrimitive() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.add(1);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testCompareTo() {
        MutableInt mutNum = new MutableInt(0);
        Assertions.assertEquals((int)0, (int)mutNum.compareTo(new MutableInt(0)));
        Assertions.assertEquals((int)1, (int)mutNum.compareTo(new MutableInt(-1)));
        Assertions.assertEquals((int)-1, (int)mutNum.compareTo(new MutableInt(1)));
    }

    @Test
    void testCompareToNull() {
        MutableInt mutNum = new MutableInt(0);
        LangAssertions.assertNullPointerException(() -> mutNum.compareTo(null));
    }

    @Test
    void testConstructorNull() {
        LangAssertions.assertNullPointerException(() -> new MutableInt((Number)null));
    }

    @Test
    void testConstructors() {
        Assertions.assertEquals((int)0, (int)new MutableInt().intValue());
        Assertions.assertEquals((int)1, (int)new MutableInt(1).intValue());
        Assertions.assertEquals((int)2, (int)new MutableInt((Number)2).intValue());
        Assertions.assertEquals((int)3, (int)new MutableInt((Number)new MutableLong(3L)).intValue());
        Assertions.assertEquals((int)2, (int)new MutableInt("2").intValue());
    }

    @Test
    void testDecrement() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.decrement();
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testDecrementAndGet() {
        MutableInt mutNum = new MutableInt(1);
        int result = mutNum.decrementAndGet();
        Assertions.assertEquals((int)0, (int)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testEquals() {
        this.testEquals((Number)new MutableInt(0), (Number)new MutableInt(0), (Number)new MutableInt(1));
    }

    void testEquals(Number numA, Number numB, Number numC) {
        Assertions.assertEquals((Object)numA, (Object)numA);
        Assertions.assertEquals((Object)numA, (Object)numB);
        Assertions.assertEquals((Object)numB, (Object)numA);
        Assertions.assertEquals((Object)numB, (Object)numB);
        Assertions.assertNotEquals((Object)numA, (Object)numC);
        Assertions.assertNotEquals((Object)numB, (Object)numC);
        Assertions.assertEquals((Object)numC, (Object)numC);
        Assertions.assertNotEquals(null, (Object)numA);
        Assertions.assertNotEquals((Object)numA, (Object)0);
        Assertions.assertNotEquals((Object)"0", (Object)numA);
    }

    @Test
    void testGetAndAddValueObject() {
        MutableInt mutableInteger = new MutableInt(0);
        int result = mutableInteger.getAndAdd((Number)1);
        Assertions.assertEquals((int)0, (int)result);
        Assertions.assertEquals((int)1, (int)mutableInteger.intValue());
    }

    @Test
    void testGetAndAddValuePrimitive() {
        MutableInt mutableInteger = new MutableInt(0);
        int result = mutableInteger.getAndAdd(1);
        Assertions.assertEquals((int)0, (int)result);
        Assertions.assertEquals((int)1, (int)mutableInteger.intValue());
    }

    @Test
    void testGetAndDecrement() {
        MutableInt mutNum = new MutableInt(1);
        int result = mutNum.getAndDecrement();
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testGetAndIncrement() {
        MutableInt mutNum = new MutableInt(1);
        int result = mutNum.getAndIncrement();
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testGetSet() {
        MutableInt mutNum = new MutableInt(0);
        Assertions.assertEquals((int)0, (int)new MutableInt().intValue());
        Assertions.assertEquals((Object)0, (Object)new MutableInt().get());
        Assertions.assertEquals((Integer)0, (Integer)new MutableInt().getValue());
        mutNum.setValue(1);
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((Object)1, (Object)mutNum.get());
        Assertions.assertEquals((Integer)1, (Integer)mutNum.getValue());
        mutNum.setValue((Number)2);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((Object)2, (Object)mutNum.get());
        Assertions.assertEquals((Integer)2, (Integer)mutNum.getValue());
        mutNum.setValue((Number)new MutableLong(3L));
        Assertions.assertEquals((int)3, (int)mutNum.intValue());
        Assertions.assertEquals((Object)3, (Object)mutNum.get());
        Assertions.assertEquals((Integer)3, (Integer)mutNum.getValue());
    }

    @Test
    void testHashCode() {
        MutableInt mutNumA = new MutableInt(0);
        MutableInt mutNumB = new MutableInt(0);
        MutableInt mutNumC = new MutableInt(1);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)Integer.valueOf(0).hashCode());
    }

    @Test
    void testIncrement() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.increment();
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testIncrementAndGet() {
        MutableInt mutNum = new MutableInt(1);
        int result = mutNum.incrementAndGet();
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testPrimitiveValues() {
        MutableInt mutNum = new MutableInt(1);
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((float)1.0f, (float)mutNum.floatValue());
        Assertions.assertEquals((double)1.0, (double)mutNum.doubleValue());
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    void testSetNull() {
        MutableInt mutNum = new MutableInt(0);
        LangAssertions.assertNullPointerException(() -> mutNum.setValue(null));
    }

    @Test
    void testSubtractValueObject() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.subtract((Number)1);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testSubtractValuePrimitive() {
        MutableInt mutNum = new MutableInt(1);
        mutNum.subtract(1);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testToInteger() {
        Assertions.assertEquals((Integer)0, (Integer)new MutableInt(0).toInteger());
        Assertions.assertEquals((Integer)123, (Integer)new MutableInt(123).toInteger());
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"0", (Object)new MutableInt(0).toString());
        Assertions.assertEquals((Object)"10", (Object)new MutableInt(10).toString());
        Assertions.assertEquals((Object)"-123", (Object)new MutableInt(-123).toString());
    }
}

