/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.RealVectorAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class CholeskySolverTest {
    private double[][] testData = new double[][]{{1.0, 2.0, 4.0, 7.0, 11.0}, {2.0, 13.0, 23.0, 38.0, 58.0}, {4.0, 23.0, 77.0, 122.0, 182.0}, {7.0, 38.0, 122.0, 294.0, 430.0}, {11.0, 58.0, 182.0, 430.0, 855.0}};

    @Test
    public void testSolveDimensionErrors() {
        DecompositionSolver solver = new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[2][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(0)));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSolve() {
        int i;
        DecompositionSolver solver = new CholeskyDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[][]{{78.0, -13.0, 1.0}, {414.0, -62.0, -1.0}, {1312.0, -202.0, -37.0}, {2989.0, -542.0, 145.0}, {5510.0, -1465.0, 201.0}});
        RealMatrix xRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {2.0, 1.0, -4.0}, {2.0, 2.0, 2.0}, {5.0, -3.0, 0.0}});
        Assert.assertEquals((double)0.0, (double)solver.solve(b).subtract(xRef).getNorm(), (double)1.0E-13);
        for (i = 0; i < b.getColumnDimension(); ++i) {
            Assert.assertEquals((double)0.0, (double)solver.solve(b.getColumnVector(i)).subtract(xRef.getColumnVector(i)).getNorm(), (double)1.0E-13);
        }
        for (i = 0; i < b.getColumnDimension(); ++i) {
            RealVectorAbstractTest.RealVectorTestImpl v = new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(i));
            Assert.assertEquals((double)0.0, (double)solver.solve((RealVector)v).subtract(xRef.getColumnVector(i)).getNorm(), (double)1.0E-13);
        }
    }

    @Test
    public void testDeterminant() {
        Assert.assertEquals((double)7290000.0, (double)this.getDeterminant(MatrixUtils.createRealMatrix((double[][])this.testData)), (double)1.0E-15);
    }

    private double getDeterminant(RealMatrix m) {
        return new CholeskyDecomposition(m).getDeterminant();
    }
}

