/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.regression;

import java.util.Arrays;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.stat.regression.ModelSpecificationException;
import org.apache.commons.math4.legacy.stat.regression.RegressionResults;
import org.apache.commons.math4.legacy.stat.regression.UpdatingMultipleLinearRegression;
import org.apache.commons.numbers.core.Precision;

public class MillerUpdatingRegression
implements UpdatingMultipleLinearRegression {
    private final int nvars;
    private final double[] d;
    private final double[] rhs;
    private final double[] r;
    private final double[] tol;
    private final double[] rss;
    private final int[] vorder;
    private final double[] workTolset;
    private long nobs;
    private double sserr;
    private boolean rssSet;
    private boolean tolSet;
    private final boolean[] lindep;
    private final double[] xSing;
    private final double[] workSing;
    private double sumy;
    private double sumsqy;
    private final boolean hasIntercept;
    private final double epsilon;

    private MillerUpdatingRegression() {
        this(-1, false, Double.NaN);
    }

    public MillerUpdatingRegression(int numberOfVariables, boolean includeConstant, double errorTolerance) throws ModelSpecificationException {
        if (numberOfVariables < 1) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.NO_REGRESSORS, new Object[0]);
        }
        this.nvars = includeConstant ? numberOfVariables + 1 : numberOfVariables;
        this.hasIntercept = includeConstant;
        this.nobs = 0L;
        this.d = new double[this.nvars];
        this.rhs = new double[this.nvars];
        this.r = new double[this.nvars * (this.nvars - 1) / 2];
        this.tol = new double[this.nvars];
        this.rss = new double[this.nvars];
        this.vorder = new int[this.nvars];
        this.xSing = new double[this.nvars];
        this.workSing = new double[this.nvars];
        this.workTolset = new double[this.nvars];
        this.lindep = new boolean[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            this.vorder[i] = i;
        }
        this.epsilon = errorTolerance > 0.0 ? errorTolerance : -errorTolerance;
    }

    public MillerUpdatingRegression(int numberOfVariables, boolean includeConstant) throws ModelSpecificationException {
        this(numberOfVariables, includeConstant, Precision.EPSILON);
    }

    @Override
    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    @Override
    public long getN() {
        return this.nobs;
    }

    @Override
    public void addObservation(double[] x, double y) throws ModelSpecificationException {
        if (!this.hasIntercept && x.length != this.nvars || this.hasIntercept && x.length + 1 != this.nvars) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.INVALID_REGRESSION_OBSERVATION, x.length, this.nvars);
        }
        if (!this.hasIntercept) {
            this.include(Arrays.copyOf(x, x.length), 1.0, y);
        } else {
            double[] tmp = new double[x.length + 1];
            System.arraycopy(x, 0, tmp, 1, x.length);
            tmp[0] = 1.0;
            this.include(tmp, 1.0, y);
        }
        ++this.nobs;
    }

    @Override
    public void addObservations(double[][] x, double[] y) throws ModelSpecificationException {
        if (x == null || y == null || x.length != y.length) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, x == null ? 0 : x.length, y == null ? 0 : y.length);
        }
        if (x.length == 0) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (x[0].length + 1 > x.length) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, x.length, x[0].length);
        }
        for (int i = 0; i < x.length; ++i) {
            this.addObservation(x[i], y[i]);
        }
    }

    private void include(double[] x, double wi, double yi) {
        int nextr = 0;
        double w = wi;
        double y = yi;
        this.rssSet = false;
        this.sumy = this.smartAdd(yi, this.sumy);
        this.sumsqy = this.smartAdd(this.sumsqy, yi * yi);
        for (int i = 0; i < x.length; ++i) {
            double xk;
            double dpi;
            if (w == 0.0) {
                return;
            }
            double xi = x[i];
            if (xi == 0.0) {
                nextr += this.nvars - i - 1;
                continue;
            }
            double di = this.d[i];
            double wxi = w * xi;
            double wPrev = w;
            if (di != 0.0) {
                dpi = this.smartAdd(di, wxi * xi);
                double tmp = wxi * xi / di;
                if (JdkMath.abs((double)tmp) > Precision.EPSILON) {
                    w = di * w / dpi;
                }
            } else {
                dpi = wxi * xi;
                w = 0.0;
            }
            this.d[i] = dpi;
            for (int k = i + 1; k < this.nvars; ++k) {
                xk = x[k];
                x[k] = this.smartAdd(xk, -xi * this.r[nextr]);
                this.r[nextr] = di != 0.0 ? this.smartAdd(di * this.r[nextr], wPrev * xi * xk) / dpi : xk / xi;
                ++nextr;
            }
            xk = y;
            y = this.smartAdd(xk, -xi * this.rhs[i]);
            this.rhs[i] = di != 0.0 ? this.smartAdd(di * this.rhs[i], wxi * xk) / dpi : xk / xi;
        }
        this.sserr = this.smartAdd(this.sserr, w * y * y);
    }

    private double smartAdd(double a, double b) {
        double ba;
        double aa = JdkMath.abs((double)a);
        if (aa > (ba = JdkMath.abs((double)b))) {
            double eps = aa * Precision.EPSILON;
            if (ba > eps) {
                return a + b;
            }
            return a;
        }
        double eps = ba * Precision.EPSILON;
        if (aa > eps) {
            return a + b;
        }
        return b;
    }

    @Override
    public void clear() {
        Arrays.fill(this.d, 0.0);
        Arrays.fill(this.rhs, 0.0);
        Arrays.fill(this.r, 0.0);
        Arrays.fill(this.tol, 0.0);
        Arrays.fill(this.rss, 0.0);
        Arrays.fill(this.workTolset, 0.0);
        Arrays.fill(this.workSing, 0.0);
        Arrays.fill(this.xSing, 0.0);
        Arrays.fill(this.lindep, false);
        for (int i = 0; i < this.nvars; ++i) {
            this.vorder[i] = i;
        }
        this.nobs = 0L;
        this.sserr = 0.0;
        this.sumy = 0.0;
        this.sumsqy = 0.0;
        this.rssSet = false;
        this.tolSet = false;
    }

    private void tolset() {
        double eps = this.epsilon;
        for (int i = 0; i < this.nvars; ++i) {
            this.workTolset[i] = JdkMath.sqrt((double)this.d[i]);
        }
        this.tol[0] = eps * this.workTolset[0];
        for (int col = 1; col < this.nvars; ++col) {
            int pos = col - 1;
            double total = this.workTolset[col];
            for (int row = 0; row < col; ++row) {
                total += JdkMath.abs((double)this.r[pos]) * this.workTolset[row];
                pos += this.nvars - row - 2;
            }
            this.tol[col] = eps * total;
        }
        this.tolSet = true;
    }

    private double[] regcf(int nreq) throws ModelSpecificationException {
        int i;
        if (nreq < 1) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.NO_REGRESSORS, new Object[0]);
        }
        if (nreq > this.nvars) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.TOO_MANY_REGRESSORS, nreq, this.nvars);
        }
        if (!this.tolSet) {
            this.tolset();
        }
        double[] ret = new double[nreq];
        boolean rankProblem = false;
        for (i = nreq - 1; i > -1; --i) {
            if (JdkMath.sqrt((double)this.d[i]) < this.tol[i]) {
                ret[i] = 0.0;
                this.d[i] = 0.0;
                rankProblem = true;
                continue;
            }
            ret[i] = this.rhs[i];
            int nextr = i * (this.nvars + this.nvars - i - 1) / 2;
            for (int j = i + 1; j < nreq; ++j) {
                ret[i] = this.smartAdd(ret[i], -this.r[nextr] * ret[j]);
                ++nextr;
            }
        }
        if (rankProblem) {
            for (i = 0; i < nreq; ++i) {
                if (!this.lindep[i]) continue;
                ret[i] = Double.NaN;
            }
        }
        return ret;
    }

    private void singcheck() {
        for (int i = 0; i < this.nvars; ++i) {
            this.workSing[i] = JdkMath.sqrt((double)this.d[i]);
        }
        for (int col = 0; col < this.nvars; ++col) {
            double temp = this.tol[col];
            int pos = col - 1;
            for (int row = 0; row < col - 1; ++row) {
                if (JdkMath.abs((double)this.r[pos]) * this.workSing[row] < temp) {
                    this.r[pos] = 0.0;
                }
                pos += this.nvars - row - 2;
            }
            this.lindep[col] = false;
            if (!(this.workSing[col] < temp)) continue;
            this.lindep[col] = true;
            if (col < this.nvars - 1) {
                Arrays.fill(this.xSing, 0.0);
                int pi = col * (this.nvars + this.nvars - col - 1) / 2;
                int xi = col + 1;
                while (xi < this.nvars) {
                    this.xSing[xi] = this.r[pi];
                    this.r[pi] = 0.0;
                    ++xi;
                    ++pi;
                }
                double y = this.rhs[col];
                double weight = this.d[col];
                this.d[col] = 0.0;
                this.rhs[col] = 0.0;
                this.include(this.xSing, weight, y);
                continue;
            }
            this.sserr += this.d[col] * this.rhs[col] * this.rhs[col];
        }
    }

    private void ss() {
        double total = this.sserr;
        this.rss[this.nvars - 1] = this.sserr;
        for (int i = this.nvars - 1; i > 0; --i) {
            this.rss[i - 1] = total += this.d[i] * this.rhs[i] * this.rhs[i];
        }
        this.rssSet = true;
    }

    private double[] cov(int nreq) {
        if (this.nobs <= (long)nreq) {
            return null;
        }
        double rnk = 0.0;
        for (int i = 0; i < nreq; ++i) {
            if (this.lindep[i]) continue;
            rnk += 1.0;
        }
        double var = this.rss[nreq - 1] / ((double)this.nobs - rnk);
        double[] rinv = new double[nreq * (nreq - 1) / 2];
        this.inverse(rinv, nreq);
        double[] covmat = new double[nreq * (nreq + 1) / 2];
        Arrays.fill(covmat, Double.NaN);
        int start = 0;
        double total = 0.0;
        for (int row = 0; row < nreq; ++row) {
            int pos2 = start;
            if (!this.lindep[row]) {
                for (int col = row; col < nreq; ++col) {
                    if (!this.lindep[col]) {
                        int pos1 = start + col - row;
                        total = row == col ? 1.0 / this.d[col] : rinv[pos1 - 1] / this.d[col];
                        for (int k = col + 1; k < nreq; ++k) {
                            if (!this.lindep[k]) {
                                total += rinv[pos1] * rinv[pos2] / this.d[k];
                            }
                            ++pos1;
                            ++pos2;
                        }
                        covmat[(col + 1) * col / 2 + row] = total * var;
                        continue;
                    }
                    pos2 += nreq - col - 1;
                }
            }
            start += nreq - row - 1;
        }
        return covmat;
    }

    private void inverse(double[] rinv, int nreq) {
        int pos = nreq * (nreq - 1) / 2 - 1;
        int pos1 = -1;
        int pos2 = -1;
        double total = 0.0;
        Arrays.fill(rinv, Double.NaN);
        for (int row = nreq - 1; row > 0; --row) {
            if (!this.lindep[row]) {
                int start = (row - 1) * (this.nvars + this.nvars - row) / 2;
                for (int col = nreq; col > row; --col) {
                    pos1 = start;
                    pos2 = pos;
                    total = 0.0;
                    for (int k = row; k < col - 1; ++k) {
                        pos2 += nreq - k - 1;
                        if (!this.lindep[k]) {
                            total += -this.r[pos1] * rinv[pos2];
                        }
                        ++pos1;
                    }
                    rinv[pos] = total - this.r[pos1];
                    --pos;
                }
                continue;
            }
            pos -= nreq - row;
        }
    }

    public double[] getPartialCorrelations(int in) {
        int row;
        int pos;
        double[] output = new double[(this.nvars - in + 1) * (this.nvars - in) / 2];
        int rmsOff = -in;
        int wrkOff = -(in + 1);
        double[] rms = new double[this.nvars - in];
        double[] work = new double[this.nvars - in - 1];
        int offXX = (this.nvars - in) * (this.nvars - in - 1) / 2;
        if (in < -1 || in >= this.nvars) {
            return null;
        }
        int nvm = this.nvars - 1;
        int basePos = this.r.length - (nvm - in) * (nvm - in + 1) / 2;
        if (this.d[in] > 0.0) {
            rms[in + rmsOff] = 1.0 / JdkMath.sqrt((double)this.d[in]);
        }
        for (int col = in + 1; col < this.nvars; ++col) {
            pos = basePos + col - 1 - in;
            double sumxx = this.d[col];
            for (row = in; row < col; ++row) {
                sumxx += this.d[row] * this.r[pos] * this.r[pos];
                pos += this.nvars - row - 2;
            }
            rms[col + rmsOff] = sumxx > 0.0 ? 1.0 / JdkMath.sqrt((double)sumxx) : 0.0;
        }
        double sumyy = this.sserr;
        for (int row2 = in; row2 < this.nvars; ++row2) {
            sumyy += this.d[row2] * this.rhs[row2] * this.rhs[row2];
        }
        if (sumyy > 0.0) {
            sumyy = 1.0 / JdkMath.sqrt((double)sumyy);
        }
        pos = 0;
        for (int col1 = in; col1 < this.nvars; ++col1) {
            int pos2;
            double sumxy = 0.0;
            Arrays.fill(work, 0.0);
            int pos1 = basePos + col1 - in - 1;
            for (row = in; row < col1; ++row) {
                pos2 = pos1 + 1;
                for (int col2 = col1 + 1; col2 < this.nvars; ++col2) {
                    int n = col2 + wrkOff;
                    work[n] = work[n] + this.d[row] * this.r[pos1] * this.r[pos2];
                    ++pos2;
                }
                sumxy += this.d[row] * this.r[pos1] * this.rhs[row];
                pos1 += this.nvars - row - 2;
            }
            pos2 = pos1 + 1;
            for (int col2 = col1 + 1; col2 < this.nvars; ++col2) {
                int n = col2 + wrkOff;
                work[n] = work[n] + this.d[col1] * this.r[pos2];
                ++pos2;
                output[(col2 - 1 - in) * (col2 - in) / 2 + col1 - in] = work[col2 + wrkOff] * rms[col1 + rmsOff] * rms[col2 + rmsOff];
                ++pos;
            }
            output[col1 + rmsOff + offXX] = (sumxy += this.d[col1] * this.rhs[col1]) * rms[col1 + rmsOff] * sumyy;
        }
        return output;
    }

    private void vmove(int from, int to) {
        int inc;
        int first;
        boolean bSkipTo40 = false;
        if (from == to) {
            return;
        }
        if (!this.rssSet) {
            this.ss();
        }
        int count = 0;
        if (from < to) {
            first = from;
            inc = 1;
            count = to - from;
        } else {
            first = from - 1;
            inc = -1;
            count = from - to;
        }
        int m = first;
        for (int idx = 0; idx < count; ++idx) {
            double x;
            int m1 = m * (this.nvars + this.nvars - m - 1) / 2;
            int m2 = m1 + this.nvars - m - 1;
            int mp1 = m + 1;
            double d1 = this.d[m];
            double d2 = this.d[mp1];
            if (d1 > this.epsilon || d2 > this.epsilon) {
                int col;
                x = this.r[m1];
                if (JdkMath.abs((double)x) * JdkMath.sqrt((double)d1) < this.tol[mp1]) {
                    x = 0.0;
                }
                if (d1 < this.epsilon || JdkMath.abs((double)x) < this.epsilon) {
                    this.d[m] = d2;
                    this.d[mp1] = d1;
                    this.r[m1] = 0.0;
                    for (col = m + 2; col < this.nvars; ++col) {
                        x = this.r[++m1];
                        this.r[m1] = this.r[m2];
                        this.r[m2] = x;
                        ++m2;
                    }
                    x = this.rhs[m];
                    this.rhs[m] = this.rhs[mp1];
                    this.rhs[mp1] = x;
                    bSkipTo40 = true;
                } else if (d2 < this.epsilon) {
                    this.d[m] = d1 * x * x;
                    this.r[m1] = 1.0 / x;
                    int i = m1 + 1;
                    while (i < m1 + this.nvars - m - 1) {
                        int n = i++;
                        this.r[n] = this.r[n] / x;
                    }
                    int n = m;
                    this.rhs[n] = this.rhs[n] / x;
                    bSkipTo40 = true;
                }
                if (!bSkipTo40) {
                    double y;
                    double d1new = d2 + d1 * x * x;
                    double cbar = d2 / d1new;
                    double sbar = x * d1 / d1new;
                    double d2new = d1 * cbar;
                    this.d[m] = d1new;
                    this.d[mp1] = d2new;
                    this.r[m1] = sbar;
                    for (col = m + 2; col < this.nvars; ++col) {
                        y = this.r[++m1];
                        this.r[m1] = cbar * this.r[m2] + sbar * y;
                        this.r[m2] = y - x * this.r[m2];
                        ++m2;
                    }
                    y = this.rhs[m];
                    this.rhs[m] = cbar * this.rhs[mp1] + sbar * y;
                    this.rhs[mp1] = y - x * this.rhs[mp1];
                }
            }
            if (m > 0) {
                int pos = m;
                for (int row = 0; row < m; ++row) {
                    x = this.r[pos];
                    this.r[pos] = this.r[pos - 1];
                    this.r[pos - 1] = x;
                    pos += this.nvars - row - 2;
                }
            }
            m1 = this.vorder[m];
            this.vorder[m] = this.vorder[mp1];
            this.vorder[mp1] = m1;
            x = this.tol[m];
            this.tol[m] = this.tol[mp1];
            this.tol[mp1] = x;
            this.rss[m] = this.rss[mp1] + this.d[mp1] * this.rhs[mp1] * this.rhs[mp1];
            m += inc;
        }
    }

    private int reorderRegressors(int[] list, int pos1) {
        if (list.length < 1 || list.length > this.nvars + 1 - pos1) {
            return -1;
        }
        int next = pos1;
        block0: for (int i = pos1; i < this.nvars; ++i) {
            int l = this.vorder[i];
            for (int j = 0; j < list.length; ++j) {
                if (l != list[j] || i <= next) continue;
                this.vmove(i, next);
                if (++next < list.length + pos1) continue block0;
                return 0;
            }
        }
        return 0;
    }

    public double getDiagonalOfHatMatrix(double[] rowData) {
        double[] xrow;
        double[] wk = new double[this.nvars];
        if (rowData.length > this.nvars) {
            return Double.NaN;
        }
        if (this.hasIntercept) {
            xrow = new double[rowData.length + 1];
            xrow[0] = 1.0;
            System.arraycopy(rowData, 0, xrow, 1, rowData.length);
        } else {
            xrow = rowData;
        }
        double hii = 0.0;
        for (int col = 0; col < xrow.length; ++col) {
            if (JdkMath.sqrt((double)this.d[col]) < this.tol[col]) {
                wk[col] = 0.0;
                continue;
            }
            int pos = col - 1;
            double total = xrow[col];
            for (int row = 0; row < col; ++row) {
                total = this.smartAdd(total, -wk[row] * this.r[pos]);
                pos += this.nvars - row - 2;
            }
            wk[col] = total;
            hii = this.smartAdd(hii, total * total / this.d[col]);
        }
        return hii;
    }

    public int[] getOrderOfRegressors() {
        return Arrays.copyOf(this.vorder, this.vorder.length);
    }

    @Override
    public RegressionResults regress() throws ModelSpecificationException {
        return this.regress(this.nvars);
    }

    public RegressionResults regress(int numberOfRegressors) throws ModelSpecificationException {
        if (this.nobs <= (long)numberOfRegressors) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, this.nobs, numberOfRegressors);
        }
        if (numberOfRegressors > this.nvars) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.TOO_MANY_REGRESSORS, numberOfRegressors, this.nvars);
        }
        this.tolset();
        this.singcheck();
        double[] beta = this.regcf(numberOfRegressors);
        this.ss();
        double[] cov = this.cov(numberOfRegressors);
        int rnk = 0;
        for (int i = 0; i < this.lindep.length; ++i) {
            if (this.lindep[i]) continue;
            ++rnk;
        }
        boolean needsReorder = false;
        for (int i = 0; i < numberOfRegressors; ++i) {
            if (this.vorder[i] == i) continue;
            needsReorder = true;
            break;
        }
        if (!needsReorder) {
            return new RegressionResults(beta, new double[][]{cov}, true, this.nobs, rnk, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
        }
        double[] betaNew = new double[beta.length];
        double[] covNew = new double[cov.length];
        int[] newIndices = new int[beta.length];
        for (int i = 0; i < this.nvars; ++i) {
            for (int j = 0; j < numberOfRegressors; ++j) {
                if (this.vorder[j] != i) continue;
                betaNew[i] = beta[j];
                newIndices[i] = j;
            }
        }
        int idx1 = 0;
        for (int i = 0; i < beta.length; ++i) {
            int ii = newIndices[i];
            int j = 0;
            while (j <= i) {
                int jj = newIndices[j];
                int idx2 = ii > jj ? ii * (ii + 1) / 2 + jj : jj * (jj + 1) / 2 + ii;
                covNew[idx1] = cov[idx2];
                ++j;
                ++idx1;
            }
        }
        return new RegressionResults(betaNew, new double[][]{covNew}, true, this.nobs, rnk, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
    }

    @Override
    public RegressionResults regress(int[] variablesToInclude) throws ModelSpecificationException {
        int[] series;
        if (variablesToInclude.length > this.nvars) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.TOO_MANY_REGRESSORS, variablesToInclude.length, this.nvars);
        }
        if (this.nobs <= (long)this.nvars) {
            throw new ModelSpecificationException((Localizable)LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, this.nobs, this.nvars);
        }
        Arrays.sort(variablesToInclude);
        int iExclude = 0;
        for (int i = 0; i < variablesToInclude.length; ++i) {
            if (i >= this.nvars) {
                throw new ModelSpecificationException((Localizable)LocalizedFormats.INDEX_LARGER_THAN_MAX, i, this.nvars);
            }
            if (i <= 0 || variablesToInclude[i] != variablesToInclude[i - 1]) continue;
            variablesToInclude[i] = -1;
            ++iExclude;
        }
        if (iExclude > 0) {
            int j = 0;
            series = new int[variablesToInclude.length - iExclude];
            for (int i = 0; i < variablesToInclude.length; ++i) {
                if (variablesToInclude[i] <= -1) continue;
                series[j] = variablesToInclude[i];
                ++j;
            }
        } else {
            series = variablesToInclude;
        }
        this.reorderRegressors(series, 0);
        this.tolset();
        this.singcheck();
        double[] beta = this.regcf(series.length);
        this.ss();
        double[] cov = this.cov(series.length);
        int rnk = 0;
        for (int i = 0; i < this.lindep.length; ++i) {
            if (this.lindep[i]) continue;
            ++rnk;
        }
        boolean needsReorder = false;
        for (int i = 0; i < series.length; ++i) {
            if (this.vorder[i] == series[i]) continue;
            needsReorder = true;
            break;
        }
        if (!needsReorder) {
            return new RegressionResults(beta, new double[][]{cov}, true, this.nobs, rnk, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
        }
        double[] betaNew = new double[beta.length];
        int[] newIndices = new int[beta.length];
        for (int i = 0; i < series.length; ++i) {
            for (int j = 0; j < this.vorder.length; ++j) {
                if (this.vorder[j] != series[i]) continue;
                betaNew[i] = beta[j];
                newIndices[i] = j;
            }
        }
        double[] covNew = new double[cov.length];
        int idx1 = 0;
        for (int i = 0; i < beta.length; ++i) {
            int ii = newIndices[i];
            int j = 0;
            while (j <= i) {
                int jj = newIndices[j];
                int idx2 = ii > jj ? ii * (ii + 1) / 2 + jj : jj * (jj + 1) / 2 + ii;
                covNew[idx1] = cov[idx2];
                ++j;
                ++idx1;
            }
        }
        return new RegressionResults(betaNew, new double[][]{covNew}, true, this.nobs, rnk, this.sumy, this.sumsqy, this.sserr, this.hasIntercept, false);
    }
}

