/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.utils.CorbaFixedAnyImplClassCreator;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.W3CConstants;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public final class CorbaAnyHelper {
    private static final Map<QName, QName> SCHEMA_TO_IDL_TYPES = new HashMap<QName, QName>();
    private static final Map<QName, QName> IDL_TO_SCHEMA_TYPES = new HashMap<QName, QName>();
    private static Constructor<?> fixedAnyConstructor;

    private CorbaAnyHelper() {
    }

    public static Any createAny(ORB orb, Bus bus) {
        Any value = orb.create_any();
        if ("com.sun.corba.se.impl.corba.AnyImpl".equals(value.getClass().getName())) {
            value = CorbaAnyHelper.createFixedAny(orb, value, bus);
        }
        return value;
    }

    public static boolean isPrimitiveSchemaType(QName schemaType) {
        return SCHEMA_TO_IDL_TYPES.get(schemaType) != null;
    }

    public static boolean isPrimitiveIdlType(QName idlType) {
        return IDL_TO_SCHEMA_TYPES.get(idlType) != null;
    }

    public static QName convertPrimitiveSchemaToIdlType(QName schemaType) {
        return SCHEMA_TO_IDL_TYPES.get(schemaType);
    }

    public static QName convertPrimitiveIdlToSchemaType(QName idlType) {
        return IDL_TO_SCHEMA_TYPES.get(idlType);
    }

    public static QName getPrimitiveIdlTypeFromTypeCode(TypeCode tc) {
        TCKind type = tc.kind();
        QName result = null;
        switch (type.value()) {
            case 8: {
                result = CorbaConstants.NT_CORBA_BOOLEAN;
                break;
            }
            case 9: {
                result = CorbaConstants.NT_CORBA_CHAR;
                break;
            }
            case 26: {
                result = CorbaConstants.NT_CORBA_WCHAR;
                break;
            }
            case 10: {
                result = CorbaConstants.NT_CORBA_OCTET;
                break;
            }
            case 2: {
                result = CorbaConstants.NT_CORBA_SHORT;
                break;
            }
            case 4: {
                result = CorbaConstants.NT_CORBA_USHORT;
                break;
            }
            case 3: {
                result = CorbaConstants.NT_CORBA_LONG;
                break;
            }
            case 5: {
                result = CorbaConstants.NT_CORBA_ULONG;
                break;
            }
            case 23: {
                result = CorbaConstants.NT_CORBA_LONGLONG;
                break;
            }
            case 24: {
                result = CorbaConstants.NT_CORBA_ULONGLONG;
                break;
            }
            case 6: {
                result = CorbaConstants.NT_CORBA_FLOAT;
                break;
            }
            case 7: {
                result = CorbaConstants.NT_CORBA_DOUBLE;
                break;
            }
            case 18: {
                result = CorbaConstants.NT_CORBA_STRING;
                break;
            }
            case 27: {
                result = CorbaConstants.NT_CORBA_WSTRING;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static void insertPrimitiveIntoAny(Any a, CorbaPrimitiveHandler primitive) throws CorbaBindingException {
        assert (primitive != null);
        switch (primitive.getTypeCode().kind().value()) {
            case 8: {
                a.insert_boolean(((Boolean)primitive.getValue()).booleanValue());
                break;
            }
            case 9: {
                a.insert_char(((Character)primitive.getValue()).charValue());
                break;
            }
            case 26: {
                a.insert_wchar(((Character)primitive.getValue()).charValue());
                break;
            }
            case 10: {
                a.insert_octet(((Byte)primitive.getValue()).byteValue());
                break;
            }
            case 2: {
                a.insert_short(((Short)primitive.getValue()).shortValue());
                break;
            }
            case 4: {
                a.insert_ushort(((Integer)primitive.getValue()).shortValue());
                break;
            }
            case 3: {
                a.insert_long(((Integer)primitive.getValue()).intValue());
                break;
            }
            case 5: {
                a.insert_ulong(((BigInteger)primitive.getValue()).intValue());
                break;
            }
            case 23: {
                a.insert_longlong(((Long)primitive.getValue()).longValue());
                break;
            }
            case 24: {
                a.insert_ulonglong((long)((BigInteger)primitive.getValue()).intValue());
                break;
            }
            case 6: {
                a.insert_float(((Float)primitive.getValue()).floatValue());
                break;
            }
            case 7: {
                a.insert_double(((Double)primitive.getValue()).doubleValue());
                break;
            }
            case 18: {
                a.insert_string((String)primitive.getValue());
                break;
            }
            case 27: {
                a.insert_wstring((String)primitive.getValue());
                break;
            }
            default: {
                throw new CorbaBindingException("Unable to insert type into any.  Kind = " + primitive.getTypeCode().kind().value());
            }
        }
    }

    public static void extractPrimitiveFromAny(Any a, CorbaPrimitiveHandler primitive) {
        assert (primitive != null);
        switch (primitive.getTypeCode().kind().value()) {
            case 8: {
                primitive.setValue(a.extract_boolean());
                break;
            }
            case 9: {
                primitive.setValue(Character.valueOf(a.extract_char()));
                break;
            }
            case 26: {
                primitive.setValue(Character.valueOf(a.extract_wchar()));
                break;
            }
            case 10: {
                primitive.setValue(a.extract_octet());
                break;
            }
            case 2: {
                primitive.setValue(a.extract_short());
                break;
            }
            case 4: {
                primitive.setValue(a.extract_ushort());
                break;
            }
            case 3: {
                primitive.setValue(a.extract_long());
                break;
            }
            case 5: {
                primitive.setValue(BigInteger.valueOf(a.extract_ulong()));
                break;
            }
            case 23: {
                primitive.setValue(a.extract_longlong());
                break;
            }
            case 24: {
                primitive.setValue(BigInteger.valueOf(a.extract_ulonglong()));
                break;
            }
            case 6: {
                primitive.setValue(Float.valueOf(a.extract_float()));
                break;
            }
            case 7: {
                primitive.setValue(a.extract_double());
                break;
            }
            case 18: {
                primitive.setValue(a.extract_string());
                break;
            }
            case 27: {
                primitive.setValue(a.extract_wstring());
                break;
            }
            default: {
                throw new CorbaBindingException("Unable to extract type from any.  Kind = " + primitive.getTypeCode().kind().value());
            }
        }
    }

    private static synchronized Any createFixedAny(ORB orb, Any any, Bus bus) {
        if (fixedAnyConstructor == null) {
            CorbaFixedAnyImplClassCreator corbaFixedAnyImplClassCreator = (CorbaFixedAnyImplClassCreator)bus.getExtension(CorbaFixedAnyImplClassCreator.class);
            Class<?> c = corbaFixedAnyImplClassCreator.createFixedAnyClass();
            try {
                fixedAnyConstructor = c.getConstructor(ORB.class, Any.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return (Any)fixedAnyConstructor.newInstance(orb, any);
        }
        catch (Exception e) {
            return any;
        }
    }

    static {
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_BOOLEAN, CorbaConstants.NT_CORBA_BOOLEAN);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_BYTE, CorbaConstants.NT_CORBA_CHAR);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_UBYTE, CorbaConstants.NT_CORBA_OCTET);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_SHORT, CorbaConstants.NT_CORBA_SHORT);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_USHORT, CorbaConstants.NT_CORBA_USHORT);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_INT, CorbaConstants.NT_CORBA_LONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_UINT, CorbaConstants.NT_CORBA_ULONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_LONG, CorbaConstants.NT_CORBA_LONGLONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_ULONG, CorbaConstants.NT_CORBA_ULONGLONG);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_FLOAT, CorbaConstants.NT_CORBA_FLOAT);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_DOUBLE, CorbaConstants.NT_CORBA_DOUBLE);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_STRING, CorbaConstants.NT_CORBA_STRING);
        SCHEMA_TO_IDL_TYPES.put(W3CConstants.NT_SCHEMA_ANYTYPE, CorbaConstants.NT_CORBA_ANY);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_BOOLEAN, W3CConstants.NT_SCHEMA_BOOLEAN);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_CHAR, W3CConstants.NT_SCHEMA_BYTE);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_WCHAR, W3CConstants.NT_SCHEMA_STRING);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_OCTET, W3CConstants.NT_SCHEMA_UBYTE);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_SHORT, W3CConstants.NT_SCHEMA_SHORT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_USHORT, W3CConstants.NT_SCHEMA_USHORT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_LONG, W3CConstants.NT_SCHEMA_INT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_ULONG, W3CConstants.NT_SCHEMA_UINT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_LONGLONG, W3CConstants.NT_SCHEMA_LONG);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_ULONGLONG, W3CConstants.NT_SCHEMA_ULONG);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_FLOAT, W3CConstants.NT_SCHEMA_FLOAT);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_DOUBLE, W3CConstants.NT_SCHEMA_DOUBLE);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_STRING, W3CConstants.NT_SCHEMA_STRING);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_WSTRING, W3CConstants.NT_SCHEMA_STRING);
        IDL_TO_SCHEMA_TYPES.put(CorbaConstants.NT_CORBA_ANY, W3CConstants.NT_SCHEMA_ANYTYPE);
    }
}

