/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.SessionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.SessionFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class SessionView
extends ActiveMQAbstractView<ServerSession> {
    private static final String defaultSortColumn = SessionField.ID.getName();

    public SessionView() {
        this.predicate = new SessionFilterPredicate();
    }

    @Override
    public Class getClassT() {
        return ServerSession.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerSession session) {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(SessionField.ID.getName(), this.toString(session.getName())).add(SessionField.USER.getName(), this.toString(session.getUsername())).add(SessionField.VALIDATED_USER.getName(), this.toString(session.getValidatedUser())).add(SessionField.CREATION_TIME.getName(), new Date(session.getCreationTime()).toString()).add(SessionField.CONSUMER_COUNT.getName(), session.getConsumerCount()).add(SessionField.PRODUCER_COUNT.getName(), session.getProducerCount()).add(SessionField.CONNECTION_ID.getName(), session.getConnectionID().toString()).add(SessionField.CLIENT_ID.getName(), session.getRemotingConnection().getClientID() != null ? session.getRemotingConnection().getClientID() : "");
        return obj;
    }

    @Override
    public Object getField(ServerSession session, String fieldName) {
        SessionField field = SessionField.valueOfName(fieldName);
        switch (field) {
            case ID: {
                return session.getName();
            }
            case USER: {
                return session.getUsername();
            }
            case VALIDATED_USER: {
                return session.getValidatedUser();
            }
            case CREATION_TIME: {
                return new Date(session.getCreationTime());
            }
            case CONSUMER_COUNT: {
                return session.getConsumerCount();
            }
            case PRODUCER_COUNT: {
                return session.getProducerCount();
            }
            case CONNECTION_ID: {
                return session.getConnectionID();
            }
            case CLIENT_ID: {
                return session.getRemotingConnection().getClientID();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

