/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.context;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SubjectQuery;
import org.slf4j.Logger;

public final class SAMLSubjectNameIdentifierContext
extends BaseContext {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SAMLSubjectNameIdentifierContext.class);
    @Nullable
    private SAMLObject nameID;

    @Nullable
    public SAMLObject getSubjectNameIdentifier() {
        if (this.nameID == null) {
            this.nameID = this.resolveNameIdentifier();
        }
        return this.nameID;
    }

    @Nullable
    public NameIdentifier getSAML1SubjectNameIdentifier() {
        SAMLObject samlObject = this.getSubjectNameIdentifier();
        if (samlObject instanceof NameIdentifier) {
            return (NameIdentifier)samlObject;
        }
        return null;
    }

    @Nullable
    public NameID getSAML2SubjectNameID() {
        SAMLObject samlObject = this.getSubjectNameIdentifier();
        if (samlObject instanceof NameID) {
            return (NameID)samlObject;
        }
        return null;
    }

    public void setSubjectNameIdentifier(@Nullable SAMLObject newNameID) {
        if (newNameID != null && !(newNameID instanceof NameIdentifier) && !(newNameID instanceof NameID)) {
            throw new IllegalArgumentException("Argument was not a valid SAML 1 or 2 name identifier type or null: " + newNameID.getClass().getName());
        }
        this.nameID = newNameID;
    }

    @Nullable
    protected SAMLObject resolveNameIdentifier() {
        SAMLObject samlMessage = this.resolveSAMLMessage();
        if (samlMessage == null) {
            this.log.debug("SAML message could not be dynamically resolved from parent context");
            return null;
        }
        if (samlMessage instanceof SubjectQuery) {
            SubjectQuery msg = (SubjectQuery)samlMessage;
            org.opensaml.saml.saml2.core.Subject s = msg.getSubject();
            if (s != null) {
                return s.getNameID();
            }
            return null;
        }
        if (samlMessage instanceof AuthnRequest) {
            AuthnRequest msg = (AuthnRequest)samlMessage;
            org.opensaml.saml.saml2.core.Subject s = msg.getSubject();
            if (s != null) {
                return s.getNameID();
            }
            return null;
        }
        if (samlMessage instanceof Request) {
            Subject s;
            Request msg = (Request)samlMessage;
            org.opensaml.saml.saml1.core.SubjectQuery query = msg.getSubjectQuery();
            if (query != null && (s = query.getSubject()) != null) {
                return s.getNameIdentifier();
            }
            return null;
        }
        if (samlMessage instanceof LogoutRequest) {
            this.log.debug("Ignoring LogoutRequest, Subject does not require processing");
        } else {
            this.log.debug("Message in resolved parent message context was not a supported instance of SAMLObject: {}", (Object)samlMessage.getClass().getName());
        }
        return null;
    }

    @Nullable
    protected SAMLObject resolveSAMLMessage() {
        MessageContext mc;
        Object object;
        BaseContext baseContext = this.getParent();
        if (baseContext instanceof MessageContext && (object = (mc = (MessageContext)baseContext).getMessage()) instanceof SAMLObject) {
            SAMLObject msg = (SAMLObject)object;
            return msg;
        }
        return null;
    }
}

