/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.Version;
import java.io.IOException;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.netty.client.NettyHttpConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class NettyHttpConduitFactory
implements HTTPConduitFactory {
    public static final String USE_POLICY = "org.apache.cxf.transport.http.netty.usePolicy";
    UseAsyncPolicy policy;

    public NettyHttpConduitFactory() {
        Version.identify();
        String st = SystemPropertyAction.getPropertyOrNull((String)USE_POLICY);
        this.policy = UseAsyncPolicy.getPolicy(st);
    }

    public UseAsyncPolicy getUseAsyncPolicy() {
        return this.policy;
    }

    public HTTPConduit createConduit(HTTPTransportFactory f, Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        EventLoopGroup eventLoopGroup = (EventLoopGroup)bus.getExtension(EventLoopGroup.class);
        if (eventLoopGroup == null) {
            NioEventLoopGroup group = new NioEventLoopGroup();
            bus.setExtension((Object)group, EventLoopGroup.class);
            this.registerBusLifeListener(bus, (EventLoopGroup)group);
        }
        return new NettyHttpConduit(bus, localInfo, target, this);
    }

    public HTTPConduit createConduit(Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        return this.createConduit(null, bus, localInfo, target);
    }

    protected void registerBusLifeListener(Bus bus, final EventLoopGroup group) {
        BusLifeCycleManager lifeCycleManager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        if (null != lifeCycleManager) {
            lifeCycleManager.registerLifeCycleListener(new BusLifeCycleListener(){

                public void initComplete() {
                }

                public void preShutdown() {
                }

                public void postShutdown() {
                    group.shutdownGracefully().syncUninterruptibly();
                }
            });
        }
    }

    public static enum UseAsyncPolicy {
        ALWAYS,
        ASYNC_ONLY,
        NEVER;


        public static UseAsyncPolicy getPolicy(Object st) {
            if (st instanceof UseAsyncPolicy) {
                return (UseAsyncPolicy)((Object)st);
            }
            if (st instanceof String) {
                String s = ((String)st).toUpperCase();
                if ("ALWAYS".equals(s)) {
                    return ALWAYS;
                }
                if ("NEVER".equals(s)) {
                    return NEVER;
                }
                if ("ASYNC_ONLY".equals(s)) {
                    return ASYNC_ONLY;
                }
                st = Boolean.parseBoolean(s);
            }
            if (st instanceof Boolean) {
                return (Boolean)st != false ? ALWAYS : NEVER;
            }
            return ASYNC_ONLY;
        }
    }
}

