/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.notification;

import jakarta.xml.soap.SOAPMessage;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.eventing.FilterType;
import org.apache.cxf.ws.eventing.shared.utils.FilteringUtil;

public class FilteringInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private static final Logger LOG = LogUtils.getLogger(FilteringInterceptor.class);
    private FilterType filter;

    public FilteringInterceptor(FilterType filter) {
        super("post-marshal");
        this.filter = filter;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        if (this.filter == null || this.filter.getContent() == null) {
            LOG.info("No filter for this subscription");
            return;
        }
        SOAPMessage msg = (SOAPMessage)message.getContent(SOAPMessage.class);
        if (!FilteringUtil.runFilterOnMessage(msg, this.filter)) {
            message.getInterceptorChain().abort();
        }
    }
}

