/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesSketchIterator;

final class HeapArrayOfDoublesQuickSelectSketch
extends ArrayOfDoublesQuickSelectSketch {
    private final int lgNomEntries_;
    private final int lgResizeFactor_;
    private final float samplingProbability_;
    private int count_;
    private long[] keys_;
    private double[] values_;

    HeapArrayOfDoublesQuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, int numValues, long seed) {
        super(numValues, seed);
        this.lgNomEntries_ = org.apache.datasketches.common.Util.exactLog2OfLong(org.apache.datasketches.common.Util.ceilingPowerOf2(nomEntries));
        this.lgResizeFactor_ = lgResizeFactor;
        this.samplingProbability_ = samplingProbability;
        this.thetaLong_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        int startingCapacity = Util.getStartingCapacity(nomEntries, lgResizeFactor);
        this.keys_ = new long[startingCapacity];
        this.values_ = new double[startingCapacity * numValues];
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    HeapArrayOfDoublesQuickSelectSketch(MemorySegment seg, long seed) {
        super(seg.get(ValueLayout.JAVA_BYTE, 5L), seed);
        SerializerDeserializer.validateFamily(seg.get(ValueLayout.JAVA_BYTE, 2L), seg.get(ValueLayout.JAVA_BYTE, 0L));
        SerializerDeserializer.validateType(seg.get(ValueLayout.JAVA_BYTE, 3L), SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch);
        byte version = seg.get(ValueLayout.JAVA_BYTE, 1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        byte flags = seg.get(ValueLayout.JAVA_BYTE, 4L);
        org.apache.datasketches.common.Util.checkSeedHashes(seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L), org.apache.datasketches.common.Util.computeSeedHash(seed));
        this.isEmpty_ = (flags & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) > 0;
        this.lgNomEntries_ = seg.get(ValueLayout.JAVA_BYTE, 16L);
        this.thetaLong_ = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        int currentCapacity = 1 << seg.get(ValueLayout.JAVA_BYTE, 17L);
        this.lgResizeFactor_ = seg.get(ValueLayout.JAVA_BYTE, 18L);
        this.samplingProbability_ = seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 20L);
        this.keys_ = new long[currentCapacity];
        this.values_ = new double[currentCapacity * this.numValues_];
        boolean hasEntries = (flags & 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()) > 0;
        int n = this.count_ = hasEntries ? seg.get(ValueLayout.JAVA_INT_UNALIGNED, 24L) : 0;
        if (this.count_ > 0) {
            MemorySegment.copy(seg, ValueLayout.JAVA_LONG_UNALIGNED, 32L, this.keys_, 0, currentCapacity);
            long off = 32L + 8L * (long)currentCapacity;
            MemorySegment.copy(seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, off, this.values_, 0, currentCapacity * this.numValues_);
        }
        this.setRebuildThreshold();
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(currentCapacity);
    }

    @Override
    public double[][] getValues() {
        int numVal = this.numValues_;
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int cnt = 0;
            for (int j = 0; j < this.keys_.length; ++j) {
                if (this.keys_[j] == 0L) continue;
                values[cnt++] = Arrays.copyOfRange(this.values_, j * numVal, (j + 1) * numVal);
            }
            assert (cnt == count);
        }
        return values;
    }

    @Override
    double[] getValuesAsOneDimension() {
        int numVal = this.numValues_;
        int count = this.getRetainedEntries();
        double[] values = new double[count * numVal];
        if (count > 0) {
            int cnt = 0;
            for (int j = 0; j < this.keys_.length; ++j) {
                if (this.keys_[j] == 0L) continue;
                System.arraycopy(this.values_, j * numVal, values, cnt++ * numVal, numVal);
            }
            assert (cnt == count);
        }
        return values;
    }

    @Override
    long[] getKeys() {
        int count = this.getRetainedEntries();
        long[] keysArr = new long[count];
        if (count > 0) {
            int cnt = 0;
            for (int j = 0; j < this.keys_.length; ++j) {
                if (this.keys_[j] == 0L) continue;
                keysArr[cnt++] = this.keys_[j];
            }
            assert (cnt == count);
        }
        return keysArr;
    }

    @Override
    public int getRetainedEntries() {
        return this.count_;
    }

    @Override
    public int getNominalEntries() {
        return 1 << this.lgNomEntries_;
    }

    @Override
    public float getSamplingProbability() {
        return this.samplingProbability_;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.lgResizeFactor_);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byteArray = new byte[this.getSerializedSizeBytes()];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        this.serializeInto(seg);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new HeapArrayOfDoublesSketchIterator(this.keys_, this.values_, this.numValues_);
    }

    @Override
    int getSerializedSizeBytes() {
        return 32 + (8 + 8 * this.numValues_) * this.getCurrentCapacity();
    }

    @Override
    void serializeInto(MemorySegment seg) {
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)1);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.TUPLE.getID());
        seg.set(ValueLayout.JAVA_BYTE, 3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch.ordinal());
        seg.set(ValueLayout.JAVA_BYTE, 4L, (byte)((this.isInSamplingMode() ? 1 << ArrayOfDoublesSketch.Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (this.count_ > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        seg.set(ValueLayout.JAVA_BYTE, 5L, (byte)this.numValues_);
        seg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, org.apache.datasketches.common.Util.computeSeedHash(this.seed_));
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
        seg.set(ValueLayout.JAVA_BYTE, 16L, (byte)this.lgNomEntries_);
        seg.set(ValueLayout.JAVA_BYTE, 17L, (byte)Integer.numberOfTrailingZeros(this.keys_.length));
        seg.set(ValueLayout.JAVA_BYTE, 18L, (byte)this.lgResizeFactor_);
        seg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, 20L, this.samplingProbability_);
        seg.set(ValueLayout.JAVA_INT_UNALIGNED, 24L, this.count_);
        if (this.count_ > 0) {
            MemorySegment.copy(this.keys_, 0, seg, ValueLayout.JAVA_LONG_UNALIGNED, 32L, this.keys_.length);
            long off = 32L + 8L * (long)this.keys_.length;
            MemorySegment.copy(this.values_, 0, seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, off, this.values_.length);
        }
    }

    @Override
    public boolean hasMemorySegment() {
        return false;
    }

    @Override
    MemorySegment getMemorySegment() {
        return null;
    }

    @Override
    public void reset() {
        this.isEmpty_ = true;
        this.count_ = 0;
        this.thetaLong_ = (long)(9.223372036854776E18 * (double)this.samplingProbability_);
        int startingCapacity = Util.getStartingCapacity(1 << this.lgNomEntries_, this.lgResizeFactor_);
        this.keys_ = new long[startingCapacity];
        this.values_ = new double[startingCapacity * this.numValues_];
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    @Override
    protected long getKey(int index) {
        return this.keys_[index];
    }

    @Override
    protected void incrementCount() {
        ++this.count_;
    }

    @Override
    protected void setValues(int index, double[] values) {
        if (this.numValues_ == 1) {
            this.values_[index] = values[0];
        } else {
            System.arraycopy(values, 0, this.values_, index * this.numValues_, this.numValues_);
        }
    }

    @Override
    protected void updateValues(int index, double[] values) {
        if (this.numValues_ == 1) {
            int n = index;
            this.values_[n] = this.values_[n] + values[0];
        } else {
            int offset = index * this.numValues_;
            for (int i = 0; i < this.numValues_; ++i) {
                int n = offset + i;
                this.values_[n] = this.values_[n] + values[i];
            }
        }
    }

    @Override
    protected void setNotEmpty() {
        this.isEmpty_ = false;
    }

    @Override
    protected boolean isInSamplingMode() {
        return this.samplingProbability_ < 1.0f;
    }

    @Override
    protected void setThetaLong(long thetaLong) {
        this.thetaLong_ = thetaLong;
    }

    @Override
    protected int getCurrentCapacity() {
        return this.keys_.length;
    }

    @Override
    protected void rebuild(int newCapacity) {
        long[] oldKeys = this.keys_;
        double[] oldValues = this.values_;
        this.keys_ = new long[newCapacity];
        this.values_ = new double[newCapacity * this.numValues_];
        this.count_ = 0;
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newCapacity);
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == 0L || oldKeys[i] >= this.thetaLong_) continue;
            this.insert(oldKeys[i], Arrays.copyOfRange(oldValues, i * this.numValues_, (i + 1) * this.numValues_));
        }
        this.setRebuildThreshold();
    }

    @Override
    protected int insertKey(long key) {
        return HashOperations.hashInsertOnly(this.keys_, this.lgCurrentCapacity_, key);
    }

    @Override
    protected int findOrInsertKey(long key) {
        return HashOperations.hashSearchOrInsert(this.keys_, this.lgCurrentCapacity_, key);
    }

    @Override
    protected double[] find(long key) {
        int index = HashOperations.hashSearch(this.keys_, this.lgCurrentCapacity_, key);
        if (index == -1) {
            return null;
        }
        return Arrays.copyOfRange(this.values_, index * this.numValues_, (index + 1) * this.numValues_);
    }
}

