/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ppolicy_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyContainer;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyTags;
import org.apache.directory.api.ldap.model.message.Control;

public class PasswordPolicyDecorator
extends ControlDecorator<PasswordPolicy>
implements PasswordPolicy {
    private static final Asn1Decoder DECODER = new Asn1Decoder();
    private int ppolicySeqLength = 0;
    private int warningLength = 0;

    public PasswordPolicyDecorator(LdapApiService codec) {
        super(codec, (Control)new PasswordPolicyImpl());
    }

    public PasswordPolicyDecorator(LdapApiService codec, boolean hasResponse) {
        super(codec, (Control)new PasswordPolicyImpl(hasResponse));
    }

    public PasswordPolicyDecorator(LdapApiService codec, PasswordPolicy policy) {
        super(codec, (Control)policy);
    }

    public void setValue(byte[] value) {
        if (value == null || value.length <= 2) {
            this.setResponse(null);
        } else if (!this.hasResponse()) {
            this.setResponse(true);
        }
        super.setValue(value);
    }

    public int computeLength() {
        this.valueLength = 0;
        this.ppolicySeqLength = 0;
        this.warningLength = 0;
        if (!this.hasResponse()) {
            return 0;
        }
        if (this.getResponse().getTimeBeforeExpiration() >= 0) {
            int timeBeforeExpirationValueLength = BerValue.getNbBytes((int)this.getResponse().getTimeBeforeExpiration());
            this.warningLength = 1 + TLV.getNbBytes((int)timeBeforeExpirationValueLength) + timeBeforeExpirationValueLength;
        } else if (this.getResponse().getGraceAuthNRemaining() >= 0) {
            int graceAuthNsRemainingValueLength = BerValue.getNbBytes((int)this.getResponse().getGraceAuthNRemaining());
            this.warningLength = 1 + TLV.getNbBytes((int)graceAuthNsRemainingValueLength) + graceAuthNsRemainingValueLength;
        }
        if (this.warningLength != 0) {
            this.ppolicySeqLength = 1 + TLV.getNbBytes((int)this.warningLength) + this.warningLength;
        }
        if (this.getResponse().getPasswordPolicyError() != null) {
            this.ppolicySeqLength += 3;
        }
        this.valueLength = 1 + TLV.getNbBytes((int)this.ppolicySeqLength) + this.ppolicySeqLength;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (!this.hasResponse()) {
            return buffer;
        }
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.ppolicySeqLength));
        if (this.getResponse().getTimeBeforeExpiration() < 0 && this.getResponse().getGraceAuthNRemaining() < 0 && this.getResponse().getPasswordPolicyError() == null) {
            return buffer;
        }
        if (this.warningLength > 0) {
            buffer.put((byte)PasswordPolicyTags.PPOLICY_WARNING_TAG.getValue());
            buffer.put(TLV.getBytes((int)this.warningLength));
            if (this.getResponse().getTimeBeforeExpiration() >= 0) {
                BerValue.encode((ByteBuffer)buffer, (byte)((byte)PasswordPolicyTags.TIME_BEFORE_EXPIRATION_TAG.getValue()), (int)this.getResponse().getTimeBeforeExpiration());
            } else if (this.getResponse().getGraceAuthNRemaining() >= 0) {
                BerValue.encode((ByteBuffer)buffer, (byte)((byte)PasswordPolicyTags.GRACE_AUTHNS_REMAINING_TAG.getValue()), (int)this.getResponse().getGraceAuthNRemaining());
            }
        }
        if (this.getResponse().getPasswordPolicyError() != null) {
            BerValue.encode((ByteBuffer)buffer, (byte)((byte)PasswordPolicyTags.PPOLICY_ERROR_TAG.getValue()), (int)this.getResponse().getPasswordPolicyError().getValue());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  PasswordPolicyResponse control :\n");
        sb.append("   oid          : '").append(this.getOid()).append('\n');
        if (this.hasResponse() && this.getResponse().getTimeBeforeExpiration() >= 0) {
            sb.append("   timeBeforeExpiration          : '").append(this.getResponse().getTimeBeforeExpiration()).append('\n');
        } else if (this.hasResponse() && this.getResponse().getGraceAuthNRemaining() >= 0) {
            sb.append("   graceAuthNsRemaining          : '").append(this.getResponse().getGraceAuthNRemaining()).append('\n');
        }
        if (this.hasResponse() && this.getResponse().getPasswordPolicyError() != null) {
            sb.append("   ppolicyError          : '").append(this.getResponse().getPasswordPolicyError().toString()).append('\n');
        }
        return sb.toString();
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        if (!this.hasResponse()) {
            return this;
        }
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        PasswordPolicyContainer container = new PasswordPolicyContainer(this.getCodecService(), this);
        DECODER.decode(bb, (Asn1Container)container);
        return this;
    }

    public boolean hasResponse() {
        return ((PasswordPolicy)this.getDecorated()).hasResponse();
    }

    public void setResponse(PasswordPolicyResponse response) {
        ((PasswordPolicy)this.getDecorated()).setResponse(response);
    }

    public PasswordPolicyResponse setResponse(boolean hasResponse) {
        return ((PasswordPolicy)this.getDecorated()).setResponse(hasResponse);
    }

    public PasswordPolicyResponse getResponse() {
        return ((PasswordPolicy)this.getDecorated()).getResponse();
    }
}

