/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.browser;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserViewActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserViewUniversalListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart {
    private BrowserConfiguration configuration;
    private BrowserViewUniversalListener universalListener;
    private BrowserViewActionGroup actionGroup;
    private BrowserWidget mainWidget;

    public static String getId() {
        return BrowserUIConstants.VIEW_BROWSER_VIEW;
    }

    public void setFocus() {
        this.mainWidget.getViewer().getControl().setFocus();
    }

    public void dispose() {
        if (this.configuration != null) {
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.universalListener.dispose();
            this.universalListener = null;
            this.configuration.dispose();
            this.configuration = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.getSite().setSelectionProvider(null);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_browser_view");
        this.configuration = new BrowserConfiguration();
        this.mainWidget = new BrowserWidget(this.configuration, this.getViewSite().getActionBars());
        this.mainWidget.createWidget(composite);
        this.mainWidget.setInput((Object)this.getSite());
        this.actionGroup = new BrowserViewActionGroup(this);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.enableGlobalActionHandlers(this.getViewSite().getActionBars());
        IMenuManager contextMenuManager = this.mainWidget.getContextMenuManager();
        this.actionGroup.fillContextMenu(contextMenuManager);
        this.getSite().registerContextMenu((MenuManager)contextMenuManager, (ISelectionProvider)this.mainWidget.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.mainWidget.getViewer());
        this.universalListener = new BrowserViewUniversalListener(this);
    }

    public void select(Object obj) {
        ISearch objectToSelect = null;
        if (obj instanceof ISearch) {
            ISearch search = (ISearch)obj;
            this.universalListener.setInput(search.getBrowserConnection());
            this.mainWidget.getViewer().expandToLevel((Object)search, 0);
            objectToSelect = search;
        }
        if (obj instanceof ISearchResult) {
            ISearchResult searchResult = (ISearchResult)obj;
            ISearch search = searchResult.getSearch();
            this.universalListener.setInput(search.getBrowserConnection());
            this.mainWidget.getViewer().expandToLevel((Object)search, 1);
            objectToSelect = searchResult;
        }
        if (obj instanceof IBookmark) {
            IBookmark bookmark = (IBookmark)obj;
            this.universalListener.setInput(bookmark.getBrowserConnection());
            this.mainWidget.getViewer().expandToLevel((Object)bookmark, 0);
            objectToSelect = bookmark;
        }
        if (obj instanceof IEntry) {
            IEntry entry = (IEntry)obj;
            this.universalListener.setInput(entry.getBrowserConnection());
            ArrayList<IEntry> entryList = new ArrayList<IEntry>();
            IEntry tempEntry = entry;
            while (tempEntry.getParententry() != null) {
                IEntry parentEntry = tempEntry.getParententry();
                entryList.add(0, tempEntry);
                tempEntry = parentEntry;
            }
            for (IEntry childEntry : entryList) {
                IEntry parentEntry = childEntry.getParententry();
                if (!parentEntry.isChildrenInitialized()) {
                    parentEntry.setChildrenInitialized(true);
                    parentEntry.setHasMoreChildren(true);
                }
                if (!Arrays.asList(parentEntry.getChildren()).contains(childEntry)) {
                    parentEntry.addChild(childEntry);
                }
                this.mainWidget.getViewer().refresh((Object)parentEntry, true);
            }
            objectToSelect = entry;
        }
        if (objectToSelect != null) {
            this.mainWidget.getViewer().reveal((Object)objectToSelect);
            this.mainWidget.getViewer().refresh((Object)objectToSelect, true);
            this.mainWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)objectToSelect), true);
        }
    }

    public Object getAdapter(Class required) {
        if (IShowInTarget.class.equals((Object)required)) {
            return new IShowInTarget(){

                public boolean show(ShowInContext context) {
                    StructuredSelection selection = (StructuredSelection)context.getSelection();
                    Object obj = selection.getFirstElement();
                    if (obj instanceof IValue) {
                        IValue value = (IValue)obj;
                        IEntry entry = value.getAttribute().getEntry();
                        entry = entry.getBrowserConnection().getEntryFromCache(entry.getDn());
                        BrowserView.this.select(entry);
                    } else if (obj instanceof IAttribute) {
                        IAttribute attribute = (IAttribute)obj;
                        IEntry entry = attribute.getEntry();
                        entry = entry.getBrowserConnection().getEntryFromCache(entry.getDn());
                        BrowserView.this.select(entry);
                    } else if (obj instanceof ISearchResult) {
                        ISearchResult sr = (ISearchResult)obj;
                        ISearch search = sr.getSearch();
                        search = search.getBrowserConnection().getSearchManager().getSearch(search.getName());
                        BrowserView.this.select(search);
                    }
                    return true;
                }
            };
        }
        return null;
    }

    public BrowserViewActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public BrowserConfiguration getConfiguration() {
        return this.configuration;
    }

    public BrowserWidget getMainWidget() {
        return this.mainWidget;
    }

    public BrowserViewUniversalListener getUniversalListener() {
        return this.universalListener;
    }
}

