/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.studio.ldapservers.LdapServerAdapterExtensionsManager;
import org.apache.directory.studio.ldapservers.LdapServersManagerIOException;
import org.apache.directory.studio.ldapservers.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.model.UnknownLdapServerAdapterExtension;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class LdapServersManagerIO {
    private static final String LDAP_SERVERS_TAG = "ldapServers";
    private static final String LDAP_SERVER_TAG = "ldapServer";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ADAPTER_ID_ATTRIBUTE = "adapterId";
    private static final String ADAPTER_NAME_ATTRIBUTE = "adapterName";
    private static final String ADAPTER_VENDOR_ATTRIBUTE = "adapterVendor";
    private static final String ADAPTER_VERSION_ATTRIBUTE = "adapterVersion";
    private static final String CONFIGURATION_PARAMETERS_TAG = "configurationParameters";
    private static final String ENTRY_TAG = "entry";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String VALUE_ATTRIBUTE = "value";

    public static List<LdapServer> read(InputStream stream) throws LdapServersManagerIOException {
        ArrayList<LdapServer> servers = new ArrayList<LdapServer>();
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(stream);
        }
        catch (DocumentException e) {
            throw new LdapServersManagerIOException(e.getMessage());
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(LDAP_SERVERS_TAG)) {
            throw new LdapServersManagerIOException(Messages.getString("LdapServersManagerIO.ErrorNotValidServersFile"));
        }
        Iterator i = rootElement.elementIterator(LDAP_SERVER_TAG);
        while (i.hasNext()) {
            servers.add(LdapServersManagerIO.readLdapServer((Element)i.next()));
        }
        return servers;
    }

    private static LdapServer readLdapServer(Element element) {
        Element configurationParametersElement;
        Attribute adapterIdAttribute;
        Attribute nameAttribute;
        LdapServer server = new LdapServer();
        Attribute idAttribute = element.attribute(ID_ATTRIBUTE);
        if (idAttribute != null) {
            server.setId(idAttribute.getValue());
        }
        if ((nameAttribute = element.attribute(NAME_ATTRIBUTE)) != null) {
            server.setName(nameAttribute.getValue());
        }
        if ((adapterIdAttribute = element.attribute(ADAPTER_ID_ATTRIBUTE)) != null) {
            String adapterId = adapterIdAttribute.getValue();
            LdapServerAdapterExtension ldapServerAdapterExtension = LdapServerAdapterExtensionsManager.getDefault().getLdapServerAdapterExtensionById(adapterId);
            if (ldapServerAdapterExtension != null) {
                server.setLdapServerAdapterExtension(ldapServerAdapterExtension);
            } else {
                Attribute adapterVersionAttribute;
                Attribute adapterVendorAttribute;
                UnknownLdapServerAdapterExtension unknownLdapServerAdapterExtension = new UnknownLdapServerAdapterExtension();
                unknownLdapServerAdapterExtension.setId(adapterId);
                Attribute adapterNameAttribute = element.attribute(ADAPTER_NAME_ATTRIBUTE);
                if (adapterNameAttribute != null) {
                    unknownLdapServerAdapterExtension.setName(adapterNameAttribute.getValue());
                }
                if ((adapterVendorAttribute = element.attribute(ADAPTER_VENDOR_ATTRIBUTE)) != null) {
                    unknownLdapServerAdapterExtension.setVendor(adapterVendorAttribute.getValue());
                }
                if ((adapterVersionAttribute = element.attribute(ADAPTER_VERSION_ATTRIBUTE)) != null) {
                    unknownLdapServerAdapterExtension.setVersion(adapterVersionAttribute.getValue());
                }
                server.setLdapServerAdapterExtension(unknownLdapServerAdapterExtension);
            }
        }
        if ((configurationParametersElement = element.element(CONFIGURATION_PARAMETERS_TAG)) != null) {
            Iterator i = configurationParametersElement.elementIterator(ENTRY_TAG);
            while (i.hasNext()) {
                LdapServersManagerIO.readConfigurationParameter(server, (Element)i.next());
            }
        }
        return server;
    }

    private static void readConfigurationParameter(LdapServer server, Element element) {
        Attribute keyAttribute = element.attribute(KEY_ATTRIBUTE);
        String key = null;
        if (keyAttribute != null) {
            key = keyAttribute.getValue();
            Attribute valueAttribute = element.attribute(VALUE_ATTRIBUTE);
            String value = null;
            if (valueAttribute != null) {
                value = valueAttribute.getValue();
            }
            Attribute typeAttribute = element.attribute(TYPE_ATTRIBUTE);
            String type = null;
            if (typeAttribute != null) {
                type = typeAttribute.getValue();
            }
            if (type != null && type.equalsIgnoreCase(Integer.class.getCanonicalName())) {
                server.putConfigurationParameter(key, Integer.parseInt(value));
            } else if (type != null && type.equalsIgnoreCase(Boolean.class.getCanonicalName())) {
                server.putConfigurationParameter(key, Boolean.parseBoolean(value));
            } else {
                server.putConfigurationParameter(key, value);
            }
        }
    }

    public static void write(List<LdapServer> servers, OutputStream outputStream) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(LDAP_SERVERS_TAG);
        if (servers != null) {
            for (LdapServer server : servers) {
                LdapServersManagerIO.addLdapServer(server, root);
            }
        }
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter(outputStream, outformat);
        writer.write(document);
        writer.flush();
    }

    private static void addLdapServer(LdapServer server, Element parent) {
        Element serverElement = parent.addElement(LDAP_SERVER_TAG);
        serverElement.addAttribute(ID_ATTRIBUTE, server.getId());
        serverElement.addAttribute(NAME_ATTRIBUTE, server.getName());
        serverElement.addAttribute(ADAPTER_ID_ATTRIBUTE, server.getLdapServerAdapterExtension().getId());
        serverElement.addAttribute(ADAPTER_NAME_ATTRIBUTE, server.getLdapServerAdapterExtension().getName());
        serverElement.addAttribute(ADAPTER_VENDOR_ATTRIBUTE, server.getLdapServerAdapterExtension().getVendor());
        serverElement.addAttribute(ADAPTER_VERSION_ATTRIBUTE, server.getLdapServerAdapterExtension().getVersion());
        Map<String, Object> configurationParametersMap = server.getConfigurationParameters();
        if (configurationParametersMap != null && configurationParametersMap.size() > 0) {
            LdapServersManagerIO.addConfigurationParameters(configurationParametersMap, serverElement);
        }
    }

    private static void addConfigurationParameters(Map<String, Object> map, Element parent) {
        Element configurationParametersElement = parent.addElement(CONFIGURATION_PARAMETERS_TAG);
        Set<Map.Entry<String, Object>> entriesSet = map.entrySet();
        for (Map.Entry<String, Object> entry : entriesSet) {
            Element entryElement = configurationParametersElement.addElement(ENTRY_TAG);
            entryElement.addAttribute(KEY_ATTRIBUTE, entry.getKey());
            Object value = entry.getValue();
            entryElement.addAttribute(VALUE_ATTRIBUTE, value.toString());
            if (value.getClass() == String.class) continue;
            entryElement.addAttribute(TYPE_ATTRIBUTE, value.getClass().getCanonicalName());
        }
    }
}

