/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.Messages;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsExporter;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsImportException;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsImporter;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImportException;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImporter;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.widget.CoreSchemasSelectionWidget;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class PluginUtils {
    public static boolean verifyName(String name) {
        return name.matches("[a-zA-Z]+[a-zA-Z0-9;-]*");
    }

    public static AttributeType getClone(AttributeType at) {
        AttributeType clone = new AttributeType(at.getOid());
        clone.setNames(at.getNames());
        clone.setSchemaName(at.getSchemaName());
        clone.setDescription(at.getDescription());
        clone.setSuperiorOid(at.getSuperiorOid());
        clone.setUsage(at.getUsage());
        clone.setSyntaxOid(at.getSyntaxOid());
        clone.setSyntaxLength(at.getSyntaxLength());
        clone.setObsolete(at.isObsolete());
        clone.setSingleValued(at.isSingleValued());
        clone.setCollective(at.isCollective());
        clone.setUserModifiable(at.isUserModifiable());
        clone.setEqualityOid(at.getEqualityOid());
        clone.setOrderingOid(at.getOrderingOid());
        clone.setSubstringOid(at.getSubstringOid());
        return clone;
    }

    public static ObjectClass getClone(ObjectClass oc) {
        ObjectClass clone = new ObjectClass(oc.getOid());
        clone.setNames(oc.getNames());
        clone.setSchemaName(oc.getSchemaName());
        clone.setDescription(oc.getDescription());
        clone.setSuperiorOids(oc.getSuperiorOids());
        clone.setType(oc.getType());
        clone.setObsolete(oc.isObsolete());
        clone.setMustAttributeTypeOids(oc.getMustAttributeTypeOids());
        clone.setMayAttributeTypeOids(oc.getMayAttributeTypeOids());
        return clone;
    }

    private static File getProjectsFile() {
        return Activator.getDefault().getStateLocation().append("projects.xml").toFile();
    }

    private static File getTempProjectsFile() {
        return Activator.getDefault().getStateLocation().append("projects-temp.xml").toFile();
    }

    public static void loadProjects() {
        ProjectsHandler projectsHandler = Activator.getDefault().getProjectsHandler();
        File projectsFile = PluginUtils.getProjectsFile();
        boolean loadFailed = false;
        Project[] projects = null;
        if (projectsFile.exists()) {
            try {
                projects = ProjectsImporter.getProjects(new FileInputStream(projectsFile), projectsFile.getAbsolutePath());
            }
            catch (ProjectsImportException projectsImportException) {
                loadFailed = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                loadFailed = true;
            }
            if (!loadFailed) {
                Project[] projectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    Project project = projectArray[n2];
                    projectsHandler.addProject(project);
                    ++n2;
                }
            } else {
                File tempProjectsFile = PluginUtils.getTempProjectsFile();
                if (tempProjectsFile.exists()) {
                    try {
                        projects = ProjectsImporter.getProjects(new FileInputStream(tempProjectsFile), projectsFile.getAbsolutePath());
                        loadFailed = false;
                    }
                    catch (ProjectsImportException e) {
                        PluginUtils.reportError(Messages.getString("PluginUtils.ErrorLoadingProject"), e, Messages.getString("PluginUtils.ProjectsLoadingError"), Messages.getString("PluginUtils.ErrorLoadingProject"));
                        return;
                    }
                    catch (FileNotFoundException e) {
                        PluginUtils.reportError(Messages.getString("PluginUtils.ErrorLoadingProject"), e, Messages.getString("PluginUtils.ProjectsLoadingError"), Messages.getString("PluginUtils.ErrorLoadingProject"));
                        return;
                    }
                    Project[] projectArray = projects;
                    int n = projects.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Project project = projectArray[n3];
                        projectsHandler.addProject(project);
                        ++n3;
                    }
                } else {
                    PluginUtils.reportError(Messages.getString("PluginUtils.ErrorLoadingProject"), null, Messages.getString("PluginUtils.ProjectsLoadingError"), Messages.getString("PluginUtils.ErrorLoadingProject"));
                }
            }
        }
    }

    public static void saveProjects() {
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            outformat.setEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(PluginUtils.getTempProjectsFile()), outformat);
            writer.write(ProjectsExporter.toDocument(Activator.getDefault().getProjectsHandler().getProjects().toArray(new Project[0])));
            writer.flush();
            String content = FileUtils.readFileToString((File)PluginUtils.getTempProjectsFile(), (String)"UTF-8");
            FileUtils.writeStringToFile((File)PluginUtils.getProjectsFile(), (String)content, (String)"UTF-8");
        }
        catch (IOException iOException) {
            try {
                OutputFormat outformat = OutputFormat.createPrettyPrint();
                outformat.setEncoding("UTF-8");
                XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(PluginUtils.getProjectsFile()), outformat);
                writer.write(ProjectsExporter.toDocument(Activator.getDefault().getProjectsHandler().getProjects().toArray(new Project[0])));
                writer.flush();
            }
            catch (IOException e2) {
                PluginUtils.reportError(Messages.getString("PluginUtils.ErrorSavingProject"), e2, Messages.getString("PluginUtils.ProjectsSavingError"), Messages.getString("PluginUtils.ErrorSavingProject"));
            }
        }
    }

    public static void logError(String message, Throwable exception) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, message, exception));
    }

    public static void logInfo(Throwable exception, String message, Object ... args) {
        String msg = MessageFormat.format(message, args);
        Activator.getDefault().getLog().log((IStatus)new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 0, msg, exception));
    }

    public static void logWarning(String message, Throwable exception) {
        Activator.getDefault().getLog().log((IStatus)new Status(2, Activator.getDefault().getBundle().getSymbolicName(), 0, message, exception));
    }

    public static Schema loadCoreSchema(CoreSchemasSelectionWidget.ServerTypeEnum serverType, String schemaName) {
        Schema schema = null;
        try {
            URL url = Activator.getDefault().getBundle().getResource("resources/schemas/" + PluginUtils.getFolderName(serverType) + "/" + schemaName + ".xml");
            if (url == null) {
                PluginUtils.reportError(String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".", null, Messages.getString("PluginUtils.ProjectsLoadingError"), String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".");
            } else {
                schema = XMLSchemaFileImporter.getSchema(url.openStream(), url.toString());
            }
        }
        catch (XMLSchemaFileImportException e) {
            PluginUtils.reportError(String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".", e, Messages.getString("PluginUtils.ProjectsLoadingError"), String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".");
        }
        catch (FileNotFoundException e) {
            PluginUtils.reportError(String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".", e, Messages.getString("PluginUtils.ProjectsLoadingError"), String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".");
        }
        catch (IOException e) {
            PluginUtils.reportError(String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".", e, Messages.getString("PluginUtils.ProjectsLoadingError"), String.valueOf(Messages.getString("PluginUtils.SchemaLoadingError")) + schemaName + ".");
        }
        return schema;
    }

    private static void reportError(String loggerMessage, Exception e, String dialogTitle, String dialogMessage) {
        if (loggerMessage != null || e != null) {
            PluginUtils.logError(loggerMessage, e);
        }
        if (dialogMessage != null) {
            ViewUtils.displayErrorMessageDialog(dialogTitle == null ? "" : dialogTitle, dialogMessage);
        }
    }

    private static String getFolderName(CoreSchemasSelectionWidget.ServerTypeEnum serverType) {
        if (CoreSchemasSelectionWidget.ServerTypeEnum.APACHE_DS.equals((Object)serverType)) {
            return "apacheds";
        }
        if (CoreSchemasSelectionWidget.ServerTypeEnum.OPENLDAP.equals((Object)serverType)) {
            return "openldap";
        }
        return null;
    }

    public static Connection getConnection(String id) {
        Connection[] connectionsArray = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
        HashMap<String, Connection> connections = new HashMap<String, Connection>();
        Connection[] connectionArray = connectionsArray;
        int n = connectionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            connections.put(connection.getId(), connection);
            ++n2;
        }
        return (Connection)connections.get(id);
    }

    public static List<SchemaConnector> getSchemaConnectors() {
        ArrayList<SchemaConnector> schemaConnectors = new ArrayList<SchemaConnector>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.apache.directory.studio.schemaeditor.schemaConnectors");
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        if (members != null) {
            IConfigurationElement[] iConfigurationElementArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement member = iConfigurationElementArray[n2];
                try {
                    SchemaConnector schemaConnector = (SchemaConnector)member.createExecutableExtension("class");
                    schemaConnector.setName(member.getAttribute("name"));
                    schemaConnector.setId(member.getAttribute("id"));
                    schemaConnector.setDescription(member.getAttribute("description"));
                    schemaConnectors.add(schemaConnector);
                }
                catch (CoreException e) {
                    PluginUtils.logError(Messages.getString("PluginUtils.ConnectorsLoadingError"), e);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("PluginUtils.Error"), Messages.getString("PluginUtils.ConnectorsLoadingError"));
                }
                ++n2;
            }
        }
        return schemaConnectors;
    }

    public static void saveDialogSettingsHistory(String key, String value) {
        String[] history = PluginUtils.loadDialogSettingsHistory(key);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(history));
        if (list.contains(value)) {
            list.remove(value);
        }
        list.add(0, value);
        while (list.size() > 20) {
            list.remove(list.size() - 1);
        }
        history = list.toArray(new String[list.size()]);
        Activator.getDefault().getDialogSettings().put(key, history);
    }

    public static String[] loadDialogSettingsHistory(String key) {
        String[] history = Activator.getDefault().getDialogSettings().getArray(key);
        if (history == null) {
            history = new String[]{};
        }
        return history;
    }
}

