/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Optional;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;

public class OffsetAndTimestampInternal {
    private final long timestamp;
    private final long offset;
    private final Optional<Integer> leaderEpoch;

    public OffsetAndTimestampInternal(long offset, long timestamp, Optional<Integer> leaderEpoch) {
        this.offset = offset;
        this.timestamp = timestamp;
        this.leaderEpoch = leaderEpoch;
    }

    long offset() {
        return this.offset;
    }

    long timestamp() {
        return this.timestamp;
    }

    Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public OffsetAndTimestamp buildOffsetAndTimestamp() {
        return new OffsetAndTimestamp(this.offset, this.timestamp, this.leaderEpoch);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.leaderEpoch.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffsetAndTimestampInternal)) {
            return false;
        }
        OffsetAndTimestampInternal that = (OffsetAndTimestampInternal)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        return this.leaderEpoch.equals(that.leaderEpoch);
    }

    public String toString() {
        return "OffsetAndTimestampInternal{timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + String.valueOf(this.leaderEpoch) + "}";
    }
}

