/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.templates.interceptor;
import org.grails.forge.cli.command.templates.interceptorSpec;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.TemplateRenderer;
import picocli.CommandLine;

@CommandLine.Command(name="create-interceptor", description={"Creates a Interceptor Class"})
public class CreateInterceptorCommand
extends CodeGenCommand {
    public static final String NAME = "create-interceptor";
    @ReflectiveAccess
    @CommandLine.Parameters(paramLabel="INTERCEPTOR-NAME", description={"The name of the interceptor to create"})
    String interceptorName;

    @Inject
    public CreateInterceptorCommand(@Parameter CodeGenConfig config) {
        super(config);
    }

    public CreateInterceptorCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        super(config, outputHandlerSupplier, consoleOutput);
    }

    @Override
    public boolean applies() {
        return true;
    }

    @Override
    public Integer call() throws Exception {
        Project project = this.getProject(this.interceptorName);
        TemplateRenderer templateRenderer = this.getTemplateRenderer(project);
        RenderResult renderResult = templateRenderer.render(new RockerTemplate("grails-app/controllers/{packagePath}/{className}Interceptor.groovy", interceptor.template(project)), this.overwrite);
        RenderResult specRenderResult = templateRenderer.render(new RockerTemplate("src/test/groovy/{packagePath}/{className}InterceptorSpec.groovy", interceptorSpec.template(project)), this.overwrite);
        if (renderResult != null && specRenderResult != null) {
            this.logRenderResult(renderResult);
            this.logRenderResult(specRenderResult);
        }
        return 0;
    }

    private void logRenderResult(RenderResult result) throws Exception {
        if (result != null) {
            if (result.isSuccess()) {
                this.out("@|blue ||@ Rendered interceptor class to " + result.getPath());
            } else if (result.isSkipped()) {
                this.warning("Rendering skipped for " + result.getPath() + " because it already exists. Run again with -f to overwrite.");
            } else if (result.getError() != null) {
                throw result.getError();
            }
        }
    }
}

