/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.ArrayList;
import java.util.List;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixBatchMessageTask
implements MessageTask {
    private static Logger LOG = LoggerFactory.getLogger(HelixBatchMessageTask.class);
    final NotificationContext _context;
    final Message _batchMsg;
    final List<Message> _subMsgs;
    final List<MessageHandler> _handlers;

    public HelixBatchMessageTask(Message batchMsg, List<Message> subMsgs, List<MessageHandler> handlers, NotificationContext context) {
        this._batchMsg = batchMsg;
        this._context = context;
        this._subMsgs = subMsgs;
        this._handlers = handlers;
    }

    @Override
    public HelixTaskResult call() throws Exception {
        HelixTaskResult taskResult = null;
        long start = System.currentTimeMillis();
        LOG.info("BatchMsg task {} handling task begin, at: {}", (Object)this.getTaskId(), (Object)start);
        boolean isSucceed = true;
        try {
            for (MessageHandler handler : this._handlers) {
                HelixTaskResult subTaskResult;
                if (handler == null || (subTaskResult = handler.handleMessage()).isSuccess()) continue;
                isSucceed = false;
            }
        }
        catch (Exception e) {
            String errorMessage = "Exception while executing task: " + this.getTaskId();
            LOG.error(errorMessage, (Throwable)e);
            taskResult = new HelixTaskResult();
            taskResult.setException(e);
            taskResult.setMessage(e.getMessage());
            return taskResult;
        }
        if (isSucceed) {
            LOG.info("BatchMsg task {} completed successfully", (Object)this.getTaskId());
        } else {
            LOG.warn("BatchMsg task {} failed.", (Object)this.getTaskId());
        }
        taskResult = new HelixTaskResult();
        taskResult.setSuccess(isSucceed);
        return taskResult;
    }

    @Override
    public String getTaskId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._batchMsg.getId());
        sb.append("/");
        ArrayList<String> msgIdList = new ArrayList<String>();
        if (this._subMsgs != null) {
            for (Message msg : this._subMsgs) {
                msgIdList.add(msg.getId());
            }
        }
        sb.append(msgIdList);
        return sb.toString();
    }

    @Override
    public Message getMessage() {
        return this._batchMsg;
    }

    @Override
    public NotificationContext getNotificationContext() {
        return this._context;
    }

    @Override
    public void onTimeout() {
        for (MessageHandler handler : this._handlers) {
            if (handler == null) continue;
            handler.onTimeout();
        }
    }

    @Override
    public boolean cancel() {
        return false;
    }
}

