/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtil {
    public static final String SIMPLE_NAME = ExecutorUtil.class.getSimpleName();
    private static final AtomicInteger threadNum = new AtomicInteger(1);
    private static final ExecutorService executor = ExecutorUtil.init();

    private ExecutorUtil() {
    }

    private static ExecutorService init() {
        return Executors.newCachedThreadPool(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName(SIMPLE_NAME + " thread " + threadNum.getAndIncrement());
            return thread;
        });
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static void cleanup(Timer timer) {
        ExecutorUtil.cleanup(timer, 0L);
    }

    public static void cleanup(Timer timer, long delayMs) {
        Runnable runnable = () -> ExecutorUtil.cleanTimer(timer);
        if (delayMs <= 0L) {
            runnable.run();
            return;
        }
        executor.submit(() -> {
            try {
                TimeUnit.MILLISECONDS.sleep(delayMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            runnable.run();
        });
    }

    private static void cleanTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
    }
}

